#!/usr/bin/python
# -*- coding: utf-8 -*-
import logging, re, time, urllib2

import gobject, gtk
import hippo
import xml.dom.minidom
from xml.dom.minidom import Node
from StringIO import StringIO

from bigboard.stock import Stock
from bigboard.slideout import ThemedSlideout
import bigboard.google as google
import bigboard.google_stock as google_stock  
from bigboard.big_widgets import CanvasHBox, CanvasVBox, Button, Header, PrelightingCanvasBox
import bigboard.libbig as libbig
#TODO: add a scrollable view for emails
#import bigboard.scroll_ribbon as scroll_ribbon

import libgmail_patched as libgmail

_logger = logging.getLogger('bigboard.stocks.MailStock')

def replace_chr(m):
    return unichr(int(m.group(1), 16))
UNICHR_REPLACE = re.compile(r"\\u([A-F-a-f0-9]{4})")
def gmail_jshtml_str_parse(s, markup=False):
    # Replace \uxxxx escapes
    parsed_str = UNICHR_REPLACE.sub(replace_chr, s)
    parsed_str = unescape_html_entities(parsed_str)
    # At this point, we have a Python unicode string which *should* hold
    # an HTML fragment.  Convert that fragment into a document string.
    pystr = "<html>" + parsed_str + "</html>"
    # Now use BeautifulSoup to parse it
    from BeautifulSoup import BeautifulSoup
    soup = BeautifulSoup(pystr, convertEntities=BeautifulSoup.HTML_ENTITIES)
    textContent = StringIO()    
    def filterBoldOnly(node):       
        if isinstance(node, unicode):
            textContent.write(gobject.markup_escape_text(node))
            return
        if markup and node.name == 'b':
            in_bold = True
            textContent.write('<b>')
        else:
            in_bold = False
        for child in node.childGenerator():
            filterBoldOnly(child)
        if in_bold:
            textContent.write('</b>')
    filterBoldOnly(soup)
    # Return the sanely filtered content
    return textContent.getvalue()

class LabelSlideout(ThemedSlideout):
    __gsignals__ = {
                    'changed' : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, (gobject.TYPE_STRING, )),
                   }
    def __init__(self, ga):
        super(LabelSlideout, self).__init__()
        vbox = CanvasVBox(border_color=0x0000000ff, spacing=4)
        self.get_root().append(vbox)
        header = Header(topborder=False)
        account_text = hippo.CanvasText(classes='header', text=ga.name)
        header.append(account_text, hippo.PACK_EXPAND)        
        vbox.append(header)
        try:
            folderCounts = ga.getFolderCounts()
            folderCounts["unread"] = ga.getUnreadMsgCount()
        except urllib2.URLError:
            error = hippo.CanvasText(text=google_stock.FAILED_TO_CONNECT_STRING)
            vbox.append(error)    
            return

        for label, number in folderCounts.iteritems():
            box = PrelightingCanvasBox()
            box.connect('button-release-event', self.on_button_release_event, label)
            vbox.append(box)
            hbox = CanvasHBox(spacing=4, padding=4)
            text= hippo.CanvasText(text=label, xalign=hippo.ALIGNMENT_START)
            hbox.append(text)
            text= hippo.CanvasText(text=number, xalign=hippo.ALIGNMENT_START)
            hbox.append(text, flags=hippo.PACK_END)
            box.append(hbox)
    
    def on_button_release_event (self, hippo_item, event, label_text):
        self.emit('changed', label_text)

class EmailSlideout(ThemedSlideout):
    def __init__(self, thread):
        super(EmailSlideout, self).__init__()
        vbox = CanvasVBox(border_color=0x0000000ff, spacing=4)
        self.get_root().append(vbox)
        self.__header = Header(topborder=False)
        self.id = thread.id        

        subject = gmail_jshtml_str_parse(thread.subject)
        
        subject_box = hippo.CanvasText(classes='header', text=subject)
        self.__header.append(subject_box, hippo.PACK_EXPAND)
        vbox.append(self.__header)
        
        for key in ("date", "categories", "snippet"):
            value = getattr(thread, key, None)
            if value:
                if type(value) is list:
                    s = ", ".join(value)
                if type(value) is str:
                    _logger.debug("passing in %s" % value) 
                    s = gmail_jshtml_str_parse(value)

                box = hippo.CanvasText(text=s, xalign=hippo.ALIGNMENT_START)
                vbox.append(box)
        
        #todo: nicify email, strip out junk, and show actual email
        #email_source = thread[len(thread)-1].source
        #we could use a regular expression, but its not so simple.
        #exp = "^\\nReceived:.?\\nMessage-ID:.?\\nDate:.?\\nFrom:.?\\nTo:.?\\nSubject:.?\\n"
        # the following doesn't always work
        #psr =  email.parser.Parser()
        #print psr.parsestr(email_source).get_payload()

class MailStock(Stock, google_stock.GoogleStock):
    """Shows recent emails"""
    def __init__(self, *args, **kwargs):
        _logger.debug("in mail stock init")
        Stock.__init__(self, *args, **kwargs)
        google_stock.GoogleStock.__init__(self, 'gmail', **kwargs)

        self._box = hippo.CanvasBox(orientation=hippo.ORIENTATION_VERTICAL)
        
        self.__slideout = None
        self.__last_slideout_event_time = None       

        self.__current_gobj = None
        self.__google_account = None
        self.__folder = 'inbox'
        self.__logged_in = False  
        
        self.__display_limit = 4

        self._box.append(self._login_button)
        
        self._add_more_button(self.__on_more_button)
        _logger.debug("done with mail stock init")
        self._post_init()
                                
    def get_content(self, size):
        return self._box
    
    def update_google_data(self, gobj):
        self.__current_gobj = gobj
        username = gobj.get_account().get_username_as_google_email()
        password = gobj.get_account().get_password()
        self.__update_email_box(username, password)
   
    def remove_google_data(self, gobj):
        # sometimes we don't even get the self.__current_gobj because the polling task didn't start, so 
        # if all self.googles are removed, we should make sure to have the "Login to Google" button showing 
        if self.__current_gobj == gobj or len(self.googles) == 0: 
            self._box.remove_all()
            self._login_button.set_property('text', google_stock.LOGIN_TO_GOOGLE_STRING) 
            self._box.append(self._login_button)
            self.__google_account = None
            self.__logged_in = False

    def __update_email_box (self, username, password):       
        _logger.debug("will update mailbox")
        try:
            if self.__google_account is None or username != self.__google_account.name or \
               password != self.__google_account.password:
                self.__google_account = libgmail.GmailAccount(username, password)
                self.__google_account.login()
            elif not self.__logged_in:
                self.__google_account.login()                

            self.__logged_in = True

            if self.__folder == 'inbox':
                threads = self.__google_account.getMessagesByFolder(self.__folder)
            elif self.__folder == 'unread':
                threads = self.__google_account.getUnreadMessages()
            else:
                threads = self.__google_account.getMessagesByLabel(self.__folder)

            self._box.remove_all()
            account = hippo.CanvasText(classes='header', text=self.__google_account.name)
            self._box.append(account)
            
            box = PrelightingCanvasBox()
            box.connect("button-press-event", self.create_label_slideout, self.__google_account)
            self._box.append(box)
            label = hippo.CanvasText(text=self.__folder, font="14px Bold Italic")
            box.append(label)
            
            i = 0
            for thread in threads:
                if i >= self.__display_limit: break
                
                subject = gmail_jshtml_str_parse(thread.subject, True)
                
                box = PrelightingCanvasBox()
                box.connect("button-press-event", self.create_email_slideout, thread)
                self._box.append(box)
                email = hippo.CanvasText(markup=subject, xalign=hippo.ALIGNMENT_START)
                box.append(email)
                i += 1
            labelsDict = self.__google_account.getFolderCounts()
            footer = hippo.CanvasText(classes='footer', text="%s unread" % labelsDict['inbox'], font="14px Bold Italic")
            self._box.append(footer)
            print "updated mailbox"
            
        except libgmail.GmailLoginFailure:
            self._box.remove_all()
            self.__logged_in = False
            if self._login_button.get_property("text") == google_stock.CHECKING_LOGIN_STRING:
                error = hippo.CanvasText(text=google_stock.FAILED_TO_LOGIN_STRING, size_mode=hippo.CANVAS_SIZE_WRAP_WORD)
                self._box.append(error)
            self._login_button.set_property('text', google_stock.LOGIN_TO_GOOGLE_STRING) 
            self._box.append(self._login_button)
        except urllib2.URLError:
            if not self.__logged_in:
                self._box.remove_all()
               
            if len(self._box.get_children()) == 0 or \
               self._box.get_children()[0].get_property("text") != google_stock.FAILED_TO_CONNECT_STRING:
                error = hippo.CanvasText(text=google_stock.FAILED_TO_CONNECT_STRING, size_mode=hippo.CANVAS_SIZE_WRAP_WORD)
                self._box.prepend(error)                

    def show_slideout(self, widget):
        def on_slideout_close(s, action_taken):
            self.__last_slideout_event_time = gtk.get_current_event_time() 
            if action_taken:
                self._panel.action_taken()
            s.destroy()
        self.__slideout.connect('close', on_slideout_close)
        y = widget.get_context().translate_to_screen(widget)[1]
        if not self.__slideout.slideout_from(204, y):
            self.__slideout.destroy()
            self.__slideout = None
            return
    
    def create_label_slideout(self, widget, hippo_event, data):   
        if type(self.__slideout) is LabelSlideout and \
           self.__last_slideout_event_time == gtk.get_current_event_time():
            self.__slideout = None
            return 
        self.__slideout = LabelSlideout(data)
        self.__slideout.connect('changed', self.on_label_changed)
        self.show_slideout(widget)
    
    def create_email_slideout(self, widget, hippo_event, data):
        if type(self.__slideout) is EmailSlideout and self.__slideout.id == data.id and \
           self.__last_slideout_event_time == gtk.get_current_event_time():
            self.__slideout = None
            return 
        self.__slideout = EmailSlideout(data)
        self.show_slideout(widget)
    
    def on_label_changed (self, slideout, label):
        self.__folder = label
        self.__update_email_box(self.__google_account.name, None)
    
    def __on_more_button(self):
        libbig.show_url("http://mail.google.com/mail")

if __name__ == '__main__':
    assert unescape_html_entities("foo&hellip;bar") == "foo…bar"
    # We want to keep bold tags
    assert gmail_jshtml_str_parse(r'test \u003cb\>hi\u003c/b\> moo', True) == 'test <b>hi</b> moo'
    # Strip unknown tag "A"
    assert gmail_jshtml_str_parse(r'test \u003ca\>hi\u003c/a\> moo', True) == 'test hi moo'
    
