using System;
using System.Reflection;
using System.Runtime.CompilerServices;

[assembly: ApplicationVersion ("1.4.1", "1.4.1")]
[assembly: AssemblyVersion ("1.4.0.0")]
[assembly: AssemblyTitle ("Banshee")]
[assembly: AssemblyDescription ("Banshee Media Player")]
[assembly: AssemblyCopyright ("Copyright (C) 2005-2008 Novell, 2005 Aaron Bockover")]
[assembly: AssemblyCompany ("Novell, Inc.")]

[AttributeUsage (AttributeTargets.Assembly, Inherited = false)]
internal sealed class ApplicationVersionAttribute : Attribute
{
    private string release_version;
    public string ReleaseVersion {
        get { return release_version; }
    }

    private string display_version;
    public string DisplayVersion {
        get { return display_version; }
    }

    public ApplicationVersionAttribute (string releaseVersion, string displayVersion)
    {
        release_version = releaseVersion;
        display_version = displayVersion;
    }
}

