/* report.c generated by valac 0.11.2.24-c8ac0, the Vala compiler
 * generated from report.vala, do not modify */

/*
 * Copyright (C) 2008-2009 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* A Vala.Report subclass for reporting errors in Anjuta UI */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>


#define TYPE_ANJUTA_REPORT (anjuta_report_get_type ())
#define ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANJUTA_REPORT, AnjutaReport))
#define ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANJUTA_REPORT, AnjutaReportClass))
#define IS_ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANJUTA_REPORT))
#define IS_ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANJUTA_REPORT))
#define ANJUTA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANJUTA_REPORT, AnjutaReportClass))

typedef struct _AnjutaReport AnjutaReport;
typedef struct _AnjutaReportClass AnjutaReportClass;
typedef struct _AnjutaReportPrivate AnjutaReportPrivate;

#define ANJUTA_REPORT_TYPE_ERROR (anjuta_report_error_get_type ())
typedef struct _AnjutaReportError AnjutaReportError;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _anjuta_report_error_free0(var) ((var == NULL) ? NULL : (var = (anjuta_report_error_free (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _AnjutaReport {
	ValaReport parent_instance;
	AnjutaReportPrivate * priv;
};

struct _AnjutaReportClass {
	ValaReportClass parent_class;
};

struct _AnjutaReportError {
	ValaSourceReference* source;
	gboolean error;
	gchar* message;
};

struct _AnjutaReportPrivate {
	IAnjutaDocumentManager* _docman;
	ValaList* errors;
	GStaticRecMutex __lock_errors;
};


static gpointer anjuta_report_parent_class = NULL;
static GType anjuta_report_type_id = 0;

GType anjuta_report_get_type (void) G_GNUC_CONST;
GType anjuta_report_register_type (GTypeModule * module);
static GType anjuta_report_error_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static AnjutaReportError* anjuta_report_error_dup (const AnjutaReportError* self);
static void anjuta_report_error_free (AnjutaReportError* self);
static void anjuta_report_error_copy (const AnjutaReportError* self, AnjutaReportError* dest);
static void anjuta_report_error_destroy (AnjutaReportError* self);
#define ANJUTA_REPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ANJUTA_REPORT, AnjutaReportPrivate))
enum  {
	ANJUTA_REPORT_DUMMY_PROPERTY,
	ANJUTA_REPORT_DOCMAN
};
void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor);
void anjuta_report_clear_error_indicators (AnjutaReport* self);
IAnjutaDocumentManager* anjuta_report_get_docman (AnjutaReport* self);
void anjuta_report_on_hover_over (AnjutaReport* self, IAnjutaEditorHover* editor, GObject* pos);
static void anjuta_report_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void anjuta_report_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message);
gboolean anjuta_report_errors_found (AnjutaReport* self);
AnjutaReport* anjuta_report_new (void);
AnjutaReport* anjuta_report_construct (GType object_type);
void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value);
static void anjuta_report_finalize (GObject* obj);
static void _vala_anjuta_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_anjuta_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor) {
	IAnjutaEditor* _tmp0_;
	IAnjutaIndicable* _tmp1_;
	IAnjutaIndicable* ind;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = editor, IANJUTA_IS_INDICABLE (_tmp0_) ? ((IAnjutaIndicable*) _tmp0_) : NULL));
	ind = _tmp1_;
	if (ind == NULL) {
		_g_object_unref0 (ind);
		return;
	}
	ianjuta_indicable_clear (ind, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ind);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		ValaList* _tmp2_;
		ValaList* _e_list;
		gint _tmp3_;
		gint _e_size;
		gint _e_index;
		_tmp2_ = _vala_iterable_ref0 (self->priv->errors);
		_e_list = _tmp2_;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _e_list);
		_e_size = _tmp3_;
		_e_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			AnjutaReportError* e;
			const gchar* _tmp5_ = NULL;
			const gchar* _tmp6_;
			ValaSourceFile* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp4_ = vala_list_get (_e_list, _e_index);
			e = (AnjutaReportError*) _tmp4_;
			_tmp5_ = ianjuta_document_get_filename (IANJUTA_DOCUMENT (editor), &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				_anjuta_report_error_free0 (e);
				_vala_iterable_unref0 (_e_list);
				_g_object_unref0 (ind);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp7_ = vala_source_reference_get_file ((*e).source);
			_tmp8_ = vala_source_file_get_filename (_tmp7_);
			_tmp9_ = g_str_has_suffix (_tmp8_, _tmp6_);
			if (_tmp9_) {
				gint _tmp10_;
				IAnjutaIterable* _tmp11_ = NULL;
				IAnjutaIterable* _tmp12_;
				IAnjutaIterable* begin_iter;
				gint _tmp15_;
				IAnjutaIterable* _tmp16_ = NULL;
				IAnjutaIterable* _tmp17_;
				IAnjutaIterable* end_iter;
				IAnjutaIndicableIndicator _tmp20_ = 0;
				_tmp10_ = vala_source_reference_get_first_line ((*e).source);
				_tmp11_ = ianjuta_editor_get_line_begin_position (editor, _tmp10_, &_inner_error_);
				_tmp12_ = _g_object_ref0 (_tmp11_);
				begin_iter = _tmp12_;
				if (_inner_error_ != NULL) {
					_anjuta_report_error_free0 (e);
					_vala_iterable_unref0 (_e_list);
					_g_object_unref0 (ind);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				{
					gint i;
					i = 1;
					{
						gboolean _tmp13_;
						_tmp13_ = TRUE;
						while (TRUE) {
							gint _tmp14_;
							if (!_tmp13_) {
								i++;
							}
							_tmp13_ = FALSE;
							_tmp14_ = vala_source_reference_get_first_column ((*e).source);
							if (!(i < _tmp14_)) {
								break;
							}
							ianjuta_iterable_next (begin_iter, &_inner_error_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (begin_iter);
								_anjuta_report_error_free0 (e);
								_vala_iterable_unref0 (_e_list);
								_g_object_unref0 (ind);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
				_tmp15_ = vala_source_reference_get_last_line ((*e).source);
				_tmp16_ = ianjuta_editor_get_line_begin_position (editor, _tmp15_, &_inner_error_);
				_tmp17_ = _g_object_ref0 (_tmp16_);
				end_iter = _tmp17_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (begin_iter);
					_anjuta_report_error_free0 (e);
					_vala_iterable_unref0 (_e_list);
					_g_object_unref0 (ind);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				{
					gint i;
					i = 0;
					{
						gboolean _tmp18_;
						_tmp18_ = TRUE;
						while (TRUE) {
							gint _tmp19_;
							if (!_tmp18_) {
								i++;
							}
							_tmp18_ = FALSE;
							_tmp19_ = vala_source_reference_get_last_column ((*e).source);
							if (!(i < _tmp19_)) {
								break;
							}
							ianjuta_iterable_next (end_iter, &_inner_error_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (end_iter);
								_g_object_unref0 (begin_iter);
								_anjuta_report_error_free0 (e);
								_vala_iterable_unref0 (_e_list);
								_g_object_unref0 (ind);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
				if ((*e).error) {
					_tmp20_ = IANJUTA_INDICABLE_CRITICAL;
				} else {
					_tmp20_ = IANJUTA_INDICABLE_WARNING;
				}
				ianjuta_indicable_set (ind, begin_iter, end_iter, _tmp20_, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (end_iter);
					_g_object_unref0 (begin_iter);
					_anjuta_report_error_free0 (e);
					_vala_iterable_unref0 (_e_list);
					_g_object_unref0 (ind);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (end_iter);
				_g_object_unref0 (begin_iter);
			}
			_anjuta_report_error_free0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_g_object_unref0 (ind);
}


void anjuta_report_clear_error_indicators (AnjutaReport* self) {
	ValaArrayList* _tmp0_ = NULL;
	ValaList* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_array_list_new (ANJUTA_REPORT_TYPE_ERROR, (GBoxedCopyFunc) anjuta_report_error_dup, anjuta_report_error_free, g_direct_equal);
	_tmp1_ = (ValaList*) _tmp0_;
	_vala_iterable_unref0 (self->priv->errors);
	self->priv->errors = _tmp1_;
	_tmp2_ = ianjuta_document_manager_get_doc_widgets (self->priv->_docman, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = (GList*) _tmp3_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			GtkWidget* _tmp4_;
			GtkWidget* doc;
			_tmp4_ = _g_object_ref0 ((GtkWidget*) doc_it->data);
			doc = _tmp4_;
			{
				if (IANJUTA_IS_INDICABLE (doc)) {
					ianjuta_indicable_clear (IANJUTA_INDICABLE (doc), &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (doc);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_object_unref0 (doc);
			}
		}
	}
}


void anjuta_report_on_hover_over (AnjutaReport* self, IAnjutaEditorHover* editor, GObject* pos) {
	IAnjutaIterable* _tmp0_;
	IAnjutaIterable* position;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (pos != NULL);
	_tmp0_ = _g_object_ref0 (IANJUTA_ITERABLE (pos));
	position = _tmp0_;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_errors);
		{
			ValaList* _tmp1_;
			ValaList* _error_list;
			gint _tmp2_;
			gint _error_size;
			gint _error_index;
			_tmp1_ = _vala_iterable_ref0 (self->priv->errors);
			_error_list = _tmp1_;
			_tmp2_ = vala_collection_get_size ((ValaCollection*) _error_list);
			_error_size = _tmp2_;
			_error_index = -1;
			while (TRUE) {
				gpointer _tmp3_ = NULL;
				AnjutaReportError* _error_;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_;
				ValaSourceFile* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				gboolean _tmp8_;
				gint _tmp9_;
				IAnjutaIterable* _tmp10_ = NULL;
				IAnjutaIterable* _tmp11_;
				IAnjutaIterable* begin;
				gint _tmp14_;
				IAnjutaIterable* _tmp15_ = NULL;
				IAnjutaIterable* _tmp16_;
				IAnjutaIterable* end;
				gboolean _tmp19_ = FALSE;
				gint _tmp20_;
				gint _tmp21_;
				_error_index = _error_index + 1;
				if (!(_error_index < _error_size)) {
					break;
				}
				_tmp3_ = vala_list_get (_error_list, _error_index);
				_error_ = (AnjutaReportError*) _tmp3_;
				_tmp4_ = ianjuta_document_get_filename (IANJUTA_DOCUMENT (editor), &_inner_error_);
				_tmp5_ = _tmp4_;
				if (_inner_error_ != NULL) {
					_anjuta_report_error_free0 (_error_);
					_vala_iterable_unref0 (_error_list);
					goto __finally8;
				}
				_tmp6_ = vala_source_reference_get_file ((*_error_).source);
				_tmp7_ = vala_source_file_get_filename (_tmp6_);
				_tmp8_ = g_str_has_suffix (_tmp7_, _tmp5_);
				if (!_tmp8_) {
					_anjuta_report_error_free0 (_error_);
					continue;
				}
				_tmp9_ = vala_source_reference_get_first_line ((*_error_).source);
				_tmp10_ = ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) editor, _tmp9_, &_inner_error_);
				_tmp11_ = _g_object_ref0 (_tmp10_);
				begin = _tmp11_;
				if (_inner_error_ != NULL) {
					_anjuta_report_error_free0 (_error_);
					_vala_iterable_unref0 (_error_list);
					goto __finally8;
				}
				{
					gint i;
					i = 0;
					{
						gboolean _tmp12_;
						_tmp12_ = TRUE;
						while (TRUE) {
							gint _tmp13_;
							if (!_tmp12_) {
								i++;
							}
							_tmp12_ = FALSE;
							_tmp13_ = vala_source_reference_get_first_column ((*_error_).source);
							if (!(i < _tmp13_)) {
								break;
							}
							ianjuta_iterable_next (begin, &_inner_error_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (begin);
								_anjuta_report_error_free0 (_error_);
								_vala_iterable_unref0 (_error_list);
								goto __finally8;
							}
						}
					}
				}
				_tmp14_ = vala_source_reference_get_last_line ((*_error_).source);
				_tmp15_ = ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) editor, _tmp14_, &_inner_error_);
				_tmp16_ = _g_object_ref0 (_tmp15_);
				end = _tmp16_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (begin);
					_anjuta_report_error_free0 (_error_);
					_vala_iterable_unref0 (_error_list);
					goto __finally8;
				}
				{
					gint i;
					i = 0;
					{
						gboolean _tmp17_;
						_tmp17_ = TRUE;
						while (TRUE) {
							gint _tmp18_;
							if (!_tmp17_) {
								i++;
							}
							_tmp17_ = FALSE;
							_tmp18_ = vala_source_reference_get_last_column ((*_error_).source);
							if (!(i < _tmp18_)) {
								break;
							}
							ianjuta_iterable_next (end, &_inner_error_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (end);
								_g_object_unref0 (begin);
								_anjuta_report_error_free0 (_error_);
								_vala_iterable_unref0 (_error_list);
								goto __finally8;
							}
						}
					}
				}
				_tmp20_ = ianjuta_iterable_compare (position, begin, &_inner_error_);
				_tmp21_ = _tmp20_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (end);
					_g_object_unref0 (begin);
					_anjuta_report_error_free0 (_error_);
					_vala_iterable_unref0 (_error_list);
					goto __finally8;
				}
				if (_tmp21_ >= 0) {
					gint _tmp22_;
					gint _tmp23_;
					_tmp22_ = ianjuta_iterable_compare (position, end, &_inner_error_);
					_tmp23_ = _tmp22_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (end);
						_g_object_unref0 (begin);
						_anjuta_report_error_free0 (_error_);
						_vala_iterable_unref0 (_error_list);
						goto __finally8;
					}
					_tmp19_ = _tmp23_ <= 0;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					ianjuta_editor_hover_display (editor, position, (*_error_).message, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (end);
						_g_object_unref0 (begin);
						_anjuta_report_error_free0 (_error_);
						_vala_iterable_unref0 (_error_list);
						goto __finally8;
					}
					_g_object_unref0 (end);
					_g_object_unref0 (begin);
					_anjuta_report_error_free0 (_error_);
					_vala_iterable_unref0 (_error_list);
					g_static_rec_mutex_unlock (&self->priv->__lock_errors);
					_g_object_unref0 (position);
					return;
				}
				_g_object_unref0 (end);
				_g_object_unref0 (begin);
				_anjuta_report_error_free0 (_error_);
			}
			_vala_iterable_unref0 (_error_list);
		}
		__finally8:
		g_static_rec_mutex_unlock (&self->priv->__lock_errors);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (position);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (position);
}


static gpointer _vala_source_reference_ref0 (gpointer self) {
	return self ? vala_source_reference_ref (self) : NULL;
}


static void anjuta_report_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	AnjutaReport * self;
	GError * _inner_error_ = NULL;
	self = (AnjutaReport*) base;
	g_return_if_fail (message != NULL);
	if (source == NULL) {
		return;
	}
	{
		ValaSourceReference* _tmp0_;
		gchar* _tmp1_;
		AnjutaReportError _tmp2_ = {0};
		AnjutaReportError _tmp3_ = {0};
		AnjutaReportError _tmp4_;
		g_static_rec_mutex_lock (&self->priv->__lock_errors);
		_tmp0_ = _vala_source_reference_ref0 (source);
		_tmp1_ = g_strdup (message);
		memset (&_tmp2_, 0, sizeof (AnjutaReportError));
		_tmp2_.source = _tmp0_;
		_tmp2_.message = _tmp1_;
		_tmp2_.error = FALSE;
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		vala_collection_add ((ValaCollection*) self->priv->errors, &_tmp4_);
		anjuta_report_error_destroy (&_tmp4_);
		__finally9:
		g_static_rec_mutex_unlock (&self->priv->__lock_errors);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void anjuta_report_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	AnjutaReport * self;
	GError * _inner_error_ = NULL;
	self = (AnjutaReport*) base;
	g_return_if_fail (message != NULL);
	if (source == NULL) {
		return;
	}
	{
		ValaSourceReference* _tmp0_;
		gchar* _tmp1_;
		AnjutaReportError _tmp2_ = {0};
		AnjutaReportError _tmp3_ = {0};
		AnjutaReportError _tmp4_;
		g_static_rec_mutex_lock (&self->priv->__lock_errors);
		_tmp0_ = _vala_source_reference_ref0 (source);
		_tmp1_ = g_strdup (message);
		memset (&_tmp2_, 0, sizeof (AnjutaReportError));
		_tmp2_.source = _tmp0_;
		_tmp2_.message = _tmp1_;
		_tmp2_.error = TRUE;
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		vala_collection_add ((ValaCollection*) self->priv->errors, &_tmp4_);
		anjuta_report_error_destroy (&_tmp4_);
		__finally10:
		g_static_rec_mutex_unlock (&self->priv->__lock_errors);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean anjuta_report_errors_found (AnjutaReport* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->errors);
	result = _tmp0_ != 0;
	return result;
}


AnjutaReport* anjuta_report_construct (GType object_type) {
	AnjutaReport * self = NULL;
	self = (AnjutaReport*) vala_report_construct (object_type);
	return self;
}


AnjutaReport* anjuta_report_new (void) {
	return anjuta_report_construct (TYPE_ANJUTA_REPORT);
}


IAnjutaDocumentManager* anjuta_report_get_docman (AnjutaReport* self) {
	IAnjutaDocumentManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_docman;
	return result;
}


void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value) {
	IAnjutaDocumentManager* _tmp0_;
	IAnjutaDocumentManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_docman);
	self->priv->_docman = _tmp1_;
	g_object_notify ((GObject *) self, "docman");
}


static void anjuta_report_error_copy (const AnjutaReportError* self, AnjutaReportError* dest) {
	dest->source = _vala_source_reference_ref0 (self->source);
	dest->error = self->error;
	dest->message = g_strdup (self->message);
}


static void anjuta_report_error_destroy (AnjutaReportError* self) {
	_vala_source_reference_unref0 (self->source);
	_g_free0 (self->message);
}


static AnjutaReportError* anjuta_report_error_dup (const AnjutaReportError* self) {
	AnjutaReportError* dup;
	dup = g_new0 (AnjutaReportError, 1);
	anjuta_report_error_copy (self, dup);
	return dup;
}


static void anjuta_report_error_free (AnjutaReportError* self) {
	anjuta_report_error_destroy (self);
	g_free (self);
}


static GType anjuta_report_error_get_type (void) {
	static volatile gsize anjuta_report_error_type_id__volatile = 0;
	if (g_once_init_enter (&anjuta_report_error_type_id__volatile)) {
		GType anjuta_report_error_type_id;
		anjuta_report_error_type_id = g_boxed_type_register_static ("AnjutaReportError", (GBoxedCopyFunc) anjuta_report_error_dup, (GBoxedFreeFunc) anjuta_report_error_free);
		g_once_init_leave (&anjuta_report_error_type_id__volatile, anjuta_report_error_type_id);
	}
	return anjuta_report_error_type_id__volatile;
}


static void anjuta_report_class_init (AnjutaReportClass * klass) {
	anjuta_report_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AnjutaReportPrivate));
	VALA_REPORT_CLASS (klass)->warn = anjuta_report_real_warn;
	VALA_REPORT_CLASS (klass)->err = anjuta_report_real_err;
	G_OBJECT_CLASS (klass)->get_property = _vala_anjuta_report_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_anjuta_report_set_property;
	G_OBJECT_CLASS (klass)->finalize = anjuta_report_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANJUTA_REPORT_DOCMAN, g_param_spec_object ("docman", "docman", "docman", IANJUTA_TYPE_DOCUMENT_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void anjuta_report_instance_init (AnjutaReport * self) {
	ValaArrayList* _tmp0_ = NULL;
	self->priv = ANJUTA_REPORT_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_errors);
	_tmp0_ = vala_array_list_new (ANJUTA_REPORT_TYPE_ERROR, (GBoxedCopyFunc) anjuta_report_error_dup, anjuta_report_error_free, g_direct_equal);
	self->priv->errors = (ValaList*) _tmp0_;
}


static void anjuta_report_finalize (GObject* obj) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (obj);
	_g_object_unref0 (self->priv->_docman);
	g_static_rec_mutex_free (&self->priv->__lock_errors);
	_vala_iterable_unref0 (self->priv->errors);
	G_OBJECT_CLASS (anjuta_report_parent_class)->finalize (obj);
}


GType anjuta_report_get_type (void) {
	return anjuta_report_type_id;
}


GType anjuta_report_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (AnjutaReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) anjuta_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnjutaReport), 0, (GInstanceInitFunc) anjuta_report_instance_init, NULL };
	anjuta_report_type_id = g_type_module_register_type (module, VALA_TYPE_REPORT, "AnjutaReport", &g_define_type_info, 0);
	return anjuta_report_type_id;
}


static void _vala_anjuta_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (object);
	switch (property_id) {
		case ANJUTA_REPORT_DOCMAN:
		g_value_set_object (value, anjuta_report_get_docman (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_anjuta_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AnjutaReport * self;
	self = ANJUTA_REPORT (object);
	switch (property_id) {
		case ANJUTA_REPORT_DOCMAN:
		anjuta_report_set_docman (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



