/* libanjuta.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Anjuta", lower_case_cprefix = "anjuta_")]
namespace Anjuta {
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class AsyncCommand : Anjuta.Command {
		public static unowned string get_error_message (Anjuta.Command command);
		public void @lock ();
		public static void set_error_message (Anjuta.Command command, string error_message);
		public void unlock ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class AsyncNotify : GLib.Object {
		[CCode (has_construct_function = false)]
		public AsyncNotify ();
		public void get_error () throws GLib.Error;
		public void notify_finished ();
		public void set_error (GLib.Error error);
		public virtual signal void finished ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Command : GLib.Object {
		public virtual void cancel ();
		public virtual unowned string get_error_message ();
		public bool is_running ();
		public virtual void notify_complete (uint return_code);
		public virtual void notify_data_arrived ();
		public virtual void notify_progress (float progress);
		[NoWrapper]
		public virtual uint run ();
		public virtual void set_error_message (string error_message);
		public virtual void start ();
		public virtual bool start_automatic_monitor ();
		public virtual void stop_automatic_monitor ();
		public virtual signal void command_finished (uint return_code);
		public virtual signal void command_started ();
		public virtual signal void data_arrived ();
		public virtual signal void progress (float progress);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class CommandQueue : GLib.Object {
		[CCode (has_construct_function = false)]
		public CommandQueue ();
		public void push (Anjuta.Command command);
	}
	[Compact]
	[CCode (copy_function = "anjuta_encoding_copy", type_id = "ANJUTA_TYPE_ENCODING", cheader_filename = "libanjuta/libanjuta.h")]
	public class Encoding {
		public unowned Anjuta.Encoding copy ();
		public unowned string get_charset ();
		public static unowned Anjuta.Encoding get_current ();
		public static unowned Anjuta.Encoding get_from_charset (string charset);
		public static unowned Anjuta.Encoding get_from_index (int index);
		public unowned string get_name ();
		public static unowned Anjuta.Encoding get_utf8 ();
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Launcher : GLib.Object {
		[CCode (has_construct_function = false)]
		public Launcher ();
		public bool execute (string command_str, Anjuta.LauncherOutputCallback callback, void* callback_data);
		public bool execute_v (string dir, string[] argv, string[] envp, Anjuta.LauncherOutputCallback callback, void* callback_data);
		public int get_child_pid ();
		public bool is_busy ();
		public void reset ();
		public void send_ptyin (string input_str);
		public void send_stdin (string input_str);
		public void send_stdin_eof ();
		public bool set_buffered_output (bool buffered);
		public bool set_check_passwd_prompt (bool check_passwd);
		public void set_encoding (string charset);
		public bool set_terminal_echo (bool echo_on);
		public bool set_terminate_on_exit (bool terminate_on_exit);
		public void @signal (int sig);
		public virtual signal void busy (bool busy_flag);
		public virtual signal void child_exited (int child_pid, int exit_status, ulong time_taken_in_seconds);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class PkgConfigChooser : Gtk.TreeView, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public PkgConfigChooser ();
		public unowned GLib.List get_active_packages ();
		public unowned string get_selected_package ();
		public void set_active_packages (GLib.List packages);
		public void show_active_column (bool show_column);
		public void show_active_only (bool show_selected);
		public virtual signal void package_activated (string package);
		public virtual signal void package_deactivated (string package);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Plugin : GLib.Object {
		public virtual bool activate ();
		public uint add_watch (string name, [CCode (delegate_target_pos = 3.1)] Anjuta.PluginValueAdded added, Anjuta.PluginValueRemoved removed);
		public virtual bool deactivate ();
		public bool is_active ();
		public void remove_watch (uint id, bool send_remove);
		[NoAccessorMethod]
		public Anjuta.Shell shell { owned get; set construct; }
		public virtual signal void activated ();
		public virtual signal void deactivated ();
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class PluginDescription {
		[CCode (has_construct_function = false)]
		public PluginDescription (string filename) throws GLib.Error;
		public void foreach_key (string section_name, bool include_localized, Anjuta.PluginDescriptionLineFunc func);
		public void foreach_section (Anjuta.PluginDescriptionSectionFunc func);
		[CCode (has_construct_function = false)]
		public PluginDescription.from_string (string data) throws GLib.Error;
		public bool get_boolean (string section, string keyname, bool val);
		public bool get_integer (string section, string keyname, int val);
		public bool get_locale_string (string section, string keyname, string val);
		public bool get_raw (string section_name, string keyname, string locale, string val);
		public bool get_string (string section, string keyname, string val);
		public static GLib.Quark parse_error_quark ();
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class PluginHandle : GLib.Object {
		[CCode (has_construct_function = false)]
		public PluginHandle (string plugin_desc_path);
		public unowned string get_about ();
		public bool get_can_load ();
		public bool get_checked ();
		public unowned GLib.HashTable get_dependencies ();
		public unowned GLib.List get_dependency_names ();
		public unowned GLib.HashTable get_dependents ();
		public unowned Anjuta.PluginDescription get_description ();
		public unowned string get_icon_path ();
		public unowned string get_id ();
		public unowned GLib.List get_interfaces ();
		public unowned string get_language ();
		public unowned string get_name ();
		public unowned string get_path ();
		public bool get_resident ();
		public int get_resolve_pass ();
		public bool get_user_activatable ();
		public void set_can_load (bool can_load);
		public void set_checked (bool checked);
		public void set_resolve_pass (bool resolve_pass);
		public void unresolve_dependencies ();
		public string about { get; }
		public bool can_load { get; }
		public bool checked { get; }
		public void* dependencies { get; }
		public void* dependency_names { get; }
		public void* dependents { get; }
		public void* description { get; }
		public string icon_path { get; }
		public string id { get; }
		public void* interfaces { get; }
		public string language { get; }
		public string name { get; }
		public string path { get; }
		public bool resident { get; }
		public int resolve_pass { get; }
		public bool user_activatable { get; }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class PluginManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public PluginManager (GLib.Object shell, Anjuta.Status status, GLib.List plugin_search_paths);
		public void activate_plugins (GLib.List plugin_descs);
		public static GLib.Quark error_quark ();
		public unowned GLib.List get_active_plugin_objects ();
		public unowned GLib.List get_active_plugins ();
		public unowned GLib.Object get_plugin (string iface_name);
		public unowned GLib.Object get_plugin_by_id (string plugin_id);
		public unowned Gtk.Widget get_plugins_page ();
		public unowned string get_remembered_plugins ();
		public unowned Gtk.Widget get_remembered_plugins_page ();
		public bool is_active_plugin (string iface_name);
		public unowned GLib.List list_query (GLib.List section_names, GLib.List attribute_names, GLib.List attribute_values);
		public unowned GLib.List query (string section_names, string attribute_names, string attribute_values);
		public unowned Anjuta.PluginDescription select (string title, string description, GLib.List plugin_descriptions);
		public unowned GLib.Object select_and_activate (string title, string description, GLib.List plugin_descriptions);
		public void set_remembered_plugins (string remembered_plugins);
		public void unload_all_plugins ();
		public bool unload_plugin (GLib.Object plugin);
		public bool unload_plugin_by_id (string plugin_id);
		[NoAccessorMethod]
		public void* activated_plugins { get; }
		[NoAccessorMethod]
		public void* available_plugins { get; }
		[NoAccessorMethod]
		public void* profiles { get; }
		[NoAccessorMethod]
		public GLib.Object shell { owned get; set construct; }
		[NoAccessorMethod]
		public Anjuta.Status status { owned get; set construct; }
		public virtual signal void plugin_activated (void* plugin_desc, Anjuta.Plugin plugin);
		public virtual signal void plugin_deactivated (void* plugin_desc, Anjuta.Plugin plugin);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Preferences : GLib.Object {
		[CCode (has_construct_function = false)]
		public Preferences (Anjuta.PluginManager plugin_manager);
		public void add_from_builder (Gtk.Builder builder, string glade_widget_name, string title, string icon_filename);
		public static unowned Anjuta.Preferences @default ();
		public unowned string default_get (string key);
		public int default_get_bool (string key);
		public int default_get_int (string key);
		public void @foreach (Anjuta.PreferencesCallback callback, void* data);
		public unowned string @get (string key);
		public bool get_bool (string key);
		public bool get_bool_with_default (string key, bool default_value);
		public unowned Gtk.Widget get_dialog ();
		public int get_int (string key);
		public int get_int_with_default (string key, int default_value);
		public unowned string get_prefix ();
		public bool is_dialog_created ();
		public uint notify_add_bool (string key, Anjuta.PreferencesNotifyBool func, void* data, GLib.FreeFunc destroy_notify);
		public uint notify_add_int (string key, Anjuta.PreferencesNotifyInt func, void* data, GLib.FreeFunc destroy_notify);
		public uint notify_add_string (string key, Anjuta.PreferencesNotify func, void* data, GLib.FreeFunc destroy_notify);
		public void notify_remove (uint notify_id);
		public void register_all_properties_from_builder_xml (Gtk.Builder builder, Gtk.Widget parent);
		public bool register_property_custom (Gtk.Widget object, string key, string default_value, Anjuta.PropertyDataType data_type, uint flags, GLib.Callback set_property, GLib.Callback get_property);
		public bool register_property_from_string (Gtk.Widget object, string property_desc);
		public bool register_property_raw (Gtk.Widget object, string key, string default_value, uint flags, Anjuta.PropertyObjectType object_type, Anjuta.PropertyDataType data_type);
		public void remove_page (string page_name);
		public void reset_defaults ();
		public void @set (string key, string value);
		public void set_bool (string key, bool value);
		public void set_int (string key, int value);
		public void sync_to_session ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class PreferencesDialog : Gtk.Dialog, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public PreferencesDialog ();
		public void add_page (string name, string title, Gdk.Pixbuf icon, Gtk.Widget page);
		public void remove_page (string title);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Profile : GLib.Object {
		[CCode (has_construct_function = false)]
		public Profile (string name, Anjuta.PluginManager plugin_manager);
		public void add_plugin (Anjuta.PluginDescription plugin);
		public bool add_plugins_from_xml (GLib.File profile_xml_file, bool exclude_from_sync) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public unowned string get_name ();
		public unowned GLib.List get_plugins ();
		public bool has_plugin (Anjuta.PluginDescription plugin);
		public void remove_plugin (Anjuta.PluginDescription plugin);
		public void set_sync_file (GLib.File sync_file);
		public bool sync () throws GLib.Error;
		[NoAccessorMethod]
		public Anjuta.PluginManager plugin_manager { owned get; set construct; }
		[NoAccessorMethod]
		public void* plugins { get; set construct; }
		[NoAccessorMethod]
		public string profile_name { owned get; set construct; }
		[NoAccessorMethod]
		public GLib.File sync_file { owned get; set construct; }
		public virtual signal void changed (void* plugins);
		public virtual signal void plugin_added (void* plugin);
		public virtual signal void plugin_removed (void* plugin);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProfileManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public ProfileManager (Anjuta.PluginManager plugin_manager);
		public void freeze ();
		public unowned Anjuta.Profile get_current ();
		public bool pop (string profile_name) throws GLib.Error;
		public bool push (Anjuta.Profile profile) throws GLib.Error;
		public bool thaw () throws GLib.Error;
		[NoAccessorMethod]
		public Anjuta.PluginManager plugin_manager { owned get; set construct; }
		public virtual signal void profile_descoped (Anjuta.Profile profile);
		public virtual signal void profile_popped (Anjuta.Profile profile);
		public virtual signal void profile_pushed (Anjuta.Profile profile);
		public virtual signal void profile_scoped (Anjuta.Profile profile);
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectGroup {
		public unowned GLib.File get_directory ();
		public unowned Anjuta.ProjectGroup get_node_from_file (GLib.File directory);
		public unowned Anjuta.ProjectGroup get_node_from_uri (string uri);
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectGroupData {
		public weak GLib.File directory;
		public weak Anjuta.ProjectNodeData node;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectNode {
		public void all_foreach (Anjuta.ProjectNodeFunc func, void* data);
		public unowned Anjuta.ProjectNode append (Anjuta.ProjectNode node);
		public void children_foreach (Anjuta.ProjectNodeFunc func, void* data);
		public unowned Anjuta.ProjectNode first_child ();
		public unowned GLib.File get_file ();
		public unowned string get_name ();
		public unowned string get_uri ();
		public unowned Anjuta.ProjectNode insert_after (Anjuta.ProjectNode sibling, Anjuta.ProjectNode node);
		public unowned Anjuta.ProjectNode insert_before (Anjuta.ProjectNode sibling, Anjuta.ProjectNode node);
		public unowned Anjuta.ProjectNode last_child ();
		public unowned Anjuta.ProjectNode next_sibling ();
		public unowned Anjuta.ProjectNode nth_child (uint n);
		public unowned Anjuta.ProjectNode parent ();
		public unowned Anjuta.ProjectNode prepend (Anjuta.ProjectNode node);
		public unowned Anjuta.ProjectNode prev_sibling ();
		public Anjuta.ProjectNodeType type ();
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectNodeData {
		public Anjuta.ProjectNodeType type;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectSource {
		public unowned GLib.File get_file ();
		public static unowned Anjuta.ProjectSource get_node_from_file (Anjuta.ProjectNode parent, GLib.File file);
		public static unowned Anjuta.ProjectSource get_node_from_uri (Anjuta.ProjectNode parent, string uri);
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectSourceData {
		public weak GLib.File file;
		public weak Anjuta.ProjectNodeData node;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectTarget {
		public unowned string get_name ();
		public static unowned Anjuta.ProjectTarget get_node_from_name (Anjuta.ProjectGroup parent, string name);
		public unowned Anjuta.ProjectTargetType type ();
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectTargetData {
		public weak string name;
		public weak Anjuta.ProjectNodeData node;
		public weak Anjuta.ProjectTargetType type;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectTargetInformation {
		public Anjuta.ProjectTargetClass @base;
		public weak string mime_type;
		public weak string name;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class ProjectTargetType {
		public Anjuta.ProjectTargetClass @class ();
		public unowned string mime ();
		public unowned string name ();
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Property {
		public unowned Gtk.Widget get_widget ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class SavePrompt : Gtk.MessageDialog, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public SavePrompt (Gtk.Window parent);
		public void add_item (string item_name, string item_detail, void* item, Anjuta.SavePromptSaveFunc item_save_func);
		public int get_items_count ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Serializer : GLib.Object {
		[CCode (has_construct_function = false)]
		public Serializer (string filepath, Anjuta.SerializerMode mode);
		public bool read_float (string name, float value);
		public bool read_int (string name, int value);
		public bool read_string (string name, string value, bool replace);
		public bool write_float (string name, float value);
		public bool write_int (string name, int value);
		public bool write_string (string name, string value);
		[NoAccessorMethod]
		public string filepath { owned get; construct; }
		[NoAccessorMethod]
		public Anjuta.SerializerMode mode { get; construct; }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Session : GLib.Object {
		[CCode (has_construct_function = false)]
		public Session (string session_directory);
		public void clear ();
		public void clear_section (string section);
		public float get_float (string section, string key);
		public int get_int (string section, string key);
		public unowned string get_session_directory ();
		public unowned string get_session_filename ();
		public unowned string get_string (string section, string key);
		public unowned GLib.List get_string_list (string section, string key);
		public void set_float (string section, string key, float value);
		public void set_int (string section, string key, int value);
		public void set_string (string section, string key, string value);
		public void set_string_list (string section, string key, GLib.List value);
		public void sync ();
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Status : Gtk.HBox, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Status ();
		public void add_widget (Gtk.Widget widget);
		public void busy_pop ();
		public void busy_push ();
		public void clear_stack ();
		public void disable_splash (bool disable_splash);
		public void pop ();
		public void progress_add_ticks (int ticks);
		public void progress_increment_ticks (int ticks, string text);
		public void progress_pulse (string text);
		public void progress_reset ();
		public void progress_tick (Gdk.Pixbuf icon, string text);
		public void push (string mesg, ...);
		public void @set (string mesg, ...);
		public void set_default (string label, string value_format, ...);
		public void set_splash (string splash_file, int splash_progress_position);
		public void set_title (string title);
		public void set_title_window (Gtk.Widget window);
		public virtual signal void busy (bool state);
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class SyncCommand : Anjuta.Command {
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class Tabber : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public Tabber (Gtk.Notebook notebook);
		public void add_tab (Gtk.Widget tab_label);
		public GLib.Object notebook { construct; }
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class TabberPriv {
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class UI : Gtk.UIManager, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		public UI ();
		public void activate_action_by_group (Gtk.ActionGroup action_group, string action_name);
		public void activate_action_by_path (string action_path);
		public void add_action_group (string action_group_name, string action_group_label, Gtk.ActionGroup action_group, bool can_customize);
		public unowned Gtk.ActionGroup add_action_group_entries (string action_group_name, string action_group_label, Gtk.ActionEntry[] entries, string translation_domain, bool can_customize, void* user_data);
		public unowned Gtk.ActionGroup add_toggle_action_group_entries (string action_group_name, string action_group_label, Gtk.ToggleActionEntry entries, int num_entries, string translation_domain, bool can_customize);
		public void dump_tree ();
		public unowned Gtk.Widget get_accel_editor ();
		public unowned Gtk.AccelGroup get_accel_group ();
		public unowned Gtk.Action get_action (string action_group_name, string action_name);
		public unowned Gtk.IconFactory get_icon_factory ();
		public static void load_accels (string filename);
		public int merge (string ui_filename);
		public void remove_action_group (Gtk.ActionGroup action_group);
		public static void save_accels (string filename);
		public void unload_accels ();
		public void unmerge (int id);
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class UtilStringMap {
		public weak string name;
		public int type;
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public class VcsStatusTreeView : Gtk.TreeView, Atk.Implementor, Gtk.Buildable {
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public VcsStatusTreeView ();
		public void add (string path, Anjuta.VcsStatus status, bool selected);
		public void destroy ();
		public unowned GLib.List get_selected ();
		public void select_all ();
		public void unselect_all ();
		[NoAccessorMethod]
		public bool conflicted_selectable { get; construct; }
		[NoAccessorMethod]
		public bool show_status { get; set; }
		[NoAccessorMethod]
		public Anjuta.VcsStatus status_codes { get; construct; }
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public interface Shell : GLib.Object {
		public void add (string first_name, ...);
		public void add_valist (string first_name, GLib.Type first_type, void* var_args);
		public abstract void add_value (string name, GLib.Value value) throws GLib.Error;
		public void add_widget (Gtk.Widget widget, string name, string title, string stock_id, Anjuta.ShellPlacement placement) throws GLib.Error;
		public abstract void add_widget_custom (Gtk.Widget widget, string name, string title, string stock_id, Gtk.Widget label, Anjuta.ShellPlacement placement) throws GLib.Error;
		public abstract void add_widget_full (Gtk.Widget widget, string name, string title, string stock_id, Anjuta.ShellPlacement placement, bool locked) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public void freeze () throws GLib.Error;
		public void @get (string first_name, ...);
		public abstract unowned GLib.Object get_object (string iface_name) throws GLib.Error;
		public abstract unowned Anjuta.PluginManager get_plugin_manager () throws GLib.Error;
		public abstract unowned Anjuta.Preferences get_preferences () throws GLib.Error;
		public abstract unowned Anjuta.ProfileManager get_profile_manager () throws GLib.Error;
		public abstract unowned Anjuta.Status get_status () throws GLib.Error;
		public abstract unowned Anjuta.UI get_ui () throws GLib.Error;
		public void get_valist (string first_name, GLib.Type first_type, void* var_args);
		public abstract void get_value (string name, GLib.Value value) throws GLib.Error;
		public abstract void hide_dockable_widget (Gtk.Widget widget) throws GLib.Error;
		public abstract void iconify_dockable_widget (Gtk.Widget widget) throws GLib.Error;
		public abstract void maximize_widget (string widget_name) throws GLib.Error;
		public void notify_exit () throws GLib.Error;
		public abstract void present_widget (Gtk.Widget widget) throws GLib.Error;
		public abstract void remove_value (string name) throws GLib.Error;
		public abstract void remove_widget (Gtk.Widget widget) throws GLib.Error;
		public abstract void saving_pop ();
		public abstract void saving_push ();
		public void session_load (string session_directory) throws GLib.Error;
		public void session_save (string session_directory) throws GLib.Error;
		public abstract void show_dockable_widget (Gtk.Widget widget) throws GLib.Error;
		public void thaw () throws GLib.Error;
		public abstract void unmaximize () throws GLib.Error;
		public signal void exiting ();
		public signal void load_session (int phase, GLib.Object session);
		[HasEmitter]
		public signal void save_prompt (GLib.Object save_prompt);
		public signal void save_session (int phase, GLib.Object session);
		public signal void value_added (string name, GLib.Value value);
		public signal void value_removed (string name);
	}
	[CCode (cprefix = "ANJUTA_CONVERT_ERROR_AUTO_DETECTION_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum ConvertError {
		FAILED
	}
	[CCode (cprefix = "GBF_PROJECT_CAN_", cheader_filename = "libanjuta/libanjuta.h")]
	[Flags]
	public enum GbfProjectCapabilities {
		ADD_NONE,
		ADD_GROUP,
		ADD_TARGET,
		ADD_SOURCE,
		PACKAGES
	}
	[CCode (cprefix = "GBF_PROJECT_ERROR_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum GbfProjectError {
		SUCCESS,
		DOESNT_EXIST,
		ALREADY_EXISTS,
		VALIDATION_FAILED,
		PROJECT_MALFORMED,
		GENERAL_FAILURE
	}
	[CCode (cprefix = "ANJUTA_LAUNCHER_OUTPUT_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum LauncherOutputType {
		STDOUT,
		STDERR,
		PTY
	}
	[CCode (cprefix = "ANJUTA_PLUGIN_DESCRIPTION_PARSE_ERROR_INVALID_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum PluginDescriptionParseError {
		SYNTAX,
		ESCAPES,
		CHARS
	}
	[CCode (cprefix = "ANJUTA_PLUGIN_MANAGER_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum PluginManagerError {
		MISSING_FACTORY,
		ERROR_UNKNOWN
	}
	[CCode (cprefix = "ANJUTA_PROFILE_ERROR_URI_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum ProfileError {
		READ_FAILED,
		WRITE_FAILED
	}
	[CCode (cprefix = "ANJUTA_PROJECT_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum ProjectNodeType {
		UNKNOWN,
		GROUP,
		TARGET,
		SOURCE,
		VARIABLE
	}
	[CCode (cprefix = "ANJUTA_TARGET_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum ProjectTargetClass {
		UNKNOWN,
		SHAREDLIB,
		STATICLIB,
		EXECUTABLE,
		PYTHON,
		JAVA,
		LISP,
		HEADER,
		MAN,
		INFO,
		GENERIC,
		DATA,
		EXTRA,
		INTLTOOL,
		CONFIGURE,
		IDL,
		MKENUMS,
		GENMARSHAL
	}
	[CCode (cprefix = "ANJUTA_PROPERTY_DATA_TYPE_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum PropertyDataType {
		BOOL,
		INT,
		TEXT,
		COLOR,
		FONT
	}
	[CCode (cprefix = "ANJUTA_PROPERTY_OBJECT_TYPE_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum PropertyObjectType {
		TOGGLE,
		SPIN,
		ENTRY,
		COMBO,
		TEXT,
		COLOR,
		FONT,
		FILE,
		FOLDER
	}
	[CCode (cprefix = "ANJUTA_SERIALIZER_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum SerializerMode {
		READ,
		WRITE
	}
	[CCode (cprefix = "ANJUTA_SESSION_PHASE_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum SessionPhase {
		START,
		FIRST,
		NORMAL,
		LAST,
		END
	}
	[CCode (cprefix = "ANJUTA_SHELL_ERROR_DOESNT_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum ShellError {
		EXIST
	}
	[CCode (cprefix = "ANJUTA_SHELL_PLACEMENT_", cheader_filename = "libanjuta/libanjuta.h")]
	public enum ShellPlacement {
		NONE,
		TOP,
		BOTTOM,
		RIGHT,
		LEFT,
		CENTER,
		FLOATING
	}
	[CCode (cprefix = "ANJUTA_VCS_STATUS_", cheader_filename = "libanjuta/libanjuta.h")]
	[Flags]
	public enum VcsStatus {
		MODIFIED,
		ADDED,
		DELETED,
		CONFLICTED,
		UPTODATE,
		LOCKED,
		MISSING,
		UNVERSIONED,
		IGNORED
	}
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate void LauncherOutputCallback (Anjuta.Launcher launcher, Anjuta.LauncherOutputType output_type, string chars);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate void PluginDescriptionLineFunc (Anjuta.PluginDescription df, string key, string locale, string value);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate void PluginDescriptionSectionFunc (Anjuta.PluginDescription df, string name);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate void PluginValueAdded (Anjuta.Plugin plugin, string name, GLib.Value value);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate void PluginValueRemoved (Anjuta.Plugin plugin, string name);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate bool PreferencesCallback (Anjuta.Preferences pr, string key);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate void PreferencesNotify (Anjuta.Preferences pr, string key, string value);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate void PreferencesNotifyBool (Anjuta.Preferences pr, string key, bool value);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate void PreferencesNotifyInt (Anjuta.Preferences pr, string key, int value);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate void ProjectNodeFunc (Anjuta.ProjectNode node);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public delegate bool SavePromptSaveFunc (Anjuta.SavePrompt save_prompt, void* item);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public const int LIBANJUTA_MAJOR_VERSION;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public const int LIBANJUTA_MICRO_VERSION;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public const int LIBANJUTA_MINOR_VERSION;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public const int LIBANJUTA_VERSION_HEX;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public const string LIBANJUTA_VERSION_S;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public const int VCS_DEFAULT_STATUS_CODES;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static GLib.Quark convert_error_quark ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string convert_from_utf8 (string content, size_t len, Anjuta.Encoding encoding, size_t new_len) throws GLib.Error;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string convert_to_utf8 (string content, size_t len, out unowned Anjuta.Encoding encoding, size_t new_len) throws GLib.Error;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void debug_init ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string res_get_data_dir ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string res_get_data_file (string pixfile);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string res_get_doc_dir ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string res_get_doc_file (string docfile);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string res_get_help_dir ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string res_get_help_dir_locale (string locale);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string res_get_help_file (string helpfile);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string res_get_help_file_locale (string helpfile, string locale);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned Gtk.Widget res_get_image (string filename);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned Gtk.Widget res_get_image_sized (string filename, int width, int height);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string res_get_pixmap_dir ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string res_get_pixmap_file (string pixfile);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void res_help_search (string word);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned Gtk.Widget res_lookup_widget (Gtk.Widget widget, string widget_name);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void res_url_show (string url);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void status (Anjuta.Status status, string mesg, int timeout);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_builder_get_objects (Gtk.Builder builder, ...);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned Gtk.Builder util_builder_new (string filename) throws GLib.Error;
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned Gtk.Widget util_button_new_with_stock_image (string text, string stock_id);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_color_from_string (string val, uint16 r, uint16 g, uint16 b);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.List util_convert_gfile_list_to_path_list (GLib.List list);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.List util_convert_gfile_list_to_relative_path_list (GLib.List list, string parent);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_convert_to_utf8 (string str);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_copy_file (string src, string dest, bool show_error);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_create_dir (string d);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned Gtk.Widget util_dialog_add_button (Gtk.Dialog dialog, string text, string stock_id, int response_id);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_dialog_boolean_question (Gtk.Window parent, string mesg);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_dialog_error (Gtk.Window parent, string mesg);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_dialog_error_system (Gtk.Window parent, int errnum, string mesg);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_dialog_info (Gtk.Window parent, string mesg);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_dialog_input (Gtk.Window parent, string label, string default_value, string value);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_dialog_warning (Gtk.Window parent, string mesg);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_diff (string uri, string text);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_escape_quotes (string str);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static int util_execute_shell (string dir, string command);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static int util_execute_terminal_shell (string dir, string command);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.File util_file_new_for_commandline_arg (string arg);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_get_a_tmp_file ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_get_current_dir ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_get_file_mime_type (GLib.File file);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_get_local_path_from_uri (string uri);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_get_real_path (string path);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.File util_get_user_cache_file (string path);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_get_user_cache_file_path (string path);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.File util_get_user_config_file (string path);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_get_user_config_file_path (string path);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.File util_get_user_data_file (string path);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_get_user_data_file_path (string path);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.List util_glist_from_map (Anjuta.UtilStringMap map);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.List util_glist_from_string (string id);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.List util_glist_path_dedup (GLib.List list);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.List util_glist_strings_dup (GLib.List list);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_glist_strings_free (GLib.List list);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_glist_strings_join (GLib.List list, string delimiter);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_glist_strings_prefix (GLib.List list, string prefix);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.List util_glist_strings_sort (GLib.List list);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_glist_strings_sufix (GLib.List list, string sufix);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static void util_help_display (Gtk.Widget parent, string doc_id, string file_name);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_install_files (string names);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_is_project_file (string filename);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_is_template_file (string filename);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_package_is_installed (string lib, bool show);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.List util_parse_args_from_string (string str);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static bool util_prog_is_installed (string prog, bool show);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_replace_home_dir_with_tilde (string uri);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_shell_expand (string str);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_str_middle_truncate (string str, uint truncate_length);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_string_from_color (uint16 r, uint16 g, uint16 b);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_string_from_type (Anjuta.UtilStringMap map, int type);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static int util_type_from_string (Anjuta.UtilStringMap map, string str);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.List util_update_string_list (GLib.List p_list, string p_str, int length);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_uri_get_dirname (string uri);
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_user_shell ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned string util_user_terminal ();
	[CCode (cheader_filename = "libanjuta/libanjuta.h")]
	public static unowned GLib.SList utils_drop_get_files (Gtk.SelectionData selection_data);
}
/* libanjuta-interfaces.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "IAnjuta", lower_case_cprefix = "ianjuta_")]
namespace IAnjuta {
	[Compact]
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public class BuilderHandle {
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public class DebuggerBreakpointItem {
		public ulong address;
		public weak string condition;
		public bool enable;
		public weak string file;
		public weak string function;
		public uint id;
		public uint ignore;
		public uint line;
		public bool pending;
		public bool temporary;
		public uint times;
		public int type;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public class DebuggerFrame {
		public ulong address;
		public weak string args;
		public weak string file;
		public weak string function;
		public uint level;
		public weak string library;
		public uint line;
		public int thread;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public class DebuggerInstructionALine {
		public ulong address;
		public weak string label;
		public weak string text;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public class DebuggerInstructionDisassembly {
		[CCode (array_length = false)]
		public weak IAnjuta.DebuggerInstructionALine[] data;
		public uint size;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public class DebuggerMemoryBlock {
		public ulong address;
		public weak string data;
		public uint length;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public class DebuggerRegisterData {
		public weak string name;
		public uint num;
		public weak string value;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public class DebuggerVariableObject {
		public bool changed;
		public int children;
		public bool deleted;
		public bool exited;
		public weak string expression;
		public bool has_more;
		public weak string name;
		public weak string type;
		public weak string value;
	}
	[Compact]
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public class LanguageId {
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Buildable : GLib.Object {
		public abstract void build (string uri) throws GLib.Error;
		public abstract void clean (string uri) throws GLib.Error;
		public abstract void configure (string uri) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void execute (string uri) throws GLib.Error;
		public abstract void generate (string uri) throws GLib.Error;
		public abstract unowned string get_command (IAnjuta.BuildableCommand command_id) throws GLib.Error;
		public abstract void install (string uri) throws GLib.Error;
		public abstract void reset_commands () throws GLib.Error;
		public abstract void set_command (IAnjuta.BuildableCommand command_id, string command) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Builder : GLib.Object {
		public abstract unowned IAnjuta.BuilderHandle build (string uri, IAnjuta.BuilderCallback callback) throws GLib.Error;
		public abstract void cancel (IAnjuta.BuilderHandle handle) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned string get_uri_configuration (string uri) throws GLib.Error;
		public abstract unowned IAnjuta.BuilderHandle is_built (string uri, IAnjuta.BuilderCallback callback) throws GLib.Error;
		public abstract unowned GLib.List list_configuration () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebugManager : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool quit () throws GLib.Error;
		public abstract bool start (string uri) throws GLib.Error;
		public abstract bool start_remote (string server, string uri) throws GLib.Error;
		public signal void breakpoint_changed (void* breakpoint);
		public signal void debugger_started ();
		public signal void debugger_stopped (GLib.Error err);
		public signal void frame_changed (uint frame, int thread);
		public signal void location_changed (ulong address, string uri, uint line);
		public signal void program_exited ();
		public signal void program_loaded ();
		public signal void program_moved (int pid, int tid, ulong address, string file, uint line);
		public signal void program_running ();
		public signal void program_started ();
		public signal void program_stopped ();
		public signal void program_unloaded ();
		public signal void sharedlib_event ();
		public signal void signal_received (string name, string description);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Debugger : GLib.Object {
		public abstract bool abort () throws GLib.Error;
		public abstract bool attach (int pid, GLib.List source_search_directories) throws GLib.Error;
		public abstract bool callback (IAnjuta.DebuggerCallback callback) throws GLib.Error;
		public abstract bool connect (string server, string args, bool terminal, bool stop) throws GLib.Error;
		public abstract void disable_log () throws GLib.Error;
		public abstract bool dump_stack_trace (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract void enable_log (IAnjuta.MessageView log) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool evaluate (string name, string value, IAnjuta.DebuggerGCharCallback callback) throws GLib.Error;
		public abstract bool exit () throws GLib.Error;
		public abstract IAnjuta.DebuggerState get_state () throws GLib.Error;
		public abstract bool handle_signal (string name, bool stop, bool print, bool ignore) throws GLib.Error;
		public abstract bool info_args (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool info_frame (uint frame, IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool info_program (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool info_sharedlib (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool info_signal (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool info_target (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool info_thread (int thread, IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool info_udot (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool info_variables (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool inspect (string name, IAnjuta.DebuggerGCharCallback callback) throws GLib.Error;
		public abstract bool interrupt () throws GLib.Error;
		public abstract bool list_argument (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool list_frame (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool list_local (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool list_thread (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool load (string file, string mime_type, GLib.List source_search_directories) throws GLib.Error;
		public abstract bool print (string variable, IAnjuta.DebuggerGCharCallback callback) throws GLib.Error;
		public abstract bool quit () throws GLib.Error;
		public abstract bool run () throws GLib.Error;
		public abstract bool run_from (string file, int line) throws GLib.Error;
		public abstract bool run_to (string file, int line) throws GLib.Error;
		public abstract bool send_command (string command) throws GLib.Error;
		public abstract bool set_environment (string env) throws GLib.Error;
		public abstract bool set_frame (uint frame) throws GLib.Error;
		public abstract bool set_thread (int thread) throws GLib.Error;
		public abstract bool set_working_directory (string dir) throws GLib.Error;
		public abstract bool start (string args, bool terminal, bool stop) throws GLib.Error;
		public abstract bool step_in () throws GLib.Error;
		public abstract bool step_out () throws GLib.Error;
		public abstract bool step_over () throws GLib.Error;
		public abstract bool unload () throws GLib.Error;
		public signal void debugger_ready (IAnjuta.DebuggerState state);
		public signal void debugger_started ();
		public signal void debugger_stopped (GLib.Error err);
		public signal void frame_changed (uint frame, int thread);
		public signal void program_exited ();
		public signal void program_loaded ();
		public signal void program_moved (int pid, int tid, ulong address, string file, uint line);
		public signal void program_running ();
		public signal void program_stopped ();
		public signal void sharedlib_event ();
		public signal void signal_received (string name, string description);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebuggerBreakpoint : IAnjuta.Debugger, GLib.Object {
		public abstract bool clear_breakpoint (uint id, IAnjuta.DebuggerBreakpointCallback callback) throws GLib.Error;
		public abstract bool condition_breakpoint (uint id, string condition, IAnjuta.DebuggerBreakpointCallback callback) throws GLib.Error;
		public abstract bool enable_breakpoint (uint id, bool enable, IAnjuta.DebuggerBreakpointCallback callback) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool ignore_breakpoint (uint id, uint ignore, IAnjuta.DebuggerBreakpointCallback callback) throws GLib.Error;
		public abstract int implement_breakpoint () throws GLib.Error;
		public abstract bool list_breakpoint (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool set_breakpoint_at_address (ulong address, IAnjuta.DebuggerBreakpointCallback callback) throws GLib.Error;
		public abstract bool set_breakpoint_at_function (string file, string function, IAnjuta.DebuggerBreakpointCallback callback) throws GLib.Error;
		public abstract bool set_breakpoint_at_line (string file, uint line, IAnjuta.DebuggerBreakpointCallback callback) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebuggerInstruction : IAnjuta.Debugger, GLib.Object {
		public abstract bool disassemble (ulong address, uint length, IAnjuta.DebuggerInstructionCallback callback) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool run_from_address (ulong address) throws GLib.Error;
		public abstract bool run_to_address (ulong address) throws GLib.Error;
		public abstract bool step_in_instruction () throws GLib.Error;
		public abstract bool step_over_instruction () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebuggerMemory : IAnjuta.Debugger, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool inspect (ulong address, uint length, IAnjuta.DebuggerMemoryCallback callback) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebuggerRegister : IAnjuta.Debugger, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool list_register (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool update_register (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool write_register (IAnjuta.DebuggerRegisterData value) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DebuggerVariable : IAnjuta.Debugger, GLib.Object {
		public abstract bool assign (string name, string value) throws GLib.Error;
		public abstract bool create (string expression, IAnjuta.DebuggerVariableCallback callback) throws GLib.Error;
		public abstract bool destroy (string name) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool evaluate (string name, IAnjuta.DebuggerGCharCallback callback) throws GLib.Error;
		public abstract bool list_children (string name, uint from, IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
		public abstract bool update (IAnjuta.DebuggerGListCallback callback) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Document : GLib.Object {
		public abstract void begin_undo_action () throws GLib.Error;
		public abstract bool can_redo () throws GLib.Error;
		public abstract bool can_undo () throws GLib.Error;
		public abstract void clear () throws GLib.Error;
		public abstract void copy () throws GLib.Error;
		public abstract void cut () throws GLib.Error;
		public abstract void end_undo_action () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned string get_filename () throws GLib.Error;
		public abstract void grab_focus () throws GLib.Error;
		public abstract void paste () throws GLib.Error;
		public abstract void redo () throws GLib.Error;
		public abstract void undo () throws GLib.Error;
		public signal void update_ui ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface DocumentManager : GLib.Object {
		public abstract void add_bookmark (GLib.File file, int line) throws GLib.Error;
		public abstract unowned IAnjuta.Editor add_buffer (string name, string content) throws GLib.Error;
		public abstract void add_document (IAnjuta.Document document) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned IAnjuta.Document find_document_with_file (GLib.File file) throws GLib.Error;
		public abstract unowned IAnjuta.Document get_current_document () throws GLib.Error;
		public abstract unowned GLib.List get_doc_widgets () throws GLib.Error;
		public abstract unowned GLib.File get_file (string filename) throws GLib.Error;
		public abstract unowned IAnjuta.Editor goto_file_line (GLib.File file, int lineno) throws GLib.Error;
		public abstract unowned IAnjuta.Editor goto_file_line_mark (GLib.File file, int lineno, bool mark) throws GLib.Error;
		public abstract bool remove_document (IAnjuta.Document document, bool save_before) throws GLib.Error;
		public abstract void set_current_document (IAnjuta.Document document) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Editor : GLib.Object {
		public abstract void append (string text, int length) throws GLib.Error;
		public abstract void erase (IAnjuta.Iterable position_start, IAnjuta.Iterable position_end) throws GLib.Error;
		public abstract void erase_all () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract int get_column () throws GLib.Error;
		public abstract unowned string get_current_word () throws GLib.Error;
		public abstract unowned IAnjuta.Iterable get_end_position () throws GLib.Error;
		public abstract int get_length () throws GLib.Error;
		public abstract unowned IAnjuta.Iterable get_line_begin_position (int line) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable get_line_end_position (int line) throws GLib.Error;
		public abstract int get_line_from_position (IAnjuta.Iterable position) throws GLib.Error;
		public abstract int get_lineno () throws GLib.Error;
		public abstract int get_offset () throws GLib.Error;
		public abstract bool get_overwrite () throws GLib.Error;
		public abstract unowned IAnjuta.Iterable get_position () throws GLib.Error;
		public abstract unowned IAnjuta.Iterable get_position_from_offset (int offset) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable get_start_position () throws GLib.Error;
		public abstract int get_tabsize () throws GLib.Error;
		public abstract unowned string get_text (IAnjuta.Iterable begin, IAnjuta.Iterable end) throws GLib.Error;
		public abstract unowned string get_text_all () throws GLib.Error;
		public abstract bool get_use_spaces () throws GLib.Error;
		[NoWrapper]
		public abstract void goto_end () throws GLib.Error;
		[NoWrapper]
		public abstract void goto_line (int lineno) throws GLib.Error;
		[NoWrapper]
		public abstract void goto_position (IAnjuta.Iterable position) throws GLib.Error;
		[NoWrapper]
		public abstract void goto_start () throws GLib.Error;
		public abstract void insert (IAnjuta.Iterable position, string text, int length) throws GLib.Error;
		public abstract void set_auto_indent (bool auto_indent) throws GLib.Error;
		public abstract void set_popup_menu (Gtk.Widget menu) throws GLib.Error;
		public abstract void set_tabsize (int tabsize) throws GLib.Error;
		public abstract void set_use_spaces (bool use_spaces) throws GLib.Error;
		public signal void backspace ();
		public signal void changed (GLib.Object position, bool added, int length, int lines, string text);
		public signal void char_added (GLib.Object position, char ch);
		public signal void line_marks_gutter_clicked (int location);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorAssist : IAnjuta.Editor, GLib.Object {
		public abstract void add (IAnjuta.Provider provider) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void invoke (IAnjuta.Provider provider) throws GLib.Error;
		public abstract void proposals (IAnjuta.Provider provider, GLib.List proposals, bool finished) throws GLib.Error;
		public abstract void remove (IAnjuta.Provider provider) throws GLib.Error;
		public signal void cancelled ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorCell : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract IAnjuta.EditorAttribute get_attribute () throws GLib.Error;
		public abstract char get_char (int char_index) throws GLib.Error;
		public abstract unowned string get_character () throws GLib.Error;
		public abstract int get_length () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorCellStyle : IAnjuta.EditorCell, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned string get_background_color () throws GLib.Error;
		public abstract unowned string get_color () throws GLib.Error;
		public abstract unowned string get_font_description () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorComment : IAnjuta.Editor, GLib.Object {
		public abstract void block () throws GLib.Error;
		public abstract void box () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void stream () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorConvert : IAnjuta.Editor, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void to_lower (IAnjuta.Iterable start_position, IAnjuta.Iterable end_position) throws GLib.Error;
		public abstract void to_upper (IAnjuta.Iterable start_position, IAnjuta.Iterable end_position) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorFactory : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned IAnjuta.Editor new_editor (GLib.File file, string filename) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorFolds : IAnjuta.Editor, GLib.Object {
		public abstract void close_all () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void open_all () throws GLib.Error;
		public abstract void toggle_current () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorGoto : IAnjuta.Editor, GLib.Object {
		public static void end (IAnjuta.Editor obj) throws GLib.Error;
		public abstract void end_block () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public static void line (IAnjuta.Editor obj, int lineno) throws GLib.Error;
		public abstract void matching_brace () throws GLib.Error;
		public static void position (IAnjuta.Editor obj, IAnjuta.Iterable position) throws GLib.Error;
		public static void start (IAnjuta.Editor obj) throws GLib.Error;
		public abstract void start_block () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorHover : IAnjuta.Editor, GLib.Object {
		public abstract void display (IAnjuta.Iterable position, string info) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public signal void hover_leave (GLib.Object position);
		public signal void hover_over (GLib.Object position);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorLanguage : IAnjuta.Editor, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned string get_language () throws GLib.Error;
		public abstract unowned string get_language_name (string language) throws GLib.Error;
		public abstract unowned GLib.List get_supported_languages () throws GLib.Error;
		public abstract void set_language (string language) throws GLib.Error;
		public signal void language_changed (string language);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorLineMode : IAnjuta.Editor, GLib.Object {
		public abstract void convert (IAnjuta.EditorLineModeType mode) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void fix () throws GLib.Error;
		public abstract IAnjuta.EditorLineModeType @get () throws GLib.Error;
		public abstract void @set (IAnjuta.EditorLineModeType mode) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorSearch : IAnjuta.Editor, GLib.Object {
		public abstract bool backward (string search, bool case_sensitive, IAnjuta.EditorCell start, IAnjuta.EditorCell end, out unowned IAnjuta.EditorCell result_start, out unowned IAnjuta.EditorCell result_end) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool forward (string search, bool case_sensitive, IAnjuta.EditorCell start, IAnjuta.EditorCell end, out unowned IAnjuta.EditorCell result_start, out unowned IAnjuta.EditorCell result_end) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorSelection : IAnjuta.Editor, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned string @get () throws GLib.Error;
		public abstract unowned IAnjuta.Iterable get_end () throws GLib.Error;
		public abstract unowned IAnjuta.Iterable get_start () throws GLib.Error;
		public abstract bool has_selection () throws GLib.Error;
		public abstract void replace (string text, int length) throws GLib.Error;
		public abstract void select_all () throws GLib.Error;
		public abstract void select_block () throws GLib.Error;
		public abstract void select_function () throws GLib.Error;
		public abstract void @set (IAnjuta.Iterable start, IAnjuta.Iterable end, bool scroll) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorTip : IAnjuta.Editor, GLib.Object {
		public abstract void cancel () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void show (GLib.List tips, IAnjuta.Iterable position) throws GLib.Error;
		public abstract bool visible () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorView : IAnjuta.Editor, GLib.Object {
		public abstract void create () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract int get_count () throws GLib.Error;
		public abstract void remove_current () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface EditorZoom : IAnjuta.Editor, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void @in () throws GLib.Error;
		public abstract void @out () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Environment : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned string get_real_directory (string dir) throws GLib.Error;
		public abstract bool @override (string dirp, string argvp, string envp) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface File : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned GLib.File get_file () throws GLib.Error;
		public abstract void open (GLib.File file) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface FileLoader : IAnjuta.Loader, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned GLib.Object load (GLib.File file, bool readonly) throws GLib.Error;
		public abstract unowned string peek_interface (GLib.File file) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface FileManager : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned GLib.File get_selected () throws GLib.Error;
		public abstract void set_root (string root_uri) throws GLib.Error;
		public abstract void set_selected (GLib.File file) throws GLib.Error;
		public signal void section_changed (GLib.Object file);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface FileSavable : IAnjuta.File, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool is_conflict () throws GLib.Error;
		public abstract bool is_dirty () throws GLib.Error;
		public abstract bool is_read_only () throws GLib.Error;
		public abstract void save () throws GLib.Error;
		public abstract void save_as (GLib.File file) throws GLib.Error;
		public abstract void set_dirty (bool dirty) throws GLib.Error;
		public signal void saved (GLib.Object file);
		public signal void update_save_ui ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Help : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void search (string query) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Indicable : GLib.Object {
		public abstract void clear () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void @set (IAnjuta.Iterable begin_location, IAnjuta.Iterable end_location, IAnjuta.IndicableIndicator indicator) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Iterable : GLib.Object {
		public abstract void assign (IAnjuta.Iterable src_iter) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable clone () throws GLib.Error;
		public abstract int compare (IAnjuta.Iterable iter2) throws GLib.Error;
		public abstract int diff (IAnjuta.Iterable iter2) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool first () throws GLib.Error;
		public abstract void @foreach (GLib.Func callback) throws GLib.Error;
		public abstract int get_length () throws GLib.Error;
		public abstract int get_position () throws GLib.Error;
		public abstract bool last () throws GLib.Error;
		public abstract bool next () throws GLib.Error;
		public abstract bool previous () throws GLib.Error;
		public abstract bool set_position (int position) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface IterableTree : IAnjuta.Iterable, GLib.Object {
		public abstract bool children () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void foreach_post (GLib.Func callback) throws GLib.Error;
		public abstract void foreach_pre (GLib.Func callback) throws GLib.Error;
		public abstract bool has_children () throws GLib.Error;
		public abstract bool parent () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Language : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned IAnjuta.LanguageId get_from_editor (IAnjuta.EditorLanguage editor) throws GLib.Error;
		public abstract unowned IAnjuta.LanguageId get_from_mime_type (string mime_type) throws GLib.Error;
		public abstract unowned IAnjuta.LanguageId get_from_string (string str) throws GLib.Error;
		public abstract unowned GLib.List get_languages () throws GLib.Error;
		public abstract unowned string get_make_target (IAnjuta.LanguageId id) throws GLib.Error;
		public abstract unowned string get_name (IAnjuta.LanguageId id) throws GLib.Error;
		public abstract unowned string get_name_from_editor (IAnjuta.EditorLanguage editor) throws GLib.Error;
		public abstract unowned GLib.List get_strings (IAnjuta.LanguageId id) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Loader : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned GLib.List find_plugins () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Macro : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void insert (string key) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Markable : GLib.Object {
		public abstract void delete_all_markers (IAnjuta.MarkableMarker marker) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract bool is_marker_set (int location, IAnjuta.MarkableMarker marker) throws GLib.Error;
		public abstract int location_from_handle (int handle) throws GLib.Error;
		public abstract int mark (int location, IAnjuta.MarkableMarker marker) throws GLib.Error;
		public abstract void unmark (int location, IAnjuta.MarkableMarker marker) throws GLib.Error;
		public signal void marker_clicked (bool double_click, int location);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface MessageManager : GLib.Object {
		public abstract unowned IAnjuta.MessageView add_view (string name, string icon) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned GLib.List get_all_views () throws GLib.Error;
		public abstract unowned IAnjuta.MessageView get_current_view () throws GLib.Error;
		public abstract unowned IAnjuta.MessageView get_view_by_name (string name) throws GLib.Error;
		public abstract void remove_view (IAnjuta.MessageView view) throws GLib.Error;
		public abstract void set_current_view (IAnjuta.MessageView view) throws GLib.Error;
		public abstract void set_view_icon (IAnjuta.MessageView view, Gdk.PixbufAnimation icon) throws GLib.Error;
		public abstract void set_view_icon_from_stock (IAnjuta.MessageView view, string icon) throws GLib.Error;
		public abstract void set_view_title (IAnjuta.MessageView view, string title) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface MessageView : GLib.Object {
		public abstract void append (IAnjuta.MessageViewType type, string summary, string details) throws GLib.Error;
		public abstract void buffer_append (string text) throws GLib.Error;
		public abstract void clear () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned GLib.List get_all_messages () throws GLib.Error;
		public abstract unowned string get_current_message () throws GLib.Error;
		public abstract void select_next () throws GLib.Error;
		public abstract void select_previous () throws GLib.Error;
		public signal void buffer_flushed (string line);
		public signal void message_clicked (string message);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface PluginFactory : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned Anjuta.Plugin new_plugin (Anjuta.PluginHandle handle, Anjuta.Shell shell) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Preferences : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void merge (Anjuta.Preferences prefs) throws GLib.Error;
		public abstract void unmerge (Anjuta.Preferences prefs) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Print : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void print () throws GLib.Error;
		public abstract void print_preview () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Project : GLib.Object {
		public abstract unowned Anjuta.ProjectGroup add_group (Anjuta.ProjectGroup parent, string name) throws GLib.Error;
		public abstract unowned Anjuta.ProjectSource add_source (Anjuta.ProjectTarget parent, GLib.File file) throws GLib.Error;
		public abstract unowned Anjuta.ProjectTarget add_target (Anjuta.ProjectGroup parent, string name, Anjuta.ProjectTargetType type) throws GLib.Error;
		public abstract unowned Gtk.Widget configure () throws GLib.Error;
		public abstract unowned Gtk.Widget configure_node (Anjuta.ProjectNode node) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract uint get_capabilities () throws GLib.Error;
		public abstract GLib.List<string> get_packages () throws GLib.Error;
		public abstract unowned Anjuta.ProjectGroup get_root () throws GLib.Error;
		public abstract unowned GLib.List get_target_types () throws GLib.Error;
		public abstract bool load (GLib.File file) throws GLib.Error;
		public abstract bool refresh () throws GLib.Error;
		public abstract bool remove_node (Anjuta.ProjectNode node) throws GLib.Error;
		public signal void project_updated ();
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface ProjectBackend : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract IAnjuta.Project new_project () throws GLib.Error;
		public abstract int probe (GLib.File directory) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface ProjectManager : GLib.Object {
		public abstract unowned GLib.File add_group (string name, GLib.File default_group) throws GLib.Error;
		public abstract unowned GLib.File add_source (string name, GLib.File default_target) throws GLib.Error;
		public abstract unowned GLib.File add_source_quiet (string name, GLib.File target) throws GLib.Error;
		public abstract unowned GLib.List add_sources (GLib.List names, GLib.File default_target) throws GLib.Error;
		public abstract unowned GLib.File add_target (string name, GLib.File default_group) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract uint get_capabilities () throws GLib.Error;
		public abstract unowned GLib.List get_children (GLib.File element) throws GLib.Error;
		public abstract unowned GLib.List get_elements (Anjuta.ProjectNodeType element_type) throws GLib.Error;
		public abstract unowned GLib.List get_packages () throws GLib.Error;
		public abstract unowned GLib.File get_parent (GLib.File element) throws GLib.Error;
		public abstract unowned GLib.File get_selected () throws GLib.Error;
		public abstract Anjuta.ProjectTargetClass get_target_type (GLib.File target) throws GLib.Error;
		public abstract unowned GLib.List get_targets (Anjuta.ProjectTargetClass target_type) throws GLib.Error;
		public abstract bool is_open () throws GLib.Error;
		public signal void element_added (GLib.Object element);
		public signal void element_removed (GLib.Object element);
		public signal void element_selected (GLib.Object element);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Provider : GLib.Object {
		public abstract void activate (IAnjuta.Iterable iter, void* data) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned string get_name () throws GLib.Error;
		public abstract unowned IAnjuta.Iterable get_start_iter () throws GLib.Error;
		public abstract void populate (IAnjuta.Iterable iter) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Stream : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void open (GLib.FileStream stream) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface StreamLoader : IAnjuta.Loader, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract unowned GLib.Object load (GLib.FileStream stream, bool readonly) throws GLib.Error;
		public abstract unowned string peek_interface (GLib.FileStream stream) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface StreamSavable : IAnjuta.Stream, GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void save (GLib.FileStream stream) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Symbol : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract bool get_boolean (IAnjuta.SymbolField field) throws GLib.Error;
		public abstract unowned GLib.File get_file () throws GLib.Error;
		public abstract unowned Gdk.Pixbuf get_icon () throws GLib.Error;
		public abstract int get_int (IAnjuta.SymbolField field) throws GLib.Error;
		public abstract unowned string get_string (IAnjuta.SymbolField field) throws GLib.Error;
		public abstract IAnjuta.SymbolType get_sym_type () throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface SymbolManager : GLib.Object {
		public abstract unowned IAnjuta.SymbolQuery create_query (IAnjuta.SymbolQueryName name, IAnjuta.SymbolQueryDb db) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public signal void prj_scan_end (int process_id);
		public signal void sys_scan_end (int process_id);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface SymbolQuery : GLib.Object {
		public abstract void cancel () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract unowned IAnjuta.Iterable search (string pattern) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable search_all () throws GLib.Error;
		public abstract unowned IAnjuta.Iterable search_class_parents (IAnjuta.Symbol symbol) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable search_file (string pattern, GLib.File file) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable search_id (int symbol_id) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable search_in_scope (string pattern, IAnjuta.Symbol scope) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable search_members (IAnjuta.Symbol symbol) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable search_parent_scope (IAnjuta.Symbol symbol) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable search_parent_scope_file (IAnjuta.Symbol symbol, string file_path) throws GLib.Error;
		public abstract unowned IAnjuta.Iterable search_scope (string file_path, int line) throws GLib.Error;
		public abstract void set_fields (int n_fields, IAnjuta.SymbolField fields) throws GLib.Error;
		public abstract void set_file_scope (IAnjuta.SymbolQueryFileScope filescope_search) throws GLib.Error;
		public abstract void set_filters (IAnjuta.SymbolType filters, bool includes_types) throws GLib.Error;
		public abstract void set_group_by (IAnjuta.SymbolField field) throws GLib.Error;
		public abstract void set_limit (int limit) throws GLib.Error;
		public abstract void set_mode (IAnjuta.SymbolQueryMode mode) throws GLib.Error;
		public abstract void set_offset (int offset) throws GLib.Error;
		public abstract void set_order_by (IAnjuta.SymbolField field) throws GLib.Error;
		public signal void async_result (GLib.Object result);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Terminal : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract int execute_command (string directory, string command, string environment) throws GLib.Error;
		public signal void child_exited (int pid, int status);
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Todo : GLib.Object {
		public static GLib.Quark error_quark ();
		public abstract void load (GLib.File file) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Vcs : GLib.Object {
		public abstract void add (GLib.List files, Anjuta.AsyncNotify notify) throws GLib.Error;
		public abstract void checkout (string repository_location, GLib.File dest, GLib.Cancellable cancel, Anjuta.AsyncNotify notify) throws GLib.Error;
		public abstract void diff (GLib.File file, IAnjuta.VcsDiffCallback callback, GLib.Cancellable cancel, Anjuta.AsyncNotify notify) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public abstract void query_status (GLib.File file, IAnjuta.VcsStatusCallback callback, GLib.Cancellable cancel, Anjuta.AsyncNotify notify) throws GLib.Error;
		public abstract void remove (GLib.List files, Anjuta.AsyncNotify notify) throws GLib.Error;
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public interface Wizard : GLib.Object {
		public abstract void activate () throws GLib.Error;
		public static GLib.Quark error_quark ();
	}
	[CCode (type_id = "IANJUTA_TYPE_EDITOR_ASSIST_PROPOSAL", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public struct EditorAssistProposal {
		public weak string label;
		public weak string markup;
		public weak string info;
		public weak string text;
		public weak Gdk.Pixbuf icon;
		public void* data;
	}
	[CCode (cprefix = "IANJUTA_BUILDABLE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum BuildableCommand {
		COMMAND_COMPILE,
		COMMAND_BUILD,
		COMMAND_BUILD_TARBALL,
		COMMAND_INSTALL,
		COMMAND_CONFIGURE,
		COMMAND_GENERATE,
		COMMAND_CLEAN,
		COMMAND_EXECUTE,
		COMMAND_IS_BUILT,
		COMMAND_AUTORECONF,
		COMMAND_DISTCLEAN,
		N_COMMANDS
	}
	[CCode (cprefix = "IANJUTA_BUILDER_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum BuilderError {
		SUCCEED,
		FAILED,
		CANCELED,
		ABORTED,
		INTERRUPTED,
		TERMINATED,
		UNKNOWN_TARGET,
		UNKNOWN_ERROR,
		OTHER_ERROR
	}
	[CCode (cprefix = "IANJUTA_DEBUGGER_BREAKPOINT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DebuggerBreakpointMethod {
		SET_AT_ADDRESS,
		SET_AT_FUNCTION,
		ENABLE,
		IGNORE,
		CONDITION
	}
	[CCode (cprefix = "IANJUTA_DEBUGGER_BREAKPOINT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DebuggerBreakpointType {
		REMOVED,
		UPDATED,
		ON_LINE,
		ON_ADDRESS,
		ON_FUNCTION,
		ON_READ,
		ON_WRITE,
		WITH_ENABLE,
		WITH_IGNORE,
		WITH_TIME,
		WITH_CONDITION,
		WITH_TEMPORARY,
		WITH_PENDING
	}
	[CCode (cprefix = "IANJUTA_DEBUGGER_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DebuggerError {
		OK,
		NOT_READY,
		NOT_RUNNING,
		NOT_STOPPED,
		NOT_LOADED,
		NOT_STARTED,
		NOT_CONNECTED,
		NOT_IMPLEMENTED,
		CANCEL,
		UNABLE_TO_CREATE_VARIABLE,
		UNABLE_TO_ACCESS_MEMORY,
		UNABLE_TO_OPEN_FILE,
		UNSUPPORTED_FILE_TYPE,
		UNSUPPORTED_VERSION,
		UNABLE_TO_FIND_DEBUGGER,
		ALREADY_DONE,
		PROGRAM_NOT_FOUND,
		UNABLE_TO_CONNECT,
		UNKNOWN_ERROR,
		OTHER_ERROR
	}
	[CCode (cprefix = "IANJUTA_DEBUGGER_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DebuggerOutputType {
		OUTPUT,
		WARNING_OUTPUT,
		ERROR_OUTPUT,
		INFO_OUTPUT
	}
	[CCode (cprefix = "IANJUTA_DEBUGGER_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DebuggerState {
		BUSY,
		STOPPED,
		STARTED,
		PROGRAM_LOADED,
		PROGRAM_STOPPED,
		PROGRAM_RUNNING
	}
	[CCode (cprefix = "IANJUTA_DOCUMENT_MANAGER_DOESNT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum DocumentManagerError {
		EXIST
	}
	[CCode (cprefix = "IANJUTA_EDITOR_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum EditorAttribute {
		TEXT,
		KEYWORD,
		COMMENT,
		STRING
	}
	[CCode (cprefix = "IANJUTA_EDITOR_DOESNT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum EditorError {
		EXIST
	}
	[CCode (cprefix = "IANJUTA_EDITOR_LINE_MODE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum EditorLineModeType {
		LF,
		CR,
		CRLF
	}
	[CCode (cprefix = "IANJUTA_INDICABLE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum IndicableIndicator {
		NONE,
		IMPORTANT,
		WARNING,
		CRITICAL
	}
	[CCode (cprefix = "IANJUTA_MARKABLE_INVALID_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum MarkableError {
		LOCATION
	}
	[CCode (cprefix = "IANJUTA_MARKABLE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum MarkableMarker {
		LINEMARKER,
		BOOKMARK,
		BREAKPOINT_DISABLED,
		BREAKPOINT_ENABLED,
		PROGRAM_COUNTER
	}
	[CCode (cprefix = "IANJUTA_MESSAGE_MANAGER_DOESNT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum MessageManagerError {
		EXIST
	}
	[CCode (cprefix = "IANJUTA_MESSAGE_VIEW_TYPE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum MessageViewType {
		NORMAL,
		INFO,
		WARNING,
		ERROR
	}
	[CCode (cprefix = "IANJUTA_PLUGIN_FACTORY_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum PluginFactoryError {
		OK,
		MISSING_LOCATION,
		MISSING_TYPE,
		MISSING_MODULE,
		INVALID_MODULE,
		MISSING_FUNCTION,
		INVALID_TYPE,
		UNKNOWN_ERROR
	}
	[CCode (cprefix = "IANJUTA_PROJECT_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum ProjectCapabilities {
		CAN_ADD_NONE,
		CAN_ADD_GROUP,
		CAN_ADD_TARGET,
		CAN_ADD_SOURCE,
		HAS_PACKAGES
	}
	[CCode (cprefix = "IANJUTA_PROJECT_ERROR_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum ProjectError {
		SUCCESS,
		DOESNT_EXIST,
		ALREADY_EXISTS,
		VALIDATION_FAILED,
		PROJECT_MALFORMED,
		GENERAL_FAILURE
	}
	[CCode (cprefix = "IANJUTA_PROJECT_PROBE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum ProjectProbe {
		FILES,
		MAKE_FILES,
		PROJECT_FILES
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolField {
		FIELD_ID,
		FIELD_NAME,
		FIELD_FILE_POS,
		FILED_SCOPE_DEF_ID,
		FIELD_FILE_SCOPE,
		FIELD_SIGNATURE,
		FIELD_RETURNTYPE,
		FIELD_TYPE,
		FIELD_TYPE_NAME,
		FIELD_FILE_PATH,
		FIELD_IMPLEMENTATION,
		FIELD_ACCESS,
		FIELD_KIND,
		FIELD_IS_CONTAINER,
		FIELD_END
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_QUERY_DB_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolQueryDb {
		PROJECT,
		SYSTEM
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_QUERY_SEARCH_FS_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolQueryFileScope {
		IGNORE,
		PUBLIC,
		PRIVATE
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_QUERY_MODE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolQueryMode {
		SYNC,
		ASYNC,
		QUEUED
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_QUERY_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolQueryName {
		SEARCH,
		SEARCH_ALL,
		SEARCH_FILE,
		SEARCH_IN_SCOPE,
		SEARCH_ID,
		SEARCH_MEMBERS,
		SEARCH_CLASS_PARENTS,
		SEARCH_SCOPE,
		SEARCH_PARENT_SCOPE,
		SEARCH_PARENT_SCOPE_FILE
	}
	[CCode (cprefix = "IANJUTA_SYMBOL_TYPE_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum SymbolType {
		NONE,
		UNDEF,
		CLASS,
		ENUM,
		ENUMERATOR,
		FIELD,
		FUNCTION,
		INTERFACE,
		MEMBER,
		METHOD,
		NAMESPACE,
		PACKAGE,
		PROTOTYPE,
		STRUCT,
		TYPEDEF,
		UNION,
		VARIABLE,
		EXTERNVAR,
		MACRO,
		MACRO_WITH_ARG,
		FILE,
		OTHER,
		SCOPE_CONTAINER,
		MAX
	}
	[CCode (cprefix = "IANJUTA_VCS_UNKOWN_", cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public enum VcsError {
		ERROR
	}
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public delegate void BuilderCallback (GLib.Object sender, IAnjuta.BuilderHandle command, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", has_target = false)]
	public delegate void DebuggerBreakpointCallback (IAnjuta.DebuggerBreakpointItem data, void* user_data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", has_target = false)]
	public delegate void DebuggerCallback (void* data, void* user_data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", has_target = false)]
	public delegate void DebuggerGCharCallback (string value, void* user_data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", has_target = false)]
	public delegate void DebuggerGListCallback (GLib.List list, void* user_data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", has_target = false)]
	public delegate void DebuggerInstructionCallback (IAnjuta.DebuggerInstructionDisassembly data, void* user_data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", has_target = false)]
	public delegate void DebuggerMemoryCallback (IAnjuta.DebuggerMemoryBlock data, void* user_data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public delegate void DebuggerOutputCallback (IAnjuta.DebuggerOutputType type, string output);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h", has_target = false)]
	public delegate void DebuggerVariableCallback (IAnjuta.DebuggerVariableObject data, void* user_data, GLib.Error err);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public delegate void VcsDiffCallback (GLib.File file, string diff);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public delegate void VcsStatusCallback (GLib.File file, Anjuta.VcsStatus status);
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string BUILDER_CONFIGURATION_DEBUG;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string BUILDER_CONFIGURATION_OPTIMIZED;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string BUILDER_CONFIGURATION_PROFILING;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string BUILDER_ROOT_URI;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string DOCUMENT_MANAGER_CURRENT_DOCUMENT;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string FILE_MANAGER_SELECTED_FILE;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string PROJECT_MANAGER_CURRENT_URI;
	[CCode (cheader_filename = "libanjuta/interfaces/libanjuta-interfaces.h")]
	public const string PROJECT_MANAGER_PROJECT_ROOT_URI;
}
