/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-language-support.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-language-support
 * @title: IAnjutaLanguageSupport
 * @short_description: Programming language specific supports from plugins
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-language-support.h
 * 
 */

#include "ianjuta-language-support.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_language_support_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-language-support-quark");
	}
	
	return quark;
}

GList*
ianjuta_language_support_get_supported_languages (IAnjutaLanguageSupport *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_LANGUAGE_SUPPORT(obj), 0);
	return IANJUTA_LANGUAGE_SUPPORT_GET_IFACE (obj)->get_supported_languages (obj, err);
}

/* Default implementation */
static GList*
ianjuta_language_support_get_supported_languages_default (IAnjutaLanguageSupport *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

gboolean
ianjuta_language_support_supports (IAnjutaLanguageSupport *obj, const gchar *language, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_LANGUAGE_SUPPORT(obj), FALSE);
	g_return_val_if_fail (language != NULL, FALSE);
	return IANJUTA_LANGUAGE_SUPPORT_GET_IFACE (obj)->supports (obj, language, err);
}

/* Default implementation */
static gboolean
ianjuta_language_support_supports_default (IAnjutaLanguageSupport *obj, const gchar *language, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_language_support_base_init (IAnjutaLanguageSupportIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_supported_languages = ianjuta_language_support_get_supported_languages_default;
	klass->supports = ianjuta_language_support_supports_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_language_support_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaLanguageSupportIface),
			(GBaseInitFunc) ianjuta_language_support_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaLanguageSupport", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
