/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-iterable-tree.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-iterable-tree
 * @title: IAnjutaIterableTree
 * @short_description: Implemented by tree objects that can iterate
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-iterable-tree.h
 * 
 */

#include "ianjuta-iterable-tree.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_iterable_tree_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-iterable-tree-quark");
	}
	
	return quark;
}

/**
* ianjuta_iterable_tree_children:
* @obj: Self
* @err: Error propagation and reporting
*
* Iter position set to first child of current iter. If there is no
* children, return NULL (iter position is not changed).
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_iterable_tree_children (IAnjutaIterableTree *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE_TREE(obj), FALSE);
	return IANJUTA_ITERABLE_TREE_GET_IFACE (obj)->children (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_iterable_tree_children_default (IAnjutaIterableTree *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_iterable_tree_foreach_post:
* @obj: Self
* @callback: Callback to call for each element.
* @user_data: User data to pass back to callback.
* @err: Error propagation and reporting
* 
* Call callback for each element in post order.
*/
void
ianjuta_iterable_tree_foreach_post (IAnjutaIterableTree *obj, GFunc callback,   gpointer user_data, GError **err)
{
	g_return_if_fail (IANJUTA_IS_ITERABLE_TREE(obj));
	g_return_if_fail (user_data != NULL);
	IANJUTA_ITERABLE_TREE_GET_IFACE (obj)->foreach_post (obj, callback, user_data, err);
}

/* Default implementation */
static void
ianjuta_iterable_tree_foreach_post_default (IAnjutaIterableTree *obj, GFunc callback,   gpointer user_data, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_iterable_tree_foreach_pre:
* @obj: Self
* @callback: Callback to call for each element.
* @user_data: User data to pass back to callback.
* @err: Error propagation and reporting
* 
* Call callback for each element in pre order.
*/
void
ianjuta_iterable_tree_foreach_pre (IAnjutaIterableTree *obj, GFunc callback,   gpointer user_data, GError **err)
{
	g_return_if_fail (IANJUTA_IS_ITERABLE_TREE(obj));
	g_return_if_fail (user_data != NULL);
	IANJUTA_ITERABLE_TREE_GET_IFACE (obj)->foreach_pre (obj, callback, user_data, err);
}

/* Default implementation */
static void
ianjuta_iterable_tree_foreach_pre_default (IAnjutaIterableTree *obj, GFunc callback,   gpointer user_data, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_iterable_tree_has_children:
* @obj: Self
* @err: Error propagation and reporting
*
* Returns true if current iter has children
*
* Returns: TRUE if there are children, otherwise FALSE.
*/
gboolean
ianjuta_iterable_tree_has_children (IAnjutaIterableTree *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE_TREE(obj), FALSE);
	return IANJUTA_ITERABLE_TREE_GET_IFACE (obj)->has_children (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_iterable_tree_has_children_default (IAnjutaIterableTree *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/** 
* ianjuta_iterable_tree_parent:
* @obj: Self
* @err: Error propagation and reporting
* 
* Set iter position to parent of curernt iter. If there is no parent,
* returns FALSE (current iter position is not changed)
*
* Returns: TRUE if sucessful, otherwise FALSE.
*/
gboolean
ianjuta_iterable_tree_parent (IAnjutaIterableTree *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_ITERABLE_TREE(obj), FALSE);
	return IANJUTA_ITERABLE_TREE_GET_IFACE (obj)->parent (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_iterable_tree_parent_default (IAnjutaIterableTree *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_iterable_tree_base_init (IAnjutaIterableTreeIface* klass)
{
	static gboolean initialized = FALSE;

	klass->children = ianjuta_iterable_tree_children_default;
	klass->foreach_post = ianjuta_iterable_tree_foreach_post_default;
	klass->foreach_pre = ianjuta_iterable_tree_foreach_pre_default;
	klass->has_children = ianjuta_iterable_tree_has_children_default;
	klass->parent = ianjuta_iterable_tree_parent_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_iterable_tree_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaIterableTreeIface),
			(GBaseInitFunc) ianjuta_iterable_tree_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaIterableTree", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_ITERABLE);
	}
	return type;			
}
