/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-assist.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-editor-assist
 * @title: IAnjutaEditorAssist
 * @short_description: Editor assistance framework
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-assist.h
 * 
 */

#include "ianjuta-editor-assist.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_assist_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-assist-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_assist_add_trigger:
 * @obj: Self
 * @trigger: trigger character sequence
 * @context_parser: Callback used to parse the context.
 * @err: Error propagation and reporting
 * 
 * Add the given character sequence as a trigger for begining
 * assist. context_parser is a callback to use to retrieve the
 * context when the trigger happens.
 * 
 * By default there is always a trigger for aphanumeric
 * characters with default context_parser picking up the word
 * just before the carat.
 */
void
ianjuta_editor_assist_add_trigger (IAnjutaEditorAssist *obj, const gchar *trigger,   IAnjutaEditorAssistContextParser context_parser, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj));
	g_return_if_fail (trigger != NULL);
	IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->add_trigger (obj, trigger, context_parser, err);
}

/* Default implementation */
static void
ianjuta_editor_assist_add_trigger_default (IAnjutaEditorAssist *obj, const gchar *trigger,   IAnjutaEditorAssistContextParser context_parser, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_assist_get_suggestions:
 * @obj: Self
 * @context: The context for the suggestions.
 * @err: Error propagation and reporting
 *
 * Usually the editor might have some suggestions to make
 * for a context. For example in a simple word completion context.
 * If the editor has no suggestions to make, it returns NULL.
 * 
 * Returns: A list of suggestions for the given context or NULL
 * if there is nothing to suggest.
 * 
 * Returns: A list of dynamically allocated strings. The whole
 * list, including the the strings should be freed when done.
 */
GList*
ianjuta_editor_assist_get_suggestions (IAnjutaEditorAssist *obj, const gchar *context, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj), 0);
	g_return_val_if_fail (context != NULL, 0);
	return IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->get_suggestions (obj, context, err);
}

/* Default implementation */
static GList*
ianjuta_editor_assist_get_suggestions_default (IAnjutaEditorAssist *obj, const gchar *context, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_editor_assist_react:
 * @obj: Self
 * @selection: The user selection index.
 * @completion: corresponding completion.
 * @err: Error propagation and reporting
 * 
 * When a user makes a choice, the editor is requested to react to
 * it. Usually the editor inserts it at the current carat position
 * and end or update current assist context.
 */
void
ianjuta_editor_assist_react (IAnjutaEditorAssist *obj, gint selection,   const gchar *completion, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj));
	g_return_if_fail (completion != NULL);
	IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->react (obj, selection, completion, err);
}

/* Default implementation */
static void
ianjuta_editor_assist_react_default (IAnjutaEditorAssist *obj, gint selection,   const gchar *completion, GError **err)
{
	g_return_if_reached ();
}

/*
 * ianjuta_editor_assist_remove_trigger:
 * @obj: Self
 * @trigger: the trigger character sequence to remove.
 * @err: Error propagation and reporting
 * 
 * Removes the trigger character sequence. If the trigger is not
 * added, nothing happens.
 */
void
ianjuta_editor_assist_remove_trigger (IAnjutaEditorAssist *obj, const gchar *trigger, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj));
	g_return_if_fail (trigger != NULL);
	IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->remove_trigger (obj, trigger, err);
}

/* Default implementation */
static void
ianjuta_editor_assist_remove_trigger_default (IAnjutaEditorAssist *obj, const gchar *trigger, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_assist_suggest:
 * @obj: Self
 * @choices: list of choices.
 		 * @char_alignment: Character alignment.
 * @err: Error propagation and reporting
 * 
 * Suggest a list of choices to the user. The suggestions are viewed 
 * at char_alignment which should be the beginning of the completed word.
 * If choices is NULL, and assist_end signal
 * will occur
 *
 */
void
ianjuta_editor_assist_suggest (IAnjutaEditorAssist *obj, GList* choices,   int char_alignment, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj));
	IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->suggest (obj, choices, char_alignment, err);
}

/* Default implementation */
static void
ianjuta_editor_assist_suggest_default (IAnjutaEditorAssist *obj, GList* choices,   int char_alignment, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_editor_assist_tip:
 * @obj: Self
 * @tips: list of alternative tips.
 * @char_alignment: Character alignment.
 * @err: Error propagation and reporting
 *
 * Show tips showing more information on current context. No user feedback
 * is required when tips are shown. @char_alignment indicates
 * the position before which is the known context and after which are
 * the suggestions. Usually the editor would use this to
 * align the choices displayed such that the carat is just at this
 * position when the choices are displayed.
 *
 */
void
ianjuta_editor_assist_tip (IAnjutaEditorAssist *obj, GList* tips,   gint char_alignment, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ASSIST(obj));
	IANJUTA_EDITOR_ASSIST_GET_IFACE (obj)->tip (obj, tips, char_alignment, err);
}

/* Default implementation */
static void
ianjuta_editor_assist_tip_default (IAnjutaEditorAssist *obj, GList* tips,   gint char_alignment, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_editor_assist_base_init (IAnjutaEditorAssistIface* klass)
{
	static gboolean initialized = FALSE;

	klass->add_trigger = ianjuta_editor_assist_add_trigger_default;
	klass->get_suggestions = ianjuta_editor_assist_get_suggestions_default;
	klass->react = ianjuta_editor_assist_react_default;
	klass->remove_trigger = ianjuta_editor_assist_remove_trigger_default;
	klass->suggest = ianjuta_editor_assist_suggest_default;
	klass->tip = ianjuta_editor_assist_tip_default;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("assist-begin",
			IANJUTA_TYPE_EDITOR_ASSIST,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorAssistIface, assist_begin),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING_STRING,
			G_TYPE_NONE,
			2,
			G_TYPE_STRING,
			G_TYPE_STRING);

		/* Signal */
		g_signal_new ("assist-canceled",
			IANJUTA_TYPE_EDITOR_ASSIST,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorAssistIface, assist_canceled),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);

		/* Signal */
		g_signal_new ("assist-chosen",
			IANJUTA_TYPE_EDITOR_ASSIST,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorAssistIface, assist_chosen),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);

		/* Signal */
		g_signal_new ("assist-end",
			IANJUTA_TYPE_EDITOR_ASSIST,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorAssistIface, assist_end),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);

		/* Signal */
		g_signal_new ("assist-update",
			IANJUTA_TYPE_EDITOR_ASSIST,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorAssistIface, assist_update),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);


		initialized = TRUE;
	}
}

GType
ianjuta_editor_assist_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorAssistIface),
			(GBaseInitFunc) ianjuta_editor_assist_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorAssist", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
