/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-preferences.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-preferences
 * @title: IAnjutaPreferences
 * @short_description: Preferences interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-preferences
 * 
 */

#include "ianjuta-preferences.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_preferences_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-preferences-quark");
	}
	
	return quark;
}

/**
 * ianjuta_preferences_merge:
 * @obj: Self
 * @prefs: AnjutaPreferences to install to
 * @err: Error propagation and reporting.
 * 
 * When called, the plugin should install it's preferences
 */
void
ianjuta_preferences_merge (IAnjutaPreferences *obj, AnjutaPreferences* prefs, GError **err)
{
	g_return_if_fail (IANJUTA_IS_PREFERENCES(obj));
	g_return_if_fail (ANJUTA_IS_PREFERENCES(prefs));
	IANJUTA_PREFERENCES_GET_IFACE (obj)->merge (obj, prefs, err);
}

/**
 * ianjuta_preferences_unmerge:
 * @obj: Self
 * @prefs: AnjutaPreferences to install to
 * @err: Error propagation and reporting.
 * 
 * When called, the plugin should uninstall it's preferences
 */
void
ianjuta_preferences_unmerge (IAnjutaPreferences *obj, AnjutaPreferences* prefs, GError **err)
{
	g_return_if_fail (IANJUTA_IS_PREFERENCES(obj));
	g_return_if_fail (ANJUTA_IS_PREFERENCES(prefs));
	IANJUTA_PREFERENCES_GET_IFACE (obj)->unmerge (obj, prefs, err);
}

static void
ianjuta_preferences_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_preferences_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaPreferencesIface),
			ianjuta_preferences_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaPreferences", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
