/* This is -*- C -*- */
/* $Id: guppi-config-item.h,v 1.6 2001/01/16 23:36:39 trow Exp $ */

/*
 * guppi-config-item.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CONFIG_ITEM_H
#define _INC_GUPPI_CONFIG_ITEM_H

/* #include <gtk/gtk.h> */
#include <gtk/gtkctree.h>
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiConfigItem GuppiConfigItem;
typedef struct _GuppiConfigItemClass GuppiConfigItemClass;

struct _GuppiConfigItem {
  GtkObject parent;
  gpointer opaque_internals;
};

struct _GuppiConfigItemClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_CONFIG_ITEM (guppi_config_item_get_type())
#define GUPPI_CONFIG_ITEM(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_CONFIG_ITEM,GuppiConfigItem))
#define GUPPI_CONFIG_ITEM0(obj) ((obj) ? (GUPPI_CONFIG_ITEM(obj)) : NULL)
#define GUPPI_CONFIG_ITEM_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_CONFIG_ITEM,GuppiConfigItemClass))
#define GUPPI_IS_CONFIG_ITEM(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_CONFIG_ITEM))
#define GUPPI_IS_CONFIG_ITEM0(obj) (((obj) == NULL) || (GUPPI_IS_CONFIG_ITEM(obj)))
#define GUPPI_IS_CONFIG_ITEM_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_CONFIG_ITEM))

GtkType guppi_config_item_get_type (void);

GuppiConfigItem *guppi_config_item_new (const gchar * name,
					const gchar * short_name,
					GtkWidget *
					(*widget_maker) (gpointer),
					gpointer user_data);

const gchar *guppi_config_item_name (GuppiConfigItem *);
const gchar *guppi_config_item_short_name (GuppiConfigItem *);

gboolean guppi_config_item_has_widget (GuppiConfigItem *);
GtkWidget *guppi_config_item_widget (GuppiConfigItem *);

gboolean guppi_config_item_expand_initially (GuppiConfigItem *);
void guppi_config_item_set_initial_expansion (GuppiConfigItem *, gboolean);

gconstpointer guppi_config_item_tag (GuppiConfigItem *);
void guppi_config_item_set_tag (GuppiConfigItem *, gconstpointer);

GuppiConfigItem *guppi_config_item_prev (GuppiConfigItem *);
GuppiConfigItem *guppi_config_item_next (GuppiConfigItem *);
GuppiConfigItem *guppi_config_item_parent (GuppiConfigItem *);
GuppiConfigItem *guppi_config_item_first_sibling (GuppiConfigItem *);
GuppiConfigItem *guppi_config_item_last_sibling (GuppiConfigItem *);
GuppiConfigItem *guppi_config_item_first_child (GuppiConfigItem *);
GuppiConfigItem *guppi_config_item_last_child (GuppiConfigItem *);

void guppi_config_item_add_before (GuppiConfigItem *,
				   GuppiConfigItem * to_add);
void guppi_config_item_add_after (GuppiConfigItem *,
				  GuppiConfigItem * to_add);
void guppi_config_item_add_below (GuppiConfigItem *,
				  GuppiConfigItem * to_add);
void guppi_config_item_append (GuppiConfigItem *, GuppiConfigItem * to_add);
void guppi_config_item_append_below (GuppiConfigItem *,
				     GuppiConfigItem * to_add);

void guppi_config_item_destroy_tree (GuppiConfigItem *);

void guppi_config_item_foreach (GuppiConfigItem *,
				void (*fn) (GuppiConfigItem *, gpointer),
				gpointer);

GuppiConfigItem *guppi_config_item_find_similar (GuppiConfigItem * root,
						 GuppiConfigItem * item);

GuppiConfigItem *guppi_config_item_find_by_tag (GuppiConfigItem * root,
						gconstpointer tag);

void guppi_config_item_widget_transfer (GuppiConfigItem * dest,
					GuppiConfigItem * src);


void guppi_config_item_build_ctree (GuppiConfigItem *, GtkCTree *);




END_GUPPI_DECLS

#endif /* _INC_GUPPI_CONFIG_ITEM_H */

/* $Id: guppi-config-item.h,v 1.6 2001/01/16 23:36:39 trow Exp $ */
