/* This is -*- C -*- */
/* $Id: guppi-axis-view.c,v 1.13 2001/10/11 21:11:12 trow Exp $ */

/*
 * guppi-axis-view.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 * Copyright (C) 2001 The Free Software Foundation
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-i18n.h>

#include "guppi-axis-state.h"
#include "guppi-axis-view.h"
#include "guppi-axis-item.h"
#include "guppi-axis-print.h"

static GtkObjectClass *parent_class = NULL;

static void
guppi_axis_view_finalize (GtkObject *obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/**************************************************************************/

static void
compute_size (GuppiElementView *view)
{
  GuppiElementState *state = guppi_element_view_state (view);
  GuppiAxisMarkers *am;
  guppi_compass_t pos;
  double w, h;

  guppi_element_state_get (state,
			   "position", &pos,
			   NULL);

  if (pos == GUPPI_NORTH || pos == GUPPI_SOUTH) {
    am = guppi_element_view_axis_markers (view, GUPPI_X_AXIS);
  } else {
    am = guppi_element_view_axis_markers (view, GUPPI_Y_AXIS);
  }
  guppi_axis_state_get_size (GUPPI_AXIS_STATE (state), am, &w, &h);

  guppi_element_view_changed_size (view, w, h);
}

static void
changed_state (GuppiElementView *view)
{
  compute_size (view);

  if (GUPPI_ELEMENT_VIEW_CLASS (parent_class)->changed_state)
    GUPPI_ELEMENT_VIEW_CLASS (parent_class)->changed_state (view);
}

static void
changed (GuppiElementView *view)
{ 
  compute_size (view);

  if (GUPPI_ELEMENT_VIEW_CLASS (parent_class)->changed)
    GUPPI_ELEMENT_VIEW_CLASS (parent_class)->changed (view);
}

/**************************************************************************/

static GtkWidget *
config_cb (gpointer user_data)
{
  return gtk_label_new ("Axis View");
}

static GuppiConfigItem *
config_tree (GuppiElementView *view)
{
  GuppiConfigItem *node;

  node = guppi_config_item_new (_("Axis: Coordinates"),
				_("Coordinates"), config_cb, view);

  return node;
}

/**************************************************************************/

static void
view_init (GuppiElementView *view)
{
  guppi_compass_t pos;

  guppi_element_state_get (guppi_element_view_state (view),
			   "position", &pos,
			   NULL);

#if 0
  guppi_element_view_set_axis_marker_type (view,
					   (pos == GUPPI_NORTH || pos == GUPPI_SOUTH) ? GUPPI_X_AXIS : GUPPI_Y_AXIS,
					   GUPPI_AXIS_SCALAR);
#endif
    
  compute_size (view);

  if (GUPPI_ELEMENT_VIEW_CLASS (parent_class)->view_init)
    GUPPI_ELEMENT_VIEW_CLASS (parent_class)->view_init (view);
}

static void
guppi_axis_view_class_init (GuppiAxisViewClass *klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiElementViewClass *view_class = GUPPI_ELEMENT_VIEW_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_ELEMENT_VIEW);

  object_class->finalize = guppi_axis_view_finalize;

  view_class->changed_state = changed_state;
  view_class->changed = changed;

  view_class->canvas_item_type = GUPPI_TYPE_AXIS_ITEM;
  view_class->print_type = GUPPI_TYPE_AXIS_PRINT;
  view_class->view_init = view_init;

  view_class->config_tree = config_tree;
}

static void
guppi_axis_view_init (GuppiAxisView *obj)
{

}

GtkType guppi_axis_view_get_type (void)
{
  static GtkType guppi_axis_view_type = 0;
  if (!guppi_axis_view_type) {
    static const GtkTypeInfo guppi_axis_view_info = {
      "GuppiAxisView",
      sizeof (GuppiAxisView),
      sizeof (GuppiAxisViewClass),
      (GtkClassInitFunc) guppi_axis_view_class_init,
      (GtkObjectInitFunc) guppi_axis_view_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_axis_view_type =
      gtk_type_unique (GUPPI_TYPE_ELEMENT_VIEW, &guppi_axis_view_info);
  }
  return guppi_axis_view_type;
}

/* $Id: guppi-axis-view.c,v 1.13 2001/10/11 21:11:12 trow Exp $ */
