/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* vim: set sw=8: */

/*
 * guppi-gnumeric-manager.h
 *
 * Copyright (C) 2000-2001 Helix Code, Inc.
 *
 * Developed by Jody Goldberg <jgoldberg@home.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUP_GNM_MANAGER_H
#define _INC_GUP_GNM_MANAGER_H

#include "guppi-gnumeric-manager-version.h"
#include "guppi-gnumeric.h"
#include "guppi-chart-selector.h"
#include <guppi-defs.h>
#include <guppi-seq.h>
#include <guppi-color-palette.h>
#include <guppi-root-group-view.h>

#include <gnome-xml/tree.h>
#include <bonobo.h>

BEGIN_GUPPI_DECLS

struct _GupGnmManager {
	BonoboEmbeddable parent;

	GuppiRootGroupView *plot;

	GSList *views;
	struct {
		GtkWidget	*widget;
		BonoboControl	*control;
	} chart_type_selector;
	struct {
		BonoboControl	*control;
		GnomeCanvas	*canvas;
		GuppiCanvasItem *root_item;
	} sample;

	struct {
		GuppiData	  *names;
		GuppiColorPalette *colours;
		GArray		  *markers;
	} series;

	GPtrArray *vectors;
	GPtrArray *wrapper_sequences;
	xmlDoc *doc;

	int arrangement_len;
	int *data_ids, *header_ids;
};

typedef struct {
	BonoboEmbeddableClass parent;

	POA_GUPPI_GNUMERIC_MANAGER(epv)	epv;
} GupGnmManagerClass;

#define GUP_GNM_MANAGER_TYPE        (gup_gnm_manager_get_type ())
#define GUP_GNM_MANAGER(o)          (GTK_CHECK_CAST ((o), GUP_GNM_MANAGER_TYPE, GupGnmManager))
#define GUP_GNM_MANAGER_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), GUP_GNM_MANAGER_TYPE, GupGnmManagerClass))
#define IS_GUP_GNM_MANAGER(o)       (GTK_CHECK_TYPE ((o), GUP_GNM_MANAGER_TYPE))
#define IS_GUP_GNM_MANAGER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GUP_GNM_MANAGER_TYPE))

GtkType gup_gnm_manager_get_type (void);
GupGnmManager  *gup_gnm_manager_new (void);

GuppiRootGroupView *gup_gnm_manager_get_plot (GupGnmManager *manager);
void	gup_gnm_manager_set_plottype	  (GupGnmManager *manager,
					   xmlNode *plottype);
void	gup_gnm_manager_add_vector	  (GupGnmManager *manager,
					   GupGnmVector *vector,
					   unsigned id);
GupGnmVector *gup_gnm_manager_get_vector  (GupGnmManager const *manager,
					   unsigned id);

void gup_gnm_manager_add_view	    (GupGnmManager *manager, GupGnmView *view);
void gup_gnm_manager_remove_view    (GupGnmManager *manager, GupGnmView *view);

void gup_gnm_manager_add_wrapper    (GupGnmManager *manager, GuppiData *wrapper);
void gup_gnm_manager_clear_wrappers (GupGnmManager *manager);

END_GUPPI_DECLS

#endif /* _INC_GUP_GNM_MANAGER_H */
