/* -*- mode: C; c-basic-offset: 4 -*-
 * Copyright (C) 2002 James Henstridge
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>

#include <gtk/gtk.h>
#include <libgnome/gnome-i18n.h>
#include <libbonobo.h>
#include <libgnomevfs/gnome-vfs-utils.h>

static void
handle_event(BonoboListener *listener, const gchar *event_name,
	     const CORBA_any *args, CORBA_Environment *ev, gpointer user_data)
{
	const CORBA_sequence_CORBA_string *list;
	gchar *image_name = NULL;
	
	if (!CORBA_TypeCode_equivalent(args->_type, TC_CORBA_sequence_CORBA_string, ev)) {
		return;
	}
	list = (CORBA_sequence_CORBA_string *)args->_value;
	
	if (list->_length != 1) {
		return;
	}
	
	image_name = gnome_vfs_get_local_path_from_uri (list->_buffer[0]);
	if (image_name == NULL) {
		g_warning ("Can not get local path for URI %s", list->_buffer[0]);
		return;
	}

	if (!strcmp(event_name, "WriteToCD")) {
		GError *error = NULL;
		const char *argv[3];
		argv[0] = BINDIR "/nautilus-cd-burner";
		argv[1] = image_name;
		argv[2] = NULL;
		if (!g_spawn_async  (NULL, (char **)argv,
				     NULL, 0,
				     NULL, NULL,
				     NULL, &error)) {
			g_warning ("nautilus-cd-burner command failed: %s", error->message);
			g_error_free (error);
		}
	}
	g_free(image_name);
}

/* --- factory --- */

static BonoboObject *
view_factory(BonoboGenericFactory *this_factory,
	     const gchar *iid,
	     gpointer user_data)
{
    BonoboListener *listener;

    listener = bonobo_listener_new(handle_event, NULL);

    return BONOBO_OBJECT(listener);
}

int
main(int argc, char *argv[])
{
    bindtextdomain(GETTEXT_PACKAGE, GNOMELOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);

    BONOBO_FACTORY_INIT(_("CD burning context menu items"), VERSION,
			&argc, argv);

    return bonobo_generic_factory_main("OAFIID:Nautilus_CD_Burner_Context_Menu_Factory",
				       view_factory, NULL);
}
