/* gnopi.c
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include "util.h"
#include "SRMessages.h"
#include "gnopiconf.h"
#include "gnopiui.h"
#include "brlui.h"
#include "defui.h"
#include "genui.h"
#include "kbui.h"
#include "magui.h"
#include "spui.h"
#include "cmdmapui.h"
#include "findui.h"
#include "presui.h"
#include "langui.h"
#include "scrui.h"


#include <signal.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "srintl.h"

#define GN_SHKEY 34556
#define GN_SEGSIZE 10

/*#define __WAIT_DEBUG__  */

/**
 *
 * Instance of "Braille setting" structure
 *
**/
Braille   		*braille_setting = NULL;

/**
 *
 * Instance of "General setting" structure
 *
**/
General   		*general_setting = NULL;

/**
 *
 * Instance of "Keyboard setting" structure
 *
**/
Keyboard  		*keyboard_setting = NULL;

/**
 *
 * Instance of "Speech setting" structure				
 *
**/
Speech 	  		*speech_setting = NULL;

/**
 *
 * Instance of "Magnifier setting"used in gnopi				
 *
**/
Magnifier 		*magnifier_setting = NULL;

/**
 *
 * Test the parameters list from line command.
 *
**/
static gboolean gn_run_with_parameters();

/**
 *
 * Test if it lunched more then one time.
 * return - TRUE no multiple execution
 *
**/
static gboolean gn_no_multiple_instance();

/**
 *
 * Destroy shared memory and message queue.
 * return - FALSE if error;
 *
**/
static gboolean gn_destroy_instance();

/**
 *
 * Initialize all gconf client and load all settings.
 * return - FALSE error
 *
**/
static gboolean gn_init();

/**
 *
 * Destroy all gconf client and all internal structure
 *
**/
static gboolean gn_terminate();

/**
 *
 * Launch in executions SRCORE
 *
**/
static gboolean gn_run_srcore();

/**
 *
 * Wait for end of execiton of child process
 *
**/
static gboolean gn_child_process_wait();

/**
 *
 * If the settings loaded with default values?
 *
**/
static gboolean gn_loaddefault = FALSE;

/**
 *
 * Shared memory id.
 *
**/
static gint 	gn_semid;

/**
 *
 * sr_pid - process id of srcore 
 *
**/
static gint	gn_srcore_pid;
extern gint 	bm_pid;
/**
 *
 * srcore_status - exit status of srcore process
 *
**/
static gint	gn_srcore_status;

static gboolean gn_defaultmode = FALSE;

struct poptOption poptopt[] = 
    {		
	{"default", 	'd', POPT_ARG_NONE, &gn_defaultmode, 'd', "Lunch in execution with default settings", NULL},
	{NULL, 		0,0, NULL, 0}
    };

gint 
main (gint argc,gchar *argv[])
{
#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE, GNOPERNICUSLOCALEDIR);
    textdomain (GETTEXT_PACKAGE);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
#endif    

    gnome_program_init ("gnopernicus", VERSION,
			LIBGNOMEUI_MODULE,
			argc, argv,
			GNOME_PARAM_POPT_TABLE, poptopt,
			GNOME_PARAM_HUMAN_READABLE_NAME, _("gnopernicus"),
			GNOME_PARAM_APP_DATADIR, DATADIR,
			NULL);
    sru_log_init ();
                        
    if (!gn_run_with_parameters ())
    {
	sru_warning (_("gnopi:Invalid parameters"));
	return EXIT_FAILURE;
    }
	
    if (!gn_no_multiple_instance ())
    {
        sru_message (_("gnopi : Multiple instances are NOT ALLOWED.\n This instance will end."));
        return EXIT_FAILURE;
    }

    if (!gtk_init_check (&argc, &argv))
    {
        sru_warning (_("gnopi:GTK initialization."));
        return EXIT_FAILURE;
    }
	
    if (!gn_run_srcore ())
    {
        sru_warning (_("gnopi:Can not create a new process"));
        return EXIT_FAILURE;
    }
	        
    if (!gn_init ()) 
    {
        sru_warning (_("gnopi:Gconf initialization error"));
	srcore_exit_all (TRUE);
        return EXIT_FAILURE;
    }
	
    if (!gn_load_gnopi ())
    {
        sru_warning (_("gnopi:Can not load .glade2 file"));
        return EXIT_FAILURE;
    }
	
    if (srcore_minimize_get ())
    	gn_iconify_gnopernicus 	();
    
    gtk_main ();

    gn_terminate ();

    gn_child_process_wait ();
    
    gn_destroy_instance ();

    sru_log_terminate ();
    
    return EXIT_SUCCESS;
}



/**
 *
 * Test the parameters list from line command.
 *
**/
gboolean 
gn_run_with_parameters (void)
{    
    if (gn_defaultmode)
	gn_loaddefault = TRUE;
    
    return TRUE;
}

/**
 *
 * Initialize all gconf client and load all settings.
 * return - FALSE error
 *
**/
gboolean 
gn_init (void)
{
    sru_return_val_if_fail (gnopiconf_gconf_client_init(), FALSE);
    sru_return_val_if_fail (brlconf_gconf_client_init (), FALSE);
    sru_return_val_if_fail (kbconf_gconf_client_init (), FALSE);
    sru_return_val_if_fail (spconf_gconf_client_init (), FALSE);
    sru_return_val_if_fail (magconf_gconf_client_init (), FALSE);
    sru_return_val_if_fail (srcore_gconf_client_init (), FALSE);
    sru_return_val_if_fail (cmdconf_gconf_client_init (), FALSE);
    sru_return_val_if_fail (presconf_gconf_init (), FALSE);
        
    braille_setting   = brlconf_setting_init (TRUE);
    keyboard_setting  = kbconf_setting_init (TRUE);
    speech_setting    = spconf_setting_init (TRUE);
    general_setting   = srcore_general_setting_init (TRUE);
        
    if (general_setting->braille_monitor) 
    {
	genui_run_brlmonitor ();
	sleep (1);
    }
	
    srcore_exit_all (FALSE);
    
    if (gn_loaddefault) 
	defui_load_all_default ();
/*    
    lng_set_envirom (srcore_language_get ());
*/
    return TRUE;
}

/**
 *
 * Destroy all gconf client and all internal structure
 *
**/
gboolean 
gn_terminate (void)
{
    brlconf_terminate	(braille_setting);
    kbconf_terminate	(keyboard_setting);
    spconf_terminate	(speech_setting);
    magconf_terminate	(magnifier_setting);
    srcore_terminate	(general_setting);
    cmdconf_terminate	();
    presconf_gconf_terminate();
    return TRUE;
}

static void
gn_child_exited (gint signo)
{
    if (signo == SIGCHLD)
    {
        if (waitpid (gn_srcore_pid, &gn_srcore_status, WNOHANG) == gn_srcore_pid)
	{
	    if (WIFEXITED (gn_srcore_status) == 0)
	    {
/*	        if (WIFSIGNALED (gn_srcore_status) != 0)
		    sru_message ("signal no: %d", WTERMSIG (gn_srcore_status));*/
		sru_warning (_("srcore exited."));
		gdk_beep ();
	    }
	}
    }
}

/**
 *
 * Launch in executions SRCORE
 *
**/

gboolean 
gn_run_srcore (void)
{
    signal (SIGCHLD, gn_child_exited);			
    
    if (g_file_test ("../srcore/srcore", G_FILE_TEST_EXISTS) &&
        g_file_test ("../srcore/srcore", G_FILE_TEST_IS_EXECUTABLE) &&
	g_file_test ("../srcore/srcore", G_FILE_TEST_IS_REGULAR))
    {
	gchar *args[] = {"../srcore/srcore",NULL};
	if (!g_spawn_async ( ".", args , NULL, 
			    G_SPAWN_DO_NOT_REAP_CHILD,
			    NULL, NULL, &gn_srcore_pid, NULL))
	{
	    sru_message (_("No srcore binary file found [errno: %i]."),errno);
	    return FALSE;
	}
    }
    else
    if (g_file_test ("./srcore", G_FILE_TEST_EXISTS) &&
    	g_file_test ("./srcore", G_FILE_TEST_IS_EXECUTABLE) &&
	g_file_test ("./srcore", G_FILE_TEST_IS_REGULAR))
    {
	gchar *args[] = {"./srcore",NULL};
	if (!g_spawn_async ( ".", args , NULL, 
			G_SPAWN_DO_NOT_REAP_CHILD,
			NULL, NULL, &gn_srcore_pid, NULL))
	{
	    sru_message (_("No srcore binary file found [errno: :%i]"),errno);
	    return FALSE;
	}
    }
    else
    {
	gchar *args[] = {"srcore",NULL};
	if (!g_spawn_async ( ".", args, NULL, 
			    G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH,
			    NULL, NULL, &gn_srcore_pid, NULL))
	{
	    sru_message (_("No srcore binary file found [errno: :%i]"),errno);
	    return FALSE;
	}
    }
			
    return TRUE;
}

/**
 *
 * Test if it lunched more then one time.
 * return - TRUE no multiple execution
 *
**/
gboolean 
gn_no_multiple_instance (void)
{
    key_t key;
    gchar *shmptr;
    gchar *text;
    gint pd = 0;

    signal (SIGUSR1,SIG_IGN);

    /*if ((key = ftok(".",'g')) == -1)	return FALSE; */
    
    key = GN_SHKEY;

    if ((gn_semid = shmget (key, GN_SEGSIZE, IPC_CREAT|IPC_EXCL|0666)) == -1)
    {
	if ((gn_semid = shmget (key, GN_SEGSIZE, 0)) == -1) return FALSE;
	    else
	    {
		if ((shmptr = (gchar*) shmat (gn_semid, 0, 0)) == NULL) return FALSE;

		pd = atoi (shmptr);
		
		if (pd == 0)
    		{
		    sru_error (_("No srcore in execution"));
		    return FALSE;
		}

		if (kill (pd, SIGUSR1) == -1)
		{
		    if (errno == ESRCH)
		    {
			pd   = getpid ();
                        text = g_strdup_printf ("%i", pd);
			g_stpcpy (shmptr, text);
			g_free (text);
			text = NULL;
			return TRUE;
		    }
		}
	    }
	return FALSE;
    }
    else
    {
	if ((shmptr = (gchar*)shmat (gn_semid, 0, 0)) == NULL) 
	    return FALSE;
	pd   = getpid ();
        text = g_strdup_printf ("%i", pd);
	g_stpcpy (shmptr, text);
	g_free (text);
	text = NULL;
    }
    return TRUE;
}

/**
 *
 * Destroy shared memory and message queue.
 * return - FALSE if error;
 *
**/
gboolean 
gn_destroy_instance (void)
{
    shmctl (gn_semid, IPC_RMID, 0);
    gn_semid = 0;
    return TRUE;
}

/**
 *
 * Wait for end of execiton of child process
 *
**/
gboolean 
gn_child_process_wait (void)
{    
    if (waitpid (gn_srcore_pid, &gn_srcore_status, WNOHANG) == gn_srcore_pid)
    {
#ifdef __WAIT_DEBUG__
	    if (WIFEXITED (gn_srcore_status)  != 0)
		    sru_message ("Exit cod: %d", WEXITSTATUS(gn_srcore_status));
    
	    if (WIFSIGNALED(gn_srcore_status) != 0)
		    sru_message ("Signaled: %d", WTERMSIG(gn_srcore_status));
#endif
	gn_srcore_pid = 0;
    }
    
    /* Emit terminate signal to BrlMonitor that it to be sure it is exited */
    if (bm_pid != 0)
    {
	kill (bm_pid, SIGTERM);
    }
	
    /* Emit terminate signal to SRCore that it to be sure it is exited */
    if (gn_srcore_pid != 0)
    {
	kill (gn_srcore_pid, SIGTERM);
    }
    
    return TRUE;    
}
