/*
 * jEdit - Programmer's Text Editor
 * :tabSize=8:indentSize=8:noTabs=false:
 * :folding=explicit:collapseFolds=1:
 *
 * Copyright © 2021 jEdit contributors
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.gjt.sp.jedit.io;

import java.io.IOException;
import java.io.InputStream;

/**
 * A "detector" that always returns the same charset.
 *
 * @author Matthieu Casanova
 */
public class StaticCharsetEncodingDetector implements EncodingDetector
{
	private final String charset;

	public StaticCharsetEncodingDetector(String charset)
	{
		this.charset = charset;
	}

	@Override
	public String detectEncoding(InputStream sample) throws IOException
	{
		return charset;
	}

	@Override
	public String toString()
	{
		return "StaticCharsetEncodingDetector{charset='" + charset + '\'' + '}';
	}
}
