/***************************************************************************
 *   crwx-ng                                                               *
 *   Copyright (C) 2007,2009 Vadim Lopatin <coolreader.org@gmail.com>      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,            *
 *   MA 02110-1301, USA.                                                   *
 ***************************************************************************/

#ifndef _WOLOPT_H_
#define _WOLOPT_H_

#include <wx/wx.h>

/**
 * @short WOL export options window
 * @author Vadim Lopatin <vadim.lopatin@coolreader.org>
 * @version 0.1
 */

class WolOptions: public wxDialog
{
private:
    wxComboBox* cbMode;
    wxComboBox* cbLevels;
public:
    WolOptions(wxWindow* parent);
    virtual ~WolOptions();

    int getMode() {
        return cbMode->GetCurrentSelection();
    }
    int getLevels() {
        return cbLevels->GetCurrentSelection() + 1;
    }
    void OnInitDialog(wxInitDialogEvent& event);
private:
    DECLARE_EVENT_TABLE()
};

#endif // _WOLOPT_H_
