/* vim: set shiftwidth=4 tabstop=8 softtabstop=4: */
/* $Id: libspt.h,v 1.16 2003/12/06 18:43:01 shinra Exp $ */

#ifndef LIBSPT_H
#define LIBSPT_H

#if defined(__CYGWIN__) && !defined(LIBSPT_STATIC)
# ifdef IN_LIBSPT
#  ifdef DLL_EXPORT
#   define SPT_EXPORT(t) __declspec(dllexport) t
#  else
#   define SPT_EXPORT(t) t
#  endif
# else
#  define SPT_EXPORT(t) __declspec(dllimport) t
# endif
# define SPT_EXPORT_VAR(t) SPT_EXPORT(t)
#endif
#ifndef SPT_EXPORT
# define SPT_EXPORT(t) t
#endif
#ifndef SPT_EXPORT_VAR
# define SPT_EXPORT_VAR(t) t
#endif

enum {
    SPT_E_NONE = 0,
    SPT_E_INVAL = 1,
    SPT_E_NOMEM = 2,
    SPT_E_UNKNOWN = 3,
    SPT_E_AGENT_VERSION = 4,
    SPT_E_AGENT_EXEC = 5,
    SPT_E_AGENT_INST = 6,
    SPT_E_AGENT_FATAL = 7,
    SPT_E_AGENT_DEAD = 8,
    SPT_E_CHOWN_FAIL = 9,   /* chmod() or chown() to slave pty failed */
    SPT_E_UTMP_FAIL = 10,
    SPT_E_NOTTY = 11,
    SPT_E_RESOURCE = 12,
    SPT_E_CLEANUP_FAIL = 13,
    SPT_E_TTYINIT_FAIL = 14,
    SPT_E_CTTY_FAIL = 15,
    SPT_E_STTY_FAIL = 16,
};

typedef struct spt_handle_tag spt_handle;
typedef struct spt_termios_tag spt_termios;
typedef void (*spt_cleanup_proc) (void *arg);

/* 
 * SPT_E_CHOWN_FAIL and SPT_E_CLEANUP_FAIL are only for warning.
 * You may ignore them.
 *
 * After fork(), REMEMBER TO CALL spt_detach(), and close masterfd
 * and slavefd yourself.
 */
#ifdef __cplusplus
extern "C" {
#endif
extern SPT_EXPORT(int) spt_open_pty(spt_handle **pphandle, int *pmasterfd,
	spt_cleanup_proc cleanup, void *cleanuparg);
extern SPT_EXPORT(int) spt_close_pty(spt_handle *phandle);
extern SPT_EXPORT(void) spt_detach_handle(spt_handle *phandle);

extern SPT_EXPORT(int) spt_get_slavename(
	const spt_handle *phandle, char **pname);
extern SPT_EXPORT(void) spt_free_obj(void *pobj);
extern SPT_EXPORT(int) spt_init_slavefd(const spt_handle *phandle, int fd);

extern SPT_EXPORT(int) spt_utmp_set_host(
	spt_handle *phandle, const char *host);
extern SPT_EXPORT(int) spt_utmp_set_pid(spt_handle *phandle, pid_t pid);
extern SPT_EXPORT(int) spt_utmp_set_exit(spt_handle *phandle, int exit_st);
extern SPT_EXPORT(int) spt_login_utmp(spt_handle *phandle);
extern SPT_EXPORT(int) spt_logout_utmp(spt_handle *phandle);
extern SPT_EXPORT(int) spt_login_wtmp(spt_handle *phandle);
extern SPT_EXPORT(int) spt_logout_wtmp(spt_handle *phandle);
extern SPT_EXPORT(int) spt_update_lastlog(spt_handle *phandle);
extern SPT_EXPORT(const char *) spt_strerror(int errnum);
extern SPT_EXPORT(void) spt_perror(const char *str, int errnum);

/* utility functions */
extern SPT_EXPORT(int) spt_open_slave(
	const spt_handle *phandle); /* check errno */
extern SPT_EXPORT(int) spt_set_ctty2(int slavefd);
extern SPT_EXPORT(int) spt_detach_ctty(void);
extern SPT_EXPORT(int) spt_fork_pty(spt_handle **pphandle, int *pmasterfd,
	int *pslavefd, pid_t *pidptr, const char *host);

/* termios wrappers */
extern SPT_EXPORT_VAR(spt_termios) spt_termios_buf1;
extern SPT_EXPORT_VAR(spt_termios) spt_termios_buf2;
extern SPT_EXPORT_VAR(spt_termios) spt_termios_buf3;
extern SPT_EXPORT_VAR(spt_termios) spt_termios_buf4;
extern SPT_EXPORT(int) spt_termios_alloc(spt_termios **ppterm);
extern SPT_EXPORT(void) spt_termios_copy(
	spt_termios *dst, const spt_termios *src);
extern SPT_EXPORT(int) spt_termios_get(spt_termios *pterm, int fd);
extern SPT_EXPORT(int) spt_termios_set(const spt_termios *pterm, int fd);
extern SPT_EXPORT(int) spt_termios_sset(
	const spt_termios *pterm, int fd, const spt_termios *pold);
extern SPT_EXPORT(void) spt_termios_default(spt_termios *pterm);
extern SPT_EXPORT(void) spt_termios_raw(spt_termios *pterm);
extern SPT_EXPORT(int) spt_termios_fd_default(int fd);

/* obsolete functions */
/* spt_set_ctty was removed */
#ifdef __cplusplus
}
#endif

#endif /* LIBSPT_H */
