/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.reader.SvgMetadataReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public final class ImageMetadataFilter
extends AbstractXMLFilter {
    private static final String ATTR_VERTICAL_DPI = "vertical-dpi";
    private static final String ATTR_HORIZONTAL_DPI = "horizontal-dpi";
    private static final String ATTR_IMAGE_HEIGHT = "image-height";
    private static final String ATTR_IMAGE_WIDTH = "image-width";
    private static final float MM_TO_INCH = 25.4f;
    public static final Attributes EMPTY_ATTR = new AttributesImpl();
    private final File outputDir;
    private final File tempDir;
    private final String uplevels;
    private int depth = 0;
    private final Map<URI, Attributes> cache;
    private final Job job;
    private final XMLReader reader;
    private final SvgMetadataReader svgMetadataReader;

    public ImageMetadataFilter(File outputDir, Job job, Map<URI, Attributes> cache) {
        this.outputDir = outputDir;
        this.job = job;
        this.tempDir = job.tempDir;
        this.uplevels = job.getProperty("uplevels");
        this.cache = cache;
        this.svgMetadataReader = new SvgMetadataReader();
        try {
            this.reader = XMLUtils.getXMLReader();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.reader.setContentHandler(this.svgMetadataReader);
        this.reader.setEntityResolver(new SvgMetadataReader.EmptyEntityResolver());
    }

    @Override
    public void write(File filename) {
        if (filename == null || !this.job.getStore().exists(filename.toURI())) {
            return;
        }
        this.svgMetadataReader.setLogger(this.logger);
        this.svgMetadataReader.setJob(this.job);
        this.currentFile = filename.toURI();
        this.logger.info("Processing " + filename.getAbsolutePath());
        try {
            super.write(filename);
        }
        catch (DITAOTException e) {
            this.logger.error("Failed to read image metadata: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public Collection<URI> getImages() {
        return List.copyOf(this.cache.keySet());
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (Constants.TOPIC_IMAGE.matches(atts) || Constants.SVG_D_SVGREF.matches(atts)) {
            XMLUtils.AttributesBuilder a = new XMLUtils.AttributesBuilder(atts);
            URI href = URLUtils.toURI(atts.getValue("href"));
            if (href != null) {
                URI imgInput = this.getImageFile(href);
                if (imgInput != null) {
                    Attributes m = this.cache.computeIfAbsent(imgInput, this::readMetadata);
                    a.addAll(m);
                } else {
                    this.logger.error("Image file " + String.valueOf(href) + " not found");
                }
            }
            this.depth = 1;
            super.startPrefixMapping("dita-ot", "http://dita-ot.sourceforge.net/ns/201007/dita-ot");
            super.startElement(uri, localName, name, a.build());
        } else {
            if (this.depth > 0) {
                ++this.depth;
            }
            super.startElement(uri, localName, name, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.depth > 0) {
            if (this.depth == 1) {
                super.endPrefixMapping("dita-ot");
            }
            --this.depth;
        }
    }

    private Attributes readMetadata(URI imgInput) {
        String mimeType;
        this.logger.info("Reading " + String.valueOf(imgInput));
        return switch (mimeType = this.getMimeType(imgInput)) {
            case "image/svg+xml" -> this.readSvgMetadata(imgInput);
            default -> this.readBitmapMetadata(imgInput);
        };
    }

    private Attributes readSvgMetadata(URI imgInput) {
        Attributes attributes;
        block8: {
            InputStream in = this.getInputStream(imgInput);
            try {
                this.reader.parse(new InputSource(in));
                attributes = this.svgMetadataReader.getDimensions().getAttributes();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    this.logger.error("Failed to read image " + String.valueOf(imgInput) + " metadata: " + e.getMessage(), e);
                    return EMPTY_ATTR;
                }
            }
            in.close();
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Attributes readBitmapMetadata(URI imgInput) {
        try {
            InputStream in = null;
            ImageReader r = null;
            ImageInputStream iis = null;
            try {
                NodeList vs;
                in = this.getInputStream(imgInput);
                iis = ImageIO.createImageInputStream(in);
                Iterator<ImageReader> i = ImageIO.getImageReaders(iis);
                if (!i.hasNext()) {
                    this.logger.info("Image " + String.valueOf(imgInput) + " format not supported");
                    return EMPTY_ATTR;
                }
                r = i.next();
                r.setInput(iis);
                int imageIndex = r.getMinIndex();
                Dimensions dimensions = new Dimensions();
                dimensions.width = Integer.toString(r.getWidth(imageIndex));
                dimensions.height = Integer.toString(r.getHeight(imageIndex));
                Element node = (Element)r.getImageMetadata(0).getAsTree("javax_imageio_1.0");
                NodeList hs = node.getElementsByTagName("HorizontalPixelSize");
                if (hs != null && hs.getLength() == 1) {
                    float v = Float.parseFloat(((Element)hs.item(0)).getAttribute("value"));
                    int dpi = Math.round(25.4f / v);
                    dimensions.horizontalDpi = Integer.toString(dpi);
                }
                if ((vs = node.getElementsByTagName("VerticalPixelSize")) != null && vs.getLength() == 1) {
                    float v = Float.parseFloat(((Element)vs.item(0)).getAttribute("value"));
                    int dpi = Math.round(25.4f / v);
                    dimensions.verticalDpi = Integer.toString(dpi);
                }
                Attributes attributes = dimensions.getAttributes();
                return attributes;
            }
            finally {
                if (r != null) {
                    r.dispose();
                }
                if (iis != null) {
                    iis.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.error("Failed to read image " + String.valueOf(imgInput) + " metadata: " + e.getMessage(), e);
            return EMPTY_ATTR;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Failed to read image " + String.valueOf(imgInput) + " metadata: " + e.getMessage(), e);
        }
        return EMPTY_ATTR;
    }

    private String getMimeType(URI imgInput) {
        if (imgInput.getScheme().equals("data")) {
            int separator;
            String data = imgInput.getSchemeSpecificPart();
            String metadata = data.substring(0, separator = data.indexOf(44));
            int semicolon = metadata.indexOf(59);
            if (semicolon != -1) {
                return metadata.substring(0, semicolon);
            }
        } else if (imgInput.getPath() != null && imgInput.getPath().endsWith(".svg")) {
            return "image/svg+xml";
        }
        return "default";
    }

    private InputStream getInputStream(URI imgInput) throws IOException {
        if (imgInput.getScheme().equals("data")) {
            int separator;
            String data = imgInput.getSchemeSpecificPart();
            String metadata = data.substring(0, separator = data.indexOf(44));
            if (metadata.endsWith(";base64")) {
                this.logger.info("Base-64 encoded data URI");
                return new ByteArrayInputStream(BaseEncoding.base64().decode((CharSequence)data.substring(separator + 1)));
            }
            this.logger.info("ASCII encoded data URI");
            return new ByteArrayInputStream(data.substring(separator).getBytes());
        }
        return imgInput.toURL().openConnection().getInputStream();
    }

    private URI getImageFile(URI href) {
        URI srcTempURI;
        Job.FileInfo fi = this.job.getFileInfo(this.currentFile.resolve(href));
        URI fileName = fi != null ? this.job.getInputDir().relativize(fi.src) : href;
        URI outputURI = this.outputDir.toURI().resolve(fileName);
        if (URLUtils.exists(outputURI)) {
            this.logger.debug("Found " + String.valueOf(outputURI));
            return outputURI;
        }
        URI tempURI = this.job.tempDirURI.resolve(fileName);
        if (URLUtils.exists(tempURI)) {
            this.logger.debug("Found " + String.valueOf(tempURI));
            return tempURI;
        }
        if (fi != null && URLUtils.exists(srcTempURI = this.job.tempDirURI.resolve(fi.uri))) {
            this.logger.debug("Found " + String.valueOf(srcTempURI));
            return srcTempURI;
        }
        URI srcURI = this.job.getInputDir().resolve(fileName);
        if (URLUtils.exists(srcURI)) {
            this.logger.debug("Found " + String.valueOf(srcURI));
            return srcURI;
        }
        return null;
    }

    public static class Dimensions {
        public String height;
        public String width;
        public String horizontalDpi;
        public String verticalDpi;

        public Attributes getAttributes() {
            XMLUtils.AttributesBuilder a = new XMLUtils.AttributesBuilder();
            if (this.width != null) {
                a.add("http://dita-ot.sourceforge.net/ns/201007/dita-ot", ImageMetadataFilter.ATTR_IMAGE_WIDTH, "dita-ot:image-width", "CDATA", this.width);
            }
            if (this.height != null) {
                a.add("http://dita-ot.sourceforge.net/ns/201007/dita-ot", ImageMetadataFilter.ATTR_IMAGE_HEIGHT, "dita-ot:image-height", "CDATA", this.height);
            }
            if (this.horizontalDpi != null) {
                a.add("http://dita-ot.sourceforge.net/ns/201007/dita-ot", ImageMetadataFilter.ATTR_HORIZONTAL_DPI, "dita-ot:horizontal-dpi", "CDATA", this.horizontalDpi);
            }
            if (this.verticalDpi != null) {
                a.add("http://dita-ot.sourceforge.net/ns/201007/dita-ot", ImageMetadataFilter.ATTR_VERTICAL_DPI, "dita-ot:vertical-dpi", "CDATA", this.verticalDpi);
            }
            return a.build();
        }
    }
}

