/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.java1.gcf.http;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.microedition.io.HttpConnection;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.ConnectionImpl;
import org.me4se.impl.Log;

public class HttpConnectionImpl
extends ConnectionImpl
implements HttpConnection {
    static final String[] ESCAPE_HEADER = new String[]{"cookie", "set-cookie", "set-cookie2", "cookie2"};
    URL url;
    protected HttpURLConnection con;
    String proxy;
    int responseCode = -1;
    static final int OPEN_OUTPUT_STREAM = 1;
    static final int GET_RESPONSE_CODE = 2;
    static final int OPEN_INPUT_STREAM = 3;

    Object doPrivileged(int action) throws IOException {
        Privileged pa = new Privileged(action);
        try {
            return ApplicationManager.getBooleanProperty("me4se.signed", false) ? AccessController.doPrivileged(pa) : pa.run();
        }
        catch (PrivilegedActionException e) {
            throw new SecurityException(e);
        }
    }

    String escapeKey(String key) {
        if (this.proxy != null && key != null) {
            for (int i = 0; i < ESCAPE_HEADER.length; ++i) {
                if (!ESCAPE_HEADER[i].equalsIgnoreCase(key)) continue;
                return "x-me4se-" + key;
            }
        }
        return key;
    }

    public void open(String url, int mode, boolean timeouts) throws IOException {
        Log.log(4, "entering http open '" + url + "' mode: " + mode);
        this.url = new URL(url);
        this.proxy = url.startsWith("https") ? null : ApplicationManager.getProperty("me4se.httpproxy");
        Log.log(4, "using proxy: " + this.proxy);
        this.con = this.proxy == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)new URL(this.proxy).openConnection();
        this.con.setUseCaches(false);
        boolean doOutput = (mode & 2) != 0;
        this.con.setDoOutput(doOutput);
        this.con.setDoInput(true);
        this.con.setRequestProperty("User-Agent", ApplicationManager.getProperty("me4se.useragent", ApplicationManager.getProperty("microedition.platform", "MobileRunner-J2ME")));
        if (this.proxy != null) {
            this.con.setRequestProperty("me4se-target-url", url);
        }
        Log.log(4, "leaving: http open");
    }

    public long getDate() throws IOException {
        return this.con.getDate();
    }

    public String getEncoding() {
        return this.con.getContentEncoding();
    }

    public long getExpiration() throws IOException {
        return this.con.getExpiration();
    }

    public String getFile() {
        return this.url.getFile();
    }

    public String getHeaderField(String key) throws IOException {
        this.getResponseCode();
        return this.con.getHeaderField(this.escapeKey(key));
    }

    public String getHeaderField(int index) throws IOException {
        this.getResponseCode();
        return this.con.getHeaderField(index);
    }

    public int getHeaderFieldInt(String key, int def) throws IOException {
        this.getResponseCode();
        return this.con.getHeaderFieldInt(this.escapeKey(key), def);
    }

    public String getHeaderFieldKey(int index) throws IOException {
        this.getResponseCode();
        String key = this.con.getHeaderFieldKey(index);
        if (index == 0 && key == null && this.con.getHeaderField(0) != null) {
            return "x-status-line";
        }
        return key != null && key.toLowerCase().startsWith("x-me4se-") ? key.substring(8) : key;
    }

    public long getHeaderFieldDate(String key, long def) throws IOException {
        this.getResponseCode();
        return this.con.getHeaderFieldDate(this.escapeKey(key), def);
    }

    public String getHost() {
        return this.url.getHost();
    }

    public long getLength() {
        return this.con.getContentLength();
    }

    public long getLastModified() throws IOException {
        return this.con.getLastModified();
    }

    public int getPort() {
        return this.url.getPort();
    }

    public String getProtocol() {
        return this.url.getProtocol();
    }

    public String getQuery() {
        String s = this.url.toString();
        int cut = s.indexOf(63);
        return cut == -1 ? null : s.substring(cut + 1);
    }

    public String getRef() {
        return this.url.getRef();
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode == -1) {
            Log.log(4, "entering http getResponseCode");
            try {
                this.responseCode = (Integer)this.doPrivileged(2);
            }
            catch (FileNotFoundException fnfex) {
                this.responseCode = 404;
            }
            catch (IOException ioex) {
                if (ioex.getMessage().startsWith("file not found")) {
                    this.responseCode = 404;
                }
                System.out.println("IOException: " + ioex);
                throw ioex;
            }
            Log.log(4, "leaving http getResponseCode: " + this.responseCode);
        }
        return this.responseCode;
    }

    public String getRequestProperty(String name) {
        return this.con.getRequestProperty(this.escapeKey(name));
    }

    public String getType() {
        return this.con.getContentType();
    }

    public String getURL() {
        return this.url.toString();
    }

    public String getRequestMethod() {
        return this.con.getRequestMethod();
    }

    public String getResponseMessage() throws IOException {
        this.getResponseCode();
        return this.con.getResponseMessage();
    }

    public void setRequestMethod(String method) throws IOException {
        this.con.setRequestMethod(method);
    }

    public void setRequestProperty(String key, String value) throws IOException {
        key = this.escapeKey(key);
        String oldVal = this.con.getRequestProperty(key);
        this.con.setRequestProperty(key, value);
    }

    public InputStream openInputStream() throws IOException {
        return (InputStream)this.doPrivileged(3);
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        return (OutputStream)this.doPrivileged(1);
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() {
        this.con.disconnect();
    }

    class Privileged
    implements PrivilegedExceptionAction {
        int action;

        Privileged(int action) {
            this.action = action;
        }

        public Object run() throws IOException {
            switch (this.action) {
                case 1: {
                    return HttpConnectionImpl.this.con.getOutputStream();
                }
                case 3: {
                    if (HttpConnectionImpl.this.con.getResponseCode() >= 300) {
                        return HttpConnectionImpl.this.con.getErrorStream();
                    }
                    return HttpConnectionImpl.this.con.getInputStream();
                }
                case 2: {
                    return new Integer(HttpConnectionImpl.this.con.getResponseCode());
                }
            }
            throw new RuntimeException("unknown privileged action code: " + this.action);
        }
    }
}

