/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import net.yura.lobby.client.AndroidLobbyClient;
import net.yura.lobby.client.Connection;
import net.yura.lobby.client.LobbyClient;
import net.yura.lobby.client.ProtoAccess;
import net.yura.lobby.client.TcpClient;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.lobby.model.Message;
import net.yura.lobby.model.Player;
import net.yura.lobby.util.ByteBufferInputStream;
import net.yura.mobile.util.StringUtil;

public class LobbyCom
implements Connection,
ProtoAccess.ObjectProvider {
    protected static final Logger logger = Logger.getLogger(LobbyCom.class.getName());
    private static final int PROTOCOL_VERSION = 1;
    private LobbyClient myclient;
    private AndroidLobbyClient androidClient;
    private String username;
    private String password;
    private RSAPublicKey pubKey;
    private Cipher encrypt;
    private Map gameTypeMap;
    private String tempRegName;
    private String tempRegPass;
    private ProtoAccess access = new ProtoAccess(this);
    TcpClient client;
    private final String uuid;
    private final String appName;
    private final String appVersion;
    final List sendQueue = new Vector();
    Thread writeThread;
    private int wait;

    public LobbyCom(String uuid, String appName, String appVersion) {
        this.uuid = uuid;
        this.appName = appName;
        this.appVersion = appVersion;
        try {
            this.encrypt = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.gameTypeMap = new HashMap();
    }

    void connected() {
        HashMap<String, Object> hello = new HashMap<String, Object>();
        hello.put("version", new Integer(1));
        hello.put("uuid", this.uuid);
        hello.put("appName", this.appName);
        hello.put("appVersion", this.appVersion);
        hello.put("locale", Locale.getDefault().toString());
        this.send("REQUEST_HELLO", hello);
    }

    void disconnected() {
        this.gameTypeMap.clear();
        this.myclient.disconnected();
    }

    public Object getObjectId(Object object) {
        if (object instanceof GameType) {
            return new Integer(((GameType)object).getId());
        }
        throw new IllegalArgumentException("unknown object: " + object);
    }

    public Object getObjetById(Object id, Class clas) {
        if (clas == GameType.class) {
            Object obj = this.gameTypeMap.get(id);
            if (obj == null) {
                throw new IllegalArgumentException("can not find " + clas + " with id " + id);
            }
            return obj;
        }
        throw new IllegalArgumentException("unknown class: " + clas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(String command, Object param) {
        if (this.writeThread == null) {
            this.writeThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block8: while (true) {
                        try {
                            while (!Thread.interrupted()) {
                                Message message;
                                List list = LobbyCom.this.sendQueue;
                                synchronized (list) {
                                    while (LobbyCom.this.sendQueue.isEmpty()) {
                                        LobbyCom.this.sendQueue.wait();
                                    }
                                    message = (Message)LobbyCom.this.sendQueue.remove(0);
                                }
                                try {
                                    TcpClient cl = LobbyCom.this.client;
                                    if (cl == null) continue block8;
                                    int size = LobbyCom.this.access.computeAnonymousObjectSize(message);
                                    ByteArrayOutputStream bytes = new ByteArrayOutputStream(size + 4);
                                    new DataOutputStream(bytes).writeInt(size);
                                    LobbyCom.this.access.save(bytes, message);
                                    cl.send(ByteBuffer.wrap(bytes.toByteArray()));
                                    continue block8;
                                }
                                catch (InterruptedException in) {
                                    throw in;
                                }
                                catch (Exception ex) {
                                    Level level = ex instanceof IOException && "not connected".equals(ex.getMessage()) || ex instanceof SocketException && "Broken pipe".equals(ex.getMessage()) || ex instanceof SocketException && "sendto failed: EPIPE (Broken pipe)".equals(ex.getMessage()) ? Level.INFO : Level.WARNING;
                                    logger.log(level, "could not send " + message, ex);
                                }
                            }
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
            };
            this.writeThread.start();
        }
        logger.info("sending message " + command + " " + param);
        Message message = new Message();
        message.setCommand(command);
        message.setParam(param);
        if (this.wait != 0) {
            message.setWait(new Integer(this.wait));
        }
        List list = this.sendQueue;
        synchronized (list) {
            this.sendQueue.add(message);
            this.sendQueue.notify();
        }
    }

    public void setWait(int wait) {
        this.wait = wait;
    }

    private boolean canEncrypt() {
        return this.encrypt != null;
    }

    private byte[] encrypt(String name) {
        try {
            return this.encrypt.doFinal(name.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void serverPublicKey(byte[] message) {
        if (this.canEncrypt()) {
            RSAPublicKey previousKey = this.pubKey;
            try {
                this.pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(message));
                this.encrypt.init(1, this.pubKey);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.pubKey = previousKey;
                return;
            }
        }
    }

    void messageFromServer(Message msg) {
        String command = msg.getCommand();
        Object param = msg.getParam();
        logger.info("got message " + command + " " + param);
        try {
            if ("COMMAND_KEY".equals(command)) {
                Map map = (Map)param;
                String newHost = (String)map.get("newHost");
                if (newHost != null) {
                    int index = newHost.indexOf(58);
                    String server = index < 0 ? newHost : newHost.substring(0, index);
                    int port = index < 0 ? this.client.getPort() : Integer.parseInt(newHost.substring(index + 1));
                    this.disconnect();
                    this.connect(server, port);
                } else {
                    String guestName = (String)map.get("username");
                    Integer userType = (Integer)map.get("userType");
                    this.serverPublicKey((byte[])map.get("key"));
                    String u = this.username;
                    String p = this.password;
                    this.username = guestName;
                    this.myclient.setUsername(guestName, userType);
                    this.myclient.connecting("Handshake Complete");
                    this.myclient.connecting("You are now connected");
                    this.myclient.connected();
                    if (u != null && p != null) {
                        this.login(u, p);
                    }
                }
            } else if ("COMMAND_ALL_GAMETYPES".equals(command)) {
                List gametypes = (List)param;
                for (int c = 0; c < gametypes.size(); ++c) {
                    GameType gt = (GameType)gametypes.get(c);
                    this.gameTypeMap.put(new Integer(gt.getId()), gt);
                }
                this.myclient.addGameType(gametypes);
            } else if ("COMMAND_ADD_OR_UPDATE_GAME".equals(command)) {
                this.myclient.addOrUpdateGame((Game)param);
            } else if ("COMMAND_REMOVE_GAME".equals(command)) {
                Map map = (Map)param;
                this.myclient.removeGame((Integer)map.get("game_id"));
            } else if ("COMMAND_GAME_MESSAGE".equals(command)) {
                Map map = (Map)param;
                this.myclient.messageForGame((Integer)map.get("game_id"), map.get("message"));
            } else if ("COMMAND_LOGIN_OK".equals(command)) {
                Map map = (Map)param;
                Integer userType = (Integer)map.get("userType");
                String newName = (String)map.get("username");
                this.username = newName == null ? this.tempRegName : newName;
                this.password = this.tempRegPass;
                this.myclient.setUsername(this.username, userType);
            } else if ("COMMAND_LOGIN_ERROR".equals(command)) {
                this.myclient.error("login error: " + param);
            } else if ("COMMAND_SERVER_ERROR".equals(command)) {
                this.myclient.error("server error: " + param);
            } else if ("COMMAND_LOGOUT_OK".equals(command)) {
                String guestUser;
                Map map = (Map)param;
                this.username = guestUser = (String)map.get("username");
                this.password = null;
                this.myclient.setUsername(guestUser, 0);
            } else if ("COMMAND_RENAME_PLAYER".equals(command)) {
                Map map = (Map)param;
                this.myclient.renamePlayer((String)map.get("oldName"), (String)map.get("newName"), (Integer)map.get("userType"));
            } else if ("COMMAND_CHAT_MESSAGE".equals(command)) {
                Map map = (Map)param;
                String message = (String)map.get("message");
                String sender = (String)map.get("sender");
                Integer room_id = (Integer)map.get("room_id");
                if (room_id != null) {
                    this.myclient.incomingChat(room_id, sender, message);
                } else {
                    this.myclient.incomingChat(sender, message);
                }
            } else if ("COMMAND_PLAYER_ADDED".equals(command)) {
                Map map = (Map)param;
                Player player = (Player)map.get("player");
                Integer room_id = (Integer)map.get("room_id");
                if (room_id == null) {
                    this.myclient.addPlayer(player);
                } else {
                    this.myclient.addPlayer(room_id, player);
                }
            } else if ("COMMAND_PLAYER_REMOVE".equals(command)) {
                Map map = (Map)param;
                String playerName = (String)map.get("playerName");
                Integer room_id = (Integer)map.get("room_id");
                if (room_id == null) {
                    this.myclient.removePlayer(playerName);
                } else {
                    this.myclient.removePlayer(room_id, playerName);
                }
            } else if ("COMMAND_GAME_STARTED".equals(command)) {
                Map map = (Map)param;
                this.myclient.gameStarted((Integer)map.get("game_id"));
            } else if ("COMMAND_ANDROID_REGISTER_DONE".equals(command)) {
                this.androidClient.registerDone();
            } else if ("COMMAND_ANDROID_UNREGISTER_DONE".equals(command)) {
                this.androidClient.unregisterDone();
            } else {
                this.myclient.error("unknown command " + command + " " + param);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "error handling command " + msg, ex);
        }
    }

    public void addEventListener(LobbyClient lc) {
        this.myclient = lc;
    }

    public void addAndroidEventListener(AndroidLobbyClient lc) {
        this.androidClient = lc;
    }

    public void connect(String sev, int p) {
        this.client = new TcpClient(){
            int size = -1;

            protected void onRead(ByteBuffer buf) throws Exception {
                ByteBufferInputStream data = new ByteBufferInputStream(buf);
                while (true) {
                    if (this.size == -1 && data.available() >= 4) {
                        this.size = data.readInt();
                        continue;
                    }
                    if (this.size < 0 || data.available() < this.size) break;
                    Message message = (Message)LobbyCom.this.access.load(data, this.size);
                    this.size = -1;
                    LobbyCom.this.messageFromServer(message);
                }
            }

            protected void onConnected() throws Exception {
                LobbyCom.this.connected();
            }

            protected void onDisconnected() {
                LobbyCom.this.disconnected();
                this.size = -1;
            }
        };
        this.client.setAddress(sev, p);
        this.client.start();
    }

    public void disconnect() {
        this.client.stop();
        this.client = null;
        if (this.writeThread != null) {
            this.writeThread.interrupt();
            this.writeThread = null;
        }
    }

    public void setNick(String name) {
        if ((name = LobbyCom.checkUsername(name)).equals(this.username)) {
            return;
        }
        this.tempRegName = name;
        HashMap<String, Object> login = new HashMap<String, Object>();
        login.put("username", this.canEncrypt() ? (Object)this.encrypt(name) : name);
        this.send("REQUEST_SET_NICK", login);
    }

    public static String checkUsername(String name) {
        name = name.trim();
        while (name.indexOf("  ") >= 0) {
            name = StringUtil.replaceAll((String)name, (String)"  ", (String)" ");
        }
        return name;
    }

    public void login(String name, String pass) {
        if (!this.canEncrypt()) {
            this.myclient.error("Please update your java to version 1.5 or higher to be able to register and login \nhttp://java.sun.com/javase/downloads/");
        } else {
            this.tempRegName = name;
            this.tempRegPass = pass;
            HashMap<String, byte[]> login = new HashMap<String, byte[]>();
            login.put("username", this.encrypt(name));
            login.put("password", this.encrypt(pass));
            this.send("REQUEST_LOGIN", login);
        }
    }

    public void register(String username, String email, String password) {
        if (!this.canEncrypt()) {
            this.myclient.error("Please update your java to version 1.5 or higher to be able to register and login \nhttp://java.sun.com/javase/downloads/");
        } else {
            this.tempRegName = username;
            this.tempRegPass = password;
            HashMap<String, byte[]> register = new HashMap<String, byte[]>();
            register.put("username", this.encrypt(username));
            register.put("password", this.encrypt(password));
            register.put("email", this.encrypt(email));
            this.send("REQUEST_REGISTER", register);
        }
    }

    public void logout() {
        this.send("REQUEST_LOGOUT", null);
    }

    public void getGameTypes() {
        this.send("REQUEST_ALL_GAMETYPES", null);
    }

    public void getGames(GameType gameType) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("game_type_id", new Integer(gameType.getId()));
        this.send("REQUEST_GET_GAMES", map);
    }

    public void createNewGame(Game game) {
        this.send("REQUEST_CREATE_NEW_GAME", game);
    }

    public void joinGame(int game_id) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("game_id", new Integer(game_id));
        this.send("REQUEST_JOIN_GAME", map);
    }

    public void leaveGame(int game_id) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("game_id", new Integer(game_id));
        this.send("REQUEST_LEAVE_GAME", map);
    }

    public void playGame(int gameId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("game_id", new Integer(gameId));
        this.send("REQUEST_PLAY_GAME", map);
    }

    public void sendGameMessage(int game_id, Object message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("game_id", new Integer(game_id));
        map.put("message", message);
        this.send("REQUEST_GAME_MESSAGE", map);
    }

    public void closeGame(int game_id) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("game_id", new Integer(game_id));
        this.send("REQUEST_CLOSE_GAME", map);
    }

    public void sendChat(int roomid, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (roomid >= 0) {
            map.put("room_id", new Integer(roomid));
        }
        map.put("message", message);
        this.send("COMMAND_CHAT_MESSAGE", map);
    }

    public void androidRegister(String registrationId) {
        this.send("REQUEST_ANDROID_REGISTER", registrationId);
    }

    public void androidUnregister(String registrationId) {
        this.send("REQUEST_ANDROID_UNREGISTER", registrationId);
    }

    public void delGame(int gameId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("game_id", new Integer(gameId));
        this.send("REQUEST_DEL_GAME", map);
    }

    public void sendAdminCommand(String command, Map params) {
        this.send(command, params);
    }
}

