/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io.json;

import java.io.IOException;
import java.io.Writer;

public class JSONWriter {
    private static final int maxdepth = 20;
    private boolean comma = false;
    protected char mode = (char)105;
    private char[] stack = new char[20];
    private int top = 0;
    protected Writer writer;

    public JSONWriter(Writer w) {
        this.writer = w;
    }

    private JSONWriter append(String s) throws IOException {
        if (s == null) {
            throw new IOException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            if (this.comma && this.mode == 'a') {
                this.writer.write(44);
            }
            this.writer.write(s);
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new IOException("Value out of sequence.");
    }

    public JSONWriter array() throws IOException {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push('a');
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new IOException("Misplaced array.");
    }

    private JSONWriter end(char m, char c) throws IOException {
        if (this.mode != m) {
            throw new IOException(m == 'o' ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(m);
        this.writer.write(c);
        this.comma = true;
        return this;
    }

    public JSONWriter endArray() throws IOException {
        return this.end('a', ']');
    }

    public JSONWriter endObject() throws IOException {
        return this.end('k', '}');
    }

    public JSONWriter key(String s) throws IOException {
        if (s == null) {
            throw new IOException("Null key.");
        }
        if (this.mode == 'k') {
            if (this.comma) {
                this.writer.write(44);
            }
            this.writer.write(this.quote(s));
            this.writer.write(58);
            this.comma = false;
            this.mode = (char)111;
            return this;
        }
        throw new IOException("Misplaced key.");
    }

    public JSONWriter object() throws IOException {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push('k');
            this.comma = false;
            return this;
        }
        throw new IOException("Misplaced object.");
    }

    private void pop(char c) throws IOException {
        if (this.top <= 0 || this.stack[this.top - 1] != c) {
            throw new IOException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : this.stack[this.top - 1]);
    }

    private void push(char c) throws IOException {
        if (this.top >= 20) {
            throw new IOException("Nesting too deep.");
        }
        this.stack[this.top] = c;
        this.mode = c;
        ++this.top;
    }

    public JSONWriter value(boolean b) throws IOException {
        return this.append(b ? "true" : "false");
    }

    public JSONWriter value(double d) throws IOException {
        JSONWriter.testValidity(d);
        return this.append(Double.toString(d));
    }

    static void testValidity(double d) throws IOException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IOException("JSON does not allow non-finite numbers");
        }
    }

    public static String trimNumber(String s) {
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public JSONWriter value(long l) throws IOException {
        return this.append(Long.toString(l));
    }

    public JSONWriter nullValue() throws IOException {
        return this.append("null");
    }

    public JSONWriter value(char string) throws IOException {
        return this.append("'" + string + "'");
    }

    public JSONWriter value(String string) throws IOException {
        return this.append(this.quote(string));
    }

    private String quote(String string) throws IOException {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

