<!---
# SPDX-FileCopyrightText: © 2019-2022 Nadim Kobeissi <nadim@symbolic.software>
# SPDX-License-Identifier: CC-BY-SA-4.0
-->

# Contributing to Verifpal
If you wish to contribute to Verifpal, please first discuss the changes you are envisioning via the [Verifpal Mailing List](https://lists.symbolic.software/mailman/listinfo/verifpal).

Please note that as a Symbolic Software project, Verifpal operates under the Symbolic Software Community Guidelines, which we expect everyone to follow in their interactions with the project.

## Community Guidelines
Community guidelines exist to support the healthy and open discourse and collaboration that has always been a part of open source software development culture. They help create an environment where we can come together as a community. Working on cryptographic software comes with a tremendous responsibility. It’s critical that we honor that trust and uphold the integrity of our shared work as a community.

### Our Commitment
Productive collaboration requires an environment that recognizes the inherent worth of every person and group, that fosters critical thinking, understanding, and mutual respect, and that embraces diversity. In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to making participation in our project and our community one of mutual respect for one another's intrinsic dignity and sapience. We are also committed to providing an experience free of harassment and discrimination, respecting the dignity of every participant.

### Our Standards
Here are some key things to remember as you communicate:

* Be responsible. What you say and do matters. You’re responsible for your words and actions and you’ll be held accountable for them.
* Be helpful. Your voice is your contribution — make it productive.
* Be thoughtful. Your statements may be misinterpreted, and you should be thoughtful about making statements that could cause others to make incorrect assumptions.

Don’t troll, name call, or engage in ad hominem attacks—about anyone. This includes making statements that insult, demean, or humiliate (whether individually or by reference to groups) contributors, contributors to similar projects, extended members of the community, Symbolic Software employees, Symbolic Software's business partners, or others (including public figures), or that violate other standards of conduct or policies against harassment and bullying.

### Our Responsibilities
Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

### Scope
These Community Guidelines apply both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.

### Enforcement
Instances of unacceptable behavior may be reported by contacting the project team at verifpal@symbolic.software. All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

### Attribution
The Symbolic Software Community Guidelines are adapted from the [Google Community Guidelines](https://about.google/intl/en_us/community-guidelines/).

## Verifpal's Free and Open Source Policy

### Purpose
This document defines Symbolic Software's policy for the use of free and open source software in externally distributed products. This document provides a common framework for FOSS compliance for Symbolic Software's team and organisation, to establish intent to respect Free and Open Source Software and to contribute purposefully to open communities.

### Policy
Procedures, work instructions, training, and tool support must be established to implement compliance processes for each of the following use cases:

#### Inclusion of FOSS in Verifpal's deliverables
The compliance process shall include:

- Identification of all FOSS contained in Verifpal's deliverables;
- Review of license identification and, if applicable, compatibility analysis;
- FOSS license identification of obligations and the correspondent satisfaction of obligations.

#### Third party commercial software acquired for distribution in Verifpal

A developer that delivers software to Verifpal must disclose any FOSS contained in its deliverable, including:

- A list of all FOSS components, including their version numbers;
- All applicable licenses (not only the main license but each applicable license);
- Material for product documentation (including but not limited to license texts, copyright notices, acknowledgments and attributions);
- Source code for the FOSS (when applicable), including any modifications made by the developer;
- Dependency charts illustrating the dependencies, interfaces, and interactions between the FOSS components and any other product components.

#### Specific rules for server software
If server software includes FOSS licensed under the Affero General Public License (AGPL) or similar license, such use must be reviewed and approved according to the process defined for FOSS included in a Verifpal deliverable. If server software is distributed to a third party for hosting or distributed to an external party for any other purpose, use of any FOSS must be reviewed and approved.

#### Contributions to FOSS projects
Symbolic Software wishes to encourage contributions and community involvement in order to advance worthy technologies and projects. For the purposes of this policy, “contribution” means making software and/or related material (descriptions, documentation) for which Symbolic Software holds the copyright available to third parties, or to the general public, under an FOSS license, granting access, modification and/or distribution rights with regard to the software in source code form.

Plans for contributions (both collective and individual) should be reviewed and approved beforehand. Approval This policy should be effective immediately upon approval.