/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.statistic;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.jdiskreport.gui.node.FileNode;
import com.jgoodies.jdiskreport.gui.shared.format.JDFormats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public final class TopList {
    public static final Comparator<FileNode> LARGEST_COMPARATOR = new LargestComparator();
    public static final Comparator<FileNode> LEAST_RECENTLY_MODIFIED_COMPARATOR = new LastModifiedComparator(true);
    public static final Comparator<FileNode> MOST_RECENTLY_MODIFIED_COMPARATOR = new LastModifiedComparator(false);
    public static final Comparator<FileNode> LEAST_RECENTLY_ACCESSED_COMPARATOR = new LastAccessedComparator(true);
    public static final Comparator<FileNode> MOST_RECENTLY_ACCESSED_COMPARATOR = new LastAccessedComparator(false);
    public static final Comparator<FileNode> LEAST_RECENTLY_USED_COMPARATOR = new LastUsedComparator(true);
    public static final Comparator<FileNode> MOST_RECENTLY_USED_COMPARATOR = new LastUsedComparator(false);
    private static final ResourceMap RESOURCES = Application.getResourceMap(TopList.class);
    private final List<FileNode> files;
    private TableModel tableModel;

    TopList(SortedSet<FileNode> sortedSet) {
        ArrayList<FileNode> sortedList = new ArrayList<FileNode>(sortedSet);
        sortedList.trimToSize();
        this.files = Collections.unmodifiableList(sortedList);
    }

    List<FileNode> getFiles() {
        return this.files;
    }

    public FileNode first() {
        return this.files.get(0);
    }

    public FileNode get(int index) {
        return this.files.get(index);
    }

    public TableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new TopListTableModel(this.getFiles());
        }
        return this.tableModel;
    }

    public String toString() {
        TableModel model = this.getTableModel();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        for (int row = 0; row < model.getRowCount(); ++row) {
            builder.append("\n");
            builder.append(model.getValueAt(row, 0));
            builder.append(": name=");
            builder.append(model.getValueAt(row, 1));
            builder.append("; size=");
            builder.append(JDFormats.formatSize((Long)model.getValueAt(row, 2)));
            builder.append("; modified=");
            builder.append(JDFormats.formatDate((Long)model.getValueAt(row, 3)));
            builder.append("; file=");
            builder.append(model.getValueAt(row, 4));
        }
        return builder.toString();
    }

    private static final class LargestComparator
    implements Comparator<FileNode> {
        private LargestComparator() {
        }

        @Override
        public int compare(FileNode node1, FileNode node2) {
            long size2;
            long size1 = node1.getSize();
            if (size1 < (size2 = node2.getSize())) {
                return 1;
            }
            if (size1 > size2) {
                return -1;
            }
            return node1.getPath().compareTo(node2.getPath());
        }
    }

    private static final class LastAccessedComparator
    implements Comparator<FileNode> {
        private final int time1LessThanTime2;
        private final int time2LessThanTime1;

        LastAccessedComparator(boolean leastFirst) {
            this.time1LessThanTime2 = leastFirst ? -1 : 1;
            this.time2LessThanTime1 = leastFirst ? 1 : -1;
        }

        @Override
        public int compare(FileNode node1, FileNode node2) {
            long time2;
            long time1 = node1.getLastAccessMillis();
            if (time1 < (time2 = node2.getLastAccessMillis())) {
                return this.time1LessThanTime2;
            }
            if (time1 > time2) {
                return this.time2LessThanTime1;
            }
            return node1.getPath().compareTo(node2.getPath());
        }
    }

    private static final class LastModifiedComparator
    implements Comparator<FileNode> {
        private final int time1LessThanTime2;
        private final int time2LessThanTime1;

        LastModifiedComparator(boolean leastFirst) {
            this.time1LessThanTime2 = leastFirst ? -1 : 1;
            this.time2LessThanTime1 = leastFirst ? 1 : -1;
        }

        @Override
        public int compare(FileNode node1, FileNode node2) {
            long time2;
            long time1 = node1.getLastModifiedMillis();
            if (time1 < (time2 = node2.getLastModifiedMillis())) {
                return this.time1LessThanTime2;
            }
            if (time1 > time2) {
                return this.time2LessThanTime1;
            }
            return node1.getPath().compareTo(node2.getPath());
        }
    }

    private static final class LastUsedComparator
    implements Comparator<FileNode> {
        private final int time1LessThanTime2;
        private final int time2LessThanTime1;

        LastUsedComparator(boolean leastFirst) {
            this.time1LessThanTime2 = leastFirst ? -1 : 1;
            this.time2LessThanTime1 = leastFirst ? 1 : -1;
        }

        @Override
        public int compare(FileNode node1, FileNode node2) {
            long time2;
            long time1 = node1.getLastUsedMillis();
            if (time1 < (time2 = node2.getLastUsedMillis())) {
                return this.time1LessThanTime2;
            }
            if (time1 > time2) {
                return this.time2LessThanTime1;
            }
            return node1.getPath().compareTo(node2.getPath());
        }
    }

    static final class TopListTableModel
    implements TableModel {
        private static final String COLUMN_NAME_KEY_PREFIX = TopList.class.getSimpleName();
        private static final String[] COLUMN_NAME_KEY_SUFFIXES = new String[]{"no", "name", "size", "access", "modified", "path"};
        private static final Class<?>[] COLUMN_CLASSES = new Class[]{Integer.class, FileNode.class, Long.class, Long.class, Long.class, DirectoryNode.class};
        private final List<FileNode> files;

        TopListTableModel(List<FileNode> files) {
            this.files = files;
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAME_KEY_SUFFIXES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String key = COLUMN_NAME_KEY_PREFIX + ".columnName." + COLUMN_NAME_KEY_SUFFIXES[columnIndex];
            return RESOURCES.getString(key, new Object[0]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.files.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FileNode node = this.files.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rowIndex + 1;
                }
                case 1: {
                    return node;
                }
                case 2: {
                    return node.getSize();
                }
                case 3: {
                    return node.getLastAccessMillis();
                }
                case 4: {
                    long access = node.getLastAccessMillis();
                    long modified = node.getLastModifiedMillis();
                    return Math.abs(modified - access) < 60000L ? null : Long.valueOf(node.getLastModifiedMillis());
                }
                case 5: {
                    return node.getParent();
                }
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException("TopList table models are not editable.");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

