/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.domain;

import com.jgoodies.common.base.Strings;
import com.jgoodies.jdiskreport.domain.IFileFilter;
import com.jgoodies.jdiskreport.domain.ScanConfiguration;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Date;

public final class FileFilter
implements IFileFilter {
    private final PathMatcher exclusionsMatcher;
    private final PathMatcher inclusionsMatcher;
    private final FileTime minAccessTime;
    private final FileTime maxAccessTime;
    private final FileTime minModifiedTime;
    private final FileTime maxModifiedTime;

    public FileFilter(ScanConfiguration configuration) {
        this(configuration.getFileExclusions(), configuration.getFileInclusions(), configuration.getMinAccessDate(), configuration.getMaxAccessDate(), configuration.getMinModifiedDate(), configuration.getMaxModifiedDate());
    }

    private FileFilter(String exclusionsGlob, String inclusionsGlob, Date minAccessDate, Date maxAccessDate, Date minModifiedDate, Date maxModifiedDate) {
        this.exclusionsMatcher = Strings.isBlank(exclusionsGlob) ? null : FileSystems.getDefault().getPathMatcher("glob:" + exclusionsGlob);
        this.inclusionsMatcher = Strings.isBlank(inclusionsGlob) ? null : FileSystems.getDefault().getPathMatcher("glob:" + inclusionsGlob);
        this.minAccessTime = minAccessDate == null ? null : FileTime.fromMillis(minAccessDate.getTime());
        this.maxAccessTime = maxAccessDate == null ? null : FileTime.fromMillis(maxAccessDate.getTime());
        this.minModifiedTime = minModifiedDate == null ? null : FileTime.fromMillis(minModifiedDate.getTime());
        this.maxModifiedTime = maxModifiedDate == null ? null : FileTime.fromMillis(maxModifiedDate.getTime());
    }

    @Override
    public boolean accept(Path file, BasicFileAttributes attrs) {
        if (this.exclusionsMatcher != null && this.exclusionsMatcher.matches(file)) {
            return false;
        }
        if (this.inclusionsMatcher != null && !this.inclusionsMatcher.matches(file)) {
            return false;
        }
        if (this.minAccessTime != null && this.minAccessTime.compareTo(attrs.lastAccessTime()) >= 0) {
            return false;
        }
        if (this.maxAccessTime != null && this.maxAccessTime.compareTo(attrs.lastAccessTime()) <= 0) {
            return false;
        }
        if (this.minModifiedTime != null && this.minModifiedTime.compareTo(attrs.lastModifiedTime()) >= 0) {
            return false;
        }
        return this.maxModifiedTime == null || this.maxModifiedTime.compareTo(attrs.lastModifiedTime()) > 0;
    }
}

