/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles;

import com.jgoodies.fluent.tiles.EmptyTile;
import com.jgoodies.fluent.tiles.Tile;
import com.jgoodies.navigation.views.View;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public final class TileToViewRegistry {
    private static final List<TileConverter<?>> CONVERTERS = new CopyOnWriteArrayList();

    private TileToViewRegistry() {
    }

    public static <T extends Tile> void register(Class<T> clazz, Function<T, View> creator) {
        CONVERTERS.add(0, new TileConverter<T>(clazz, creator));
    }

    public static <T extends Tile> View createView(T tile) {
        if (tile instanceof EmptyTile) {
            return null;
        }
        Function<?, View> creator = TileToViewRegistry.lookupCreator(tile.getClass());
        if (creator == null) {
            throw new IllegalArgumentException("No creator found for tile class " + tile.getClass());
        }
        return creator.apply(tile);
    }

    private static <T extends Tile> Function<T, View> lookupCreator(Class<T> clazz) {
        TileConverter match = CONVERTERS.stream().filter(converter -> converter.tileClass.isAssignableFrom(clazz)).findFirst().orElse(null);
        return match == null ? null : match.tileCreator;
    }

    private static final class TileConverter<T extends Tile> {
        final Class<T> tileClass;
        final Function<T, View> tileCreator;

        TileConverter(Class<T> tileClass, Function<T, View> tileCreator) {
            this.tileClass = tileClass;
            this.tileCreator = tileCreator;
        }
    }
}

