/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.internal;

import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.check.StyleChecker;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.JSDLCoreStyleChecks;
import com.jgoodies.dialogs.core.MessageType;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;

public final class JSDLCoreStyleChecker {
    private static final String ELLIPSIS_STRING = "...";
    private static JSDLCoreStyleChecker instance;
    private static final List<String> WESTERN_LANGUAGES;
    private static final Map<Locale, Map<String, CommandValue>> COMMAND_VALUE_NAMES;

    protected JSDLCoreStyleChecker() {
    }

    public static JSDLCoreStyleChecker getInstance() {
        if (instance == null) {
            instance = new JSDLCoreStyleChecker();
        }
        return instance;
    }

    public void checkWindowParentNotNull(Component parent) {
        StyleChecker.check(JSDLCoreStyleChecks.WINDOW_PARENT_NOT_NULL, parent != null);
    }

    public void checkWindowTitle(String title) {
        if (Strings.isBlank(title)) {
            StyleChecker.check(JSDLCoreStyleChecks.WINDOW_TITLE_NOT_BLANK, false, "Window title=\"%s\"", title);
            return;
        }
        StyleChecker.check(JSDLCoreStyleChecks.WINDOW_TITLE_TRIMMED, () -> JSDLCoreStyleChecker.isTrimmed(title), "Window title=\"%s\"", title);
        StyleChecker.check(JSDLCoreStyleChecks.WINDOW_TITLE_DOES_NOT_END_WITH_PUNCTUATION_MARK, () -> !JSDLCoreStyleChecker.endsWithPunctuationMark(title), "Window title=\"%s\"", title);
    }

    public void checkWizardPageMainInstructionNotBlank(String mainInstruction) {
        StyleChecker.check(JSDLCoreStyleChecks.WIZARD_PAGE_MAIN_INSTRUCTION_NOT_BLANK, () -> Strings.isNotBlank(mainInstruction));
    }

    public void checkMainInstruction(String mainInstruction, MessageType messageType) {
        this.checkMainInstructionNullOrNotBlank(mainInstruction);
        if (Strings.isNotBlank(mainInstruction)) {
            this.checkMainInstructionIsTrimmed(mainInstruction);
            this.checkMainInstructionMatchesMessageType(mainInstruction, messageType);
            this.checkMainInstructionEllipsisSuffix(mainInstruction);
            this.checkMainInstructionAvoidsEndingPunctuation(mainInstruction);
            this.checkMainInstructionIsSentence(mainInstruction);
            this.checkMainInstructionAvoidsPleaseAndWouldYouLike(mainInstruction);
        }
    }

    private void checkMainInstructionIsTrimmed(String mainInstruction) {
        StyleChecker.check(JSDLCoreStyleChecks.MAIN_INSTRUCTION_TRIMMED, () -> JSDLCoreStyleChecker.isTrimmed(mainInstruction), "Main instruction=\"%s\"", mainInstruction);
    }

    public void checkLabelingMainInstructionHasMnemonic(String mainInstruction) {
        StyleChecker.check(JSDLCoreStyleChecks.LABELING_MAIN_INSTRUCTION_HAS_MNEMONIC, () -> Strings.isBlank(mainInstruction) || MnemonicUtils.containsMarker(mainInstruction), "Main instruction=\"%s\"", mainInstruction);
    }

    private void checkMainInstructionNullOrNotBlank(String mainInstruction) {
        StyleChecker.check(JSDLCoreStyleChecks.MAIN_INSTRUCTION_NULL_OR_NOT_BLANK, () -> mainInstruction == null || Strings.isNotBlank(mainInstruction));
    }

    private void checkMainInstructionMatchesMessageType(String mainInstruction, MessageType messageType) {
        StyleChecker.check(JSDLCoreStyleChecks.MAIN_INSTRUCTION_IS_QUESTION_IN_QUESTION_MESSAGES, () -> messageType != MessageType.QUESTION && messageType != MessageType.QUESTION_CRITICAL || JSDLCoreStyleChecker.isQuestion(mainInstruction), "Main instruction=\"%s\"\nMessage type=%s", new Object[]{mainInstruction, messageType});
    }

    private void checkMainInstructionEllipsisSuffix(String mainInstruction) {
        StyleChecker.check(JSDLCoreStyleChecks.MAIN_INSTRUCTION_ELLIPSIS_SUFFIX_IS_CHARACTER_NOT_THREE_DOTS, () -> !mainInstruction.endsWith(ELLIPSIS_STRING), "Main instruction=\"%s\"", mainInstruction);
    }

    private void checkMainInstructionAvoidsEndingPunctuation(String mainInstruction) {
        StyleChecker.check(JSDLCoreStyleChecks.MAIN_INSTRUCTION_DOES_NOT_END_WITH_PERIOD, () -> !JSDLCoreStyleChecker.endsWithPeriod(mainInstruction), "Main instruction=\"%s\"", mainInstruction);
    }

    private void checkMainInstructionIsSentence(String mainInstruction) {
        StyleChecker.check(JSDLCoreStyleChecks.MAIN_INSTRUCTION_IS_SENTENCE, () -> JSDLCoreStyleChecker.isSentence(mainInstruction), "Main instruction=\"%s\"", mainInstruction);
    }

    public void checkMainInstructionDoesNotRepeatWindowTitle(String mainInstruction, String windowTitle) {
        StyleChecker.check(JSDLCoreStyleChecks.MAIN_INSTRUCTION_MUST_NOT_REPEAT_WINDOW_TITLE, () -> mainInstruction == null || !mainInstruction.equalsIgnoreCase(windowTitle), "Main instruction=\"%s\"", mainInstruction);
    }

    public void checkMainInstructionAvoidsPleaseAndWouldYouLike(String mainInstruction) {
        StyleChecker.check(JSDLCoreStyleChecks.MAIN_INSTRUCTION_DOES_NOT_START_WITH_PLEASE_OR_WOULD_YOU_LIKE, () -> JSDLCoreStyleChecker.doesNotStartWithPleaseAndWouldYouLike(mainInstruction), "Main instruction=\"%s\"", mainInstruction);
    }

    public void checkSupplementalInstructionIsTrimmed(String supplementalInstruction) {
        StyleChecker.check(JSDLCoreStyleChecks.SUPPLEMENTAL_INSTRUCTION_TRIMMED, () -> JSDLCoreStyleChecker.isTrimmed(supplementalInstruction), "Supplemental instruction=\"%s\"", supplementalInstruction);
    }

    public void checkMetaOptionEnclosedInParentheses(String metaOptionText) {
        StyleChecker.check(JSDLCoreStyleChecks.META_OPTION_ENCLOSED_IN_PARENTHESES, () -> JSDLCoreStyleChecker.isEnclosedInParentheses(metaOptionText), "Meta-option text=\"%s\"", metaOptionText);
    }

    public void checkCommitButtonsNotEmpty(JButton ... buttons) {
        StyleChecker.check(JSDLCoreStyleChecks.COMMIT_BUTTONS_NOT_EMPTY, buttons != null && buttons.length > 0);
    }

    public void checkErrorsAreNeverOK(MessageType messageType, JButton ... buttons) {
        StyleChecker.check(JSDLCoreStyleChecks.ERRORS_ARE_NEVER_OK, () -> buttons == null || buttons.length != 1 || messageType != MessageType.ERROR || !buttons[0].getText().equalsIgnoreCase(CommandValue.OK.getText()));
    }

    public void checkButtonTextsNotBlank(JButton ... buttons) {
        if (StyleChecker.isIgnored(JSDLCoreStyleChecks.BUTTON_TEXTS_NOT_BLANK) || buttons == null) {
            return;
        }
        for (JButton button : buttons) {
            StyleChecker.check(JSDLCoreStyleChecks.BUTTON_TEXTS_NOT_BLANK, Strings.isNotBlank(button.getText()));
        }
    }

    public void checkButtonTextsAreUnique(Set<String> texts, JButton ... buttons) {
        if (StyleChecker.isIgnored(JSDLCoreStyleChecks.BUTTON_TEXTS_UNIQUE) || buttons == null) {
            return;
        }
        for (JButton button : buttons) {
            String text = button.getText();
            String lowerCaseText = text.toLowerCase();
            if (texts.add(lowerCaseText)) continue;
            StyleChecker.report(JSDLCoreStyleChecks.BUTTON_TEXTS_UNIQUE, "Duplicate command text: '%s'", text);
        }
    }

    public void checkButtonTextSpelling(JButton ... buttons) {
        if (StyleChecker.isIgnored(JSDLCoreStyleChecks.BUTTON_TEXT_SPELLING) || buttons == null) {
            return;
        }
        for (JButton button : buttons) {
            boolean moreThanOneWord;
            String text = button.getText();
            CommandValue commandValue = JSDLCoreStyleChecker.getCommandValueFor(text);
            if (commandValue == null) continue;
            int spaceIndex = text.indexOf(" ");
            boolean bl = moreThanOneWord = spaceIndex != -1;
            if (moreThanOneWord) {
                return;
            }
            if (text.equals(commandValue.getText())) continue;
            StyleChecker.report(JSDLCoreStyleChecks.BUTTON_TEXT_SPELLING, "The button text \"%s\" should be \"%s\".", text, commandValue.getText());
        }
    }

    public void checkAdditionalButtonIsNotCommit(JButton ... additionalCommandButtons) {
        if (StyleChecker.isIgnored(JSDLCoreStyleChecks.ADDITIONAL_BUTTON_IS_NOT_COMMIT) || additionalCommandButtons == null) {
            return;
        }
        for (JButton button : additionalCommandButtons) {
            String text = button.getText();
            CommandValue commandValue = JSDLCoreStyleChecker.getCommandValueFor(text);
            if (commandValue == null || !commandValue.isCommitOnly()) continue;
            StyleChecker.report(JSDLCoreStyleChecks.ADDITIONAL_BUTTON_IS_NOT_COMMIT, "The additional button \"%s\" must not have a commit value.", text);
        }
    }

    public void checkCommitButtonOrder(JButton ... commitButtons) {
        if (StyleChecker.isIgnored(JSDLCoreStyleChecks.COMMIT_BUTTON_ORDER) || commitButtons == null) {
            return;
        }
        int lastGroup = -1;
        String lastText = "";
        for (JButton button : commitButtons) {
            int nextGroup;
            String text = button.getText();
            CommandValue commandValue = JSDLCoreStyleChecker.getCommandValueFor(text);
            int n = nextGroup = commandValue != null ? commandValue.getGroup() : -1;
            if (nextGroup == -1) continue;
            if (lastGroup != -1 && lastGroup >= nextGroup) {
                StyleChecker.report(JSDLCoreStyleChecks.COMMIT_BUTTON_ORDER, "Button \"%s\" should be before \"%s\".", text, lastText);
            }
            lastGroup = nextGroup;
            lastText = text;
        }
    }

    public void checkTabTitle(String title) {
        StyleChecker.check(JSDLCoreStyleChecks.TAB_TITLE_TRIMMED, () -> JSDLCoreStyleChecker.isTrimmed(title), "Tab title=\"%s\"", title);
    }

    private static CommandValue getCommandValueFor(String buttonText) {
        String lowerCaseName = buttonText.toLowerCase();
        Locale locale = Locale.getDefault();
        Map<String, CommandValue> nameToValueMap = COMMAND_VALUE_NAMES.get(locale);
        if (nameToValueMap == null) {
            nameToValueMap = JSDLCoreStyleChecker.createNameToValueMap();
            COMMAND_VALUE_NAMES.put(locale, nameToValueMap);
        }
        return nameToValueMap.get(lowerCaseName);
    }

    private static Map<String, CommandValue> createNameToValueMap() {
        HashMap<String, CommandValue> nameToValueMap = new HashMap<String, CommandValue>();
        for (CommandValue value : CommandValue.values()) {
            String lowerCaseName = value.getText().toLowerCase();
            nameToValueMap.put(lowerCaseName, value);
        }
        return nameToValueMap;
    }

    private static boolean isEnclosedInParentheses(String str) {
        return str != null && str.startsWith("(") && str.endsWith(")");
    }

    private static boolean isTrimmed(String str) {
        return str == null || str.trim().length() == str.length();
    }

    private static boolean isQuestion(String str) {
        if (JSDLCoreStyleChecker.isNonWesternLanguage()) {
            return true;
        }
        return JSDLCoreStyleChecker.endsWithQuestionMark(str);
    }

    private static boolean isSentence(String str) {
        if (JSDLCoreStyleChecker.isNonWesternLanguage()) {
            return true;
        }
        String trimmedString = str.trim();
        if (trimmedString.endsWith("\u2026")) {
            return true;
        }
        boolean hasMinimumLength = trimmedString.length() > 3;
        boolean isMoreThanASingleWord = trimmedString.contains(" ");
        return hasMinimumLength && isMoreThanASingleWord;
    }

    private static boolean doesNotStartWithPleaseAndWouldYouLike(String str) {
        String language = Locale.getDefault().getLanguage();
        if (Locale.ENGLISH.getLanguage().equals(language)) {
            return !str.startsWith("Please") && !str.startsWith("Would you like");
        }
        if (Locale.GERMAN.getLanguage().equals(language)) {
            return !str.startsWith("Bitte") && !str.startsWith("M\u00f6chten Sie");
        }
        return true;
    }

    private static boolean isWesternLanguage() {
        return WESTERN_LANGUAGES.contains(Locale.getDefault().getLanguage());
    }

    private static boolean isNonWesternLanguage() {
        return !JSDLCoreStyleChecker.isWesternLanguage();
    }

    private static boolean endsWithPeriod(String str) {
        if (JSDLCoreStyleChecker.isNonWesternLanguage()) {
            return false;
        }
        return str.endsWith(".");
    }

    private static boolean endsWithPunctuationMark(String str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return false;
        }
        char lastChar = str.charAt(length - 1);
        return lastChar == '.' || lastChar == '!' || lastChar == '?';
    }

    private static boolean endsWithQuestionMark(String str) {
        return str.endsWith("?");
    }

    static {
        WESTERN_LANGUAGES = Collections.unmodifiableList(Arrays.asList(Locale.ENGLISH.getLanguage(), Locale.FRENCH.getLanguage(), Locale.GERMAN.getLanguage(), Locale.ITALIAN.getLanguage()));
        COMMAND_VALUE_NAMES = new HashMap<Locale, Map<String, CommandValue>>();
    }
}

