/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components;

import com.jgoodies.common.base.Strings;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.components.internal.ComponentSupport;
import com.jgoodies.components.internal.JGTextComponent;
import com.jgoodies.components.internal.PromptSupport;
import com.jgoodies.components.internal.TextFieldSupport;
import com.jgoodies.components.util.ComponentUtils;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.Document;

public class JGTextArea
extends JTextArea
implements JGTextComponent {
    private final JTextArea promptArea = new JTextArea();
    private static final String KEY_EVENT_HANDLER = "JGTextArea.eventHandler";
    private static final EventHandler EVENT_HANDLER = new EventHandler();

    public JGTextArea() {
        this.updateUI();
    }

    public JGTextArea(String text) {
        super(text);
        this.updateUI();
    }

    public JGTextArea(int rows, int columns) {
        super(rows, columns);
        this.updateUI();
    }

    public JGTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.updateUI();
    }

    public JGTextArea(Document doc) {
        super(doc);
        this.updateUI();
    }

    public JGTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.updateUI();
    }

    @Override
    public final String getPrompt() {
        return PromptSupport.getPrompt(this);
    }

    @Override
    public final void setPrompt(String prompt) {
        this.setPrompt(prompt, null);
    }

    @Override
    public final void setPrompt(String str, Object ... args) {
        String formatted = Strings.get(str, args);
        PromptSupport.setPrompt(this, formatted);
        this.promptArea.setText(formatted);
    }

    @Override
    public final int getPromptStyle() {
        return PromptSupport.getPromptStyle(this);
    }

    @Override
    public final void setPromptStyle(int style) {
        PromptSupport.setPromptStyle(this, style);
        this.promptArea.setFont(this.getFont().deriveFont(style));
    }

    @Override
    public final boolean isPromptVisibleWhenFocused() {
        return PromptSupport.isPromptVisibleWhenFocused(this);
    }

    @Override
    public final void setPromptVisibleWhenFocused(boolean newValue) {
        PromptSupport.setPromptVisibleWhenFocused(this, newValue);
    }

    @Override
    public final boolean isJGFocusTraversable() {
        return FocusTraversalUtils.isFocusTraversable(this);
    }

    @Override
    public final void setJGFocusTraversable(Boolean value) {
        FocusTraversalUtils.setFocusTraversable(this, value);
    }

    @Override
    public final Boolean getSelectOnFocusGainEnabled() {
        return TextFieldSupport.getSelectOnFocusGainEnabled(this);
    }

    @Override
    public final void setSelectOnFocusGainEnabled(Boolean b) {
        TextFieldSupport.setSelectOnFocusGainEnabled(this, b);
    }

    @Override
    public final void setKeyboardAction(Action keyboardAction) {
        ComponentUtils.registerKeyboardAction(this, keyboardAction);
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        this.promptArea.setBounds(x, y, w, h);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation orientation) {
        super.setComponentOrientation(orientation);
        this.promptArea.setComponentOrientation(orientation);
    }

    @Override
    public void setTabSize(int size) {
        super.setTabSize(size);
        this.promptArea.setTabSize(size);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return TextFieldSupport.getToolTipText(this, e, super.getToolTipText());
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (PromptSupport.isPromptPainted(this)) {
            this.promptArea.paint(g);
        } else {
            Rectangle clip = g.getClip().getBounds();
            g.setColor(this.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        super.paintComponent(g);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.promptArea != null) {
            ComponentSupport.configureTransparentBackground(this);
            this.promptArea.updateUI();
            this.promptArea.setForeground(UIManager.getColor("textInactiveText"));
            this.promptArea.setFont(this.getFont().deriveFont(this.getPromptStyle()));
            this.ensureEventHandlerInstalled();
        }
    }

    private void ensureEventHandlerInstalled() {
        boolean installed;
        boolean bl = installed = this.getClientProperty(KEY_EVENT_HANDLER) != null;
        if (!installed) {
            this.addKeyListener(EVENT_HANDLER);
            this.putClientProperty(KEY_EVENT_HANDLER, EVENT_HANDLER);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJGTextArea();
        }
        return this.accessibleContext;
    }

    private final class AccessibleJGTextArea
    extends JTextArea.AccessibleJTextArea {
        private AccessibleJGTextArea() {
            super(JGTextArea.this);
        }

        @Override
        public String getAccessibleName() {
            String name = super.getAccessibleName();
            if (name != null) {
                return name;
            }
            return JGTextArea.this.getPrompt();
        }

        @Override
        public String getAccessibleDescription() {
            String description = super.getAccessibleDescription();
            if (description != null) {
                return description;
            }
            String name = this.getAccessibleName();
            return Objects.equals(name, JGTextArea.this.getPrompt()) ? null : JGTextArea.this.getPrompt();
        }
    }

    private static final class EventHandler
    implements KeyListener {
        private EventHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            EventHandler.repaint(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            EventHandler.repaint(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            EventHandler.repaint(e);
        }

        private static void repaint(EventObject evt) {
            ((Component)evt.getSource()).repaint();
        }
    }
}

