/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.action;

import com.jgoodies.application.Actions;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.application.internal.Exceptions;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.action.ConsumerAction;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.Action;

public final class I18nActionBuilder {
    private Consumer<ActionEvent> handler;
    private String id;
    private ResourceMap resources;
    private boolean enabled = true;

    public I18nActionBuilder handler(Consumer<ActionEvent> handler) {
        this.handler = Preconditions.checkNotNull(handler, "The %s must not be null.", "action handler");
        return this;
    }

    public I18nActionBuilder handler(Runnable handler) {
        return this.handler((ActionEvent evt) -> handler.run());
    }

    public I18nActionBuilder id(String id) {
        this.id = Preconditions.checkNotBlank(id, "The %s must not be null, empty, or whitespace.", "action resource id");
        return this;
    }

    public I18nActionBuilder resources(ResourceMap resources) {
        this.resources = Preconditions.checkNotNull(resources, "The %s must not be null.", "action resource map");
        return this;
    }

    public I18nActionBuilder enabled(boolean b) {
        this.enabled = b;
        return this;
    }

    public I18nActionBuilder disabled() {
        this.enabled = false;
        return this;
    }

    public Action build() {
        if (this.handler == null) {
            throw new Exceptions.ActionConfigurationException("You must provide an action handler (call #handler).");
        }
        if (this.resources == null) {
            throw new Exceptions.ActionConfigurationException("You must provide the resource map used to look up resource from (call #resources).");
        }
        if (this.id == null) {
            throw new Exceptions.ActionConfigurationException("You must provide the resource id used to look up resource from (call #id).");
        }
        ConsumerAction action = new ConsumerAction(this.handler);
        Actions.configure(action, this.resources, this.id);
        action.setEnabled(this.enabled);
        return action;
    }
}

