/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics.icon;

import com.jgoodies.app.gui.basics.icon.windows.WindowsIcon;
import com.jgoodies.application.ResourceConverter;
import com.jgoodies.application.ResourceConverters;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.application.internal.Exceptions;
import java.awt.Color;
import java.util.Locale;
import javax.swing.Icon;

public final class SymbolIconResourceConverter
implements ResourceConverter {
    private final ResourceConverter delegate = ResourceConverters.forType(Icon.class);

    private SymbolIconResourceConverter() {
    }

    public static void register() {
        ResourceConverters.register(new SymbolIconResourceConverter());
    }

    @Override
    public boolean supportsType(Class<?> type) {
        return type == Icon.class;
    }

    @Override
    public Object convert(ResourceMap r, String key, String value, Class<?> returnType) {
        Color color;
        String[] split = value.split(":");
        if (split.length == 1) {
            return this.delegate.convert(r, key, value, returnType);
        }
        String family = split[0].toLowerCase(Locale.ENGLISH);
        String member = split[1].toUpperCase(Locale.ENGLISH).replace('-', '_');
        int size = split.length < 3 ? -1 : SymbolIconResourceConverter.toInt(split[2], r, key, value);
        Color color2 = color = split.length < 4 ? null : (Color)this.delegate.convert(r, key, split[3], Color.class);
        if (family.equals("windows")) {
            WindowsIcon iconEnum = WindowsIcon.valueOf(member);
            return size == -1 ? iconEnum.toIcon() : iconEnum.toIcon(size, color);
        }
        throw new Exceptions.ResourceConversionException("Unknown symbol icon family " + family, r, key, value);
    }

    private static int toInt(String sizeStr, ResourceMap r, String key, String value) {
        try {
            return Integer.parseInt(sizeStr);
        }
        catch (NumberFormatException ex) {
            throw new Exceptions.ResourceConversionException("Wrong number format in symbol icon description.", r, key, value);
        }
    }
}

