/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.application.windows;

import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.internal.CommonFormats;
import com.jgoodies.common.swing.Listeners;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public abstract class AbstractWindowModel {
    private final JFrame window;

    protected AbstractWindowModel(JFrame window) {
        this.window = window;
    }

    protected abstract void initContent();

    protected abstract void initState();

    protected abstract void storeState(Preferences var1);

    protected abstract void restoreState(Preferences var1);

    protected String concatTitleItems(List<? extends Object> items) {
        return CommonFormats.joinWithDots(items);
    }

    public final void setTitle(String title, Object ... args) {
        this.window.setTitle(Strings.get(title, args));
    }

    public final void setTitleItems(Object ... items) {
        this.setTitleItems(Arrays.asList(items));
    }

    public final void setTitleItems(List<? extends Object> items) {
        this.setTitle(this.concatTitleItems(items), new Object[0]);
    }

    public final JFrame getWindow() {
        return this.window;
    }

    public final void addWindowClosingListener(Consumer<WindowEvent> listener) {
        this.window.addWindowListener(Listeners.windowClosing(listener));
    }

    public final void show() {
        this.window.setVisible(true);
    }

    public final void showRelativeTo(Component parent) {
        this.window.setLocationRelativeTo(parent);
        this.window.setVisible(true);
    }

    public final void close() {
        this.window.setVisible(false);
        this.window.dispose();
    }

    public final void setName(String name) {
        this.window.setName(name);
    }

    public final boolean isWindow(Window window) {
        return this.window == window;
    }

    protected final void setContentPane(Container contentPane) {
        this.window.setContentPane(contentPane);
    }

    protected final void revalidate() {
        this.window.revalidate();
    }

    protected final void repaint() {
        this.window.repaint();
    }
}

