/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNullLiteral;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.properties.BooleanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonThreadSafeSingleton
extends AbstractRule {
    private Map<String, ASTFieldDeclaration> fieldDecls = new HashMap<String, ASTFieldDeclaration>();
    private boolean checkNonStaticMethods = true;
    private boolean checkNonStaticFields = true;
    private static final PropertyDescriptor checkNonStaticMethodsDescriptor = new BooleanProperty("checkNonStaticMethods", "Check for non-static methods.", true, 1.0f);
    private static final PropertyDescriptor checkNonStaticFieldsDescriptor = new BooleanProperty("checkNonStaticFields", "Check for non-static fields.", true, 2.0f);
    private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = NonThreadSafeSingleton.asFixedMap(new PropertyDescriptor[]{checkNonStaticMethodsDescriptor, checkNonStaticFieldsDescriptor});

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.fieldDecls.clear();
        this.checkNonStaticMethods = this.getBooleanProperty(checkNonStaticMethodsDescriptor);
        this.checkNonStaticFields = this.getBooleanProperty(checkNonStaticFieldsDescriptor);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (this.checkNonStaticFields || node.isStatic()) {
            this.fieldDecls.put(node.getVariableName(), node);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (this.checkNonStaticMethods && !node.isStatic() || node.isSynchronized()) {
            return super.visit(node, data);
        }
        List<ASTIfStatement> ifStatements = node.findChildrenOfType(ASTIfStatement.class);
        for (ASTIfStatement ifStatement : ifStatements) {
            ASTName Name;
            ASTNullLiteral NullLiteral;
            if (ifStatement.getFirstParentOfType(ASTSynchronizedStatement.class) != null || (NullLiteral = ifStatement.getFirstChildOfType(ASTNullLiteral.class)) == null || (Name = ifStatement.getFirstChildOfType(ASTName.class)) == null || !this.fieldDecls.containsKey(Name.getImage())) continue;
            List<ASTAssignmentOperator> assigmnents = ifStatement.findChildrenOfType(ASTAssignmentOperator.class);
            boolean violation = false;
            for (int ix = 0; ix < assigmnents.size(); ++ix) {
                ASTStatementExpression expr;
                ASTAssignmentOperator oper = assigmnents.get(ix);
                if (!oper.jjtGetParent().getClass().equals(ASTStatementExpression.class) || !(expr = (ASTStatementExpression)oper.jjtGetParent()).jjtGetChild(0).getClass().equals(ASTPrimaryExpression.class) || !((ASTPrimaryExpression)expr.jjtGetChild(0)).jjtGetChild(0).getClass().equals(ASTPrimaryPrefix.class)) continue;
                ASTPrimaryPrefix pp = (ASTPrimaryPrefix)((ASTPrimaryExpression)expr.jjtGetChild(0)).jjtGetChild(0);
                String name = null;
                if (pp.usesThisModifier()) {
                    ASTPrimarySuffix priSuf = expr.getFirstChildOfType(ASTPrimarySuffix.class);
                    name = priSuf.getImage();
                } else {
                    ASTName astName = (ASTName)pp.jjtGetChild(0);
                    name = astName.getImage();
                }
                if (!this.fieldDecls.containsKey(name)) continue;
                violation = true;
            }
            if (!violation) continue;
            this.addViolation(data, ifStatement);
        }
        return super.visit(node, data);
    }

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return propertyDescriptorsByName;
    }
}

