/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import net.sourceforge.pmd.properties.AbstractPMDProperty;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterProperty
extends AbstractPMDProperty {
    public CharacterProperty(String theName, String theDescription, char theDefault, float theUIOrder) {
        super(theName, theDescription, new Character(theDefault), theUIOrder);
    }

    public CharacterProperty(String theName, String theDescription, char[] theDefaults, float theUIOrder, char delimiter) {
        this(theName, theDescription, CharacterProperty.asCharacters(theDefaults), theUIOrder, delimiter);
    }

    public CharacterProperty(String theName, String theDescription, String theDefaults, float theUIOrder, char delimiter) {
        this(theName, theDescription, theDefaults.toCharArray(), theUIOrder, delimiter);
    }

    public CharacterProperty(String theName, String theDescription, Character[] theDefaults, float theUIOrder, char delimiter) {
        super(theName, theDescription, theDefaults, theUIOrder);
        this.multiValueDelimiter(delimiter);
        this.maxValueCount(Integer.MAX_VALUE);
    }

    private static final Character[] asCharacters(char[] chars) {
        Character[] characters = new Character[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            characters[i] = new Character(chars[i]);
        }
        return characters;
    }

    public Class<Character> type() {
        return Character.class;
    }

    @Override
    public Object valueFrom(String valueString) throws IllegalArgumentException {
        if (this.maxValueCount() == 1) {
            if (valueString.length() > 1) {
                throw new IllegalArgumentException(valueString);
            }
            return new Character(valueString.charAt(0));
        }
        String[] values = StringUtil.substringsOf(valueString, this.multiValueDelimiter);
        Character[] chars = new Character[values.length];
        for (int i = 0; i < values.length; ++i) {
            chars[i] = new Character(values[i].charAt(0));
        }
        return chars;
    }
}

