/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ast;

import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.JavaParserVisitor;
import net.sourceforge.pmd.ast.SimpleJavaNode;

public class ASTImportDeclaration
extends SimpleJavaNode {
    private boolean isImportOnDemand;
    private boolean isStatic;

    public ASTImportDeclaration(int id) {
        super(id);
    }

    public ASTImportDeclaration(JavaParser p, int id) {
        super(p, id);
    }

    public void setImportOnDemand() {
        this.isImportOnDemand = true;
    }

    public boolean isImportOnDemand() {
        return this.isImportOnDemand;
    }

    public void setStatic() {
        this.isStatic = true;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public ASTName getImportedNameNode() {
        return (ASTName)this.jjtGetChild(0);
    }

    public String getImportedName() {
        return ((ASTName)this.jjtGetChild(0)).getImage();
    }

    public String getPackageName() {
        String importName = this.getImportedName();
        if (this.isImportOnDemand) {
            return importName;
        }
        if (importName.indexOf(46) == -1) {
            return "";
        }
        int lastDot = importName.lastIndexOf(46);
        return importName.substring(0, lastDot);
    }

    public void dump(String prefix) {
        String out = "";
        if (this.isStatic()) {
            out = out + "(static)";
        }
        System.out.println(this.toString(prefix) + out);
        this.dumpChildren(prefix);
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

