/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.fix.actions;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import jrm.compressors.Archive;
import jrm.locale.Messages;
import jrm.profile.data.Entry;
import jrm.profile.fix.actions.EntryAction;
import jrm.ui.progress.ProgressHandler;

public class DeleteEntry
extends EntryAction {
    public DeleteEntry(Entry entry) {
        super(entry);
    }

    @Override
    public boolean doAction(FileSystem dstfs, ProgressHandler handler, int i, int max) {
        Path path = null;
        try {
            handler.setProgress(null, null, null, this.progress(i, max, String.format(Messages.getString("DeleteEntry.Deleting"), this.entry.file)));
            path = dstfs.getPath(this.entry.file, new String[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (Throwable e) {
            System.err.println("delete " + this.parent.container.file.getName() + "@" + path + " failed");
            return false;
        }
    }

    @Override
    public boolean doAction(Path target, ProgressHandler handler, int i, int max) {
        Path path = null;
        try {
            handler.setProgress(null, null, null, this.progress(i, max, String.format(Messages.getString("DeleteEntry.Deleting"), this.entry.file)));
            path = target.resolve(this.entry.file);
            Files.deleteIfExists(path);
            return true;
        }
        catch (Throwable e) {
            System.err.println("delete " + this.parent.container.file.getName() + "@" + path + " failed");
            return false;
        }
    }

    @Override
    public boolean doAction(Archive archive, ProgressHandler handler, int i, int max) {
        try {
            handler.setProgress(null, null, null, this.progress(i, max, String.format(Messages.getString("DeleteEntry.Deleting"), this.entry.file)));
            return archive.delete(this.entry.file) == 0;
        }
        catch (Throwable e) {
            System.err.println("delete " + this.parent.container.file.getName() + "@" + this.entry.file + " failed");
            return false;
        }
    }

    public String toString() {
        return String.format(Messages.getString("DeleteEntry.Delete"), this.entry);
    }
}

