/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.options;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.rundeck.client.tool.InputError;

public class OptionUtil {
    public static Map<String, String> parseKeyValueMap(List<String> input) throws InputError {
        return OptionUtil.parseKeyValueMap(input, "--", "=");
    }

    public static Map<String, String> parseKeyValueMap(List<String> input, String keyPrefix, String delim) throws InputError {
        HashMap<String, String> config = new HashMap<String, String>();
        if (!input.isEmpty()) {
            for (String s : input) {
                String[] arr;
                if (keyPrefix != null && !s.startsWith(keyPrefix)) {
                    throw new InputError(String.format("Expected %skey%svalue, but saw: %s", keyPrefix, delim, s));
                }
                if (keyPrefix != null) {
                    s = s.substring(keyPrefix.length());
                }
                if ((arr = s.split(Pattern.quote(delim), 2)).length != 2) {
                    throw new InputError(String.format("Expected %skey%svalue, but saw: %s", keyPrefix, delim, s));
                }
                config.put(arr[0], arr[1]);
            }
        }
        return config;
    }
}

