# GKrellM Changelog

## [2.4.0](https://git.srcbox.net/gkrellm/gkrellm/releases/tag/gkrellm-2.4.0) - 2025-01-19

- Use a sans-serif font and slightly bigger font sizes by default
- Add native GnuTLS support mail check via SSL/TLS and require GnuTLS 3.3 or newer (#29)
- Add and install a systemd service unit for gkrellmd
- Install gkrellmd configuration file in standard "install" make target
- Require and always use `getaddrinfo()` function. In a previous release this
  was already done on Linux. Now it also applies to other platforms like BSD,
  macOS, Solaris and Windows.
- Enable gkrellmd timeouts by default to make gkrellm clients automatically
  reconnect after a connection loss
- Fix syslog facility/priority code in gkrellmd to be POSIX compliant so it
  is more portable to Unix platforms other than Linux
- Require OpenSSL 1.1 or newer for mail check via SSL/TLS.
- Fix translations and add menu items to main context menu which were previously
  only available as debug options
- Replace MD5 code with existing functionality from GLib
- Add and install XDG desktop file as well as icons on Unix/Linux systems.
  This uses the GKrellM icon used on Windows only so far because the old icon
  is only available in a very small size that is not suitable for modern
  screen sizes. The icon is also used as the default window icon in taskbars
  and launchers.
- Use locale-dependent date and time formatting by default
- Add Windows 10, 11, Server 2016/2019/2022 OS version detection
- Do not strip executables during installation by default anymore. Use
  `make install-strip` if you prefer the old behavior.
- Fix syntax errors in manual pages (patch by Sandro Tosi)
- Fix GTK and GLib deprecation warnings and require GTK >= 2.24
- Fix most compiler warnings when building with GCC 13 and Clang 18
- Center each line in multiline clock/calendar decals
- Fix IPv6 address matching in gkrellmd client access list
- Update French translation (patch by Jerome UZEL)
- Fix stack corruption in Solaris kstat code (patch by Adam Stylinsk)

## [2.3.11](https://git.srcbox.net/gkrellm/gkrellm/releases/tag/gkrellm-2.3.11) - 2019-07-25

- Fix krell scale for medium sized filesystems (based on patch by Peter Hymann)
- Support OpenSSL >= 1.1 for mail check over SSL/TLS
- Sort Linux disk devices alphabetically (patch by Petr Gajdos)
- Avoid corruption of chart labels (based on patch by Stefan Seyfried)
- Fix possible buffer-overflow in disk size formatting

## [2.3.10](https://git.srcbox.net/gkrellm/gkrellm/releases/tag/gkrellm-2.3.10) - 2016-10-23

- Fix Linux nvme block devices
- Do not reject disks because they are not found in `/proc/devices` (the nvme
  disks may not be there) so new default is to accept anything in
  `/proc/diskstats` regardless if major number is known or in devices file.

## [2.3.9](https://git.srcbox.net/gkrellm/gkrellm/releases/tag/gkrellm-2.3.9) - 2016-10-11

- Fix mmc block devices (regression in 2.3.8)
- Allow Pango markup for all configurable panel labels

## [2.3.8](https://git.srcbox.net/gkrellm/gkrellm/releases/tag/gkrellm-2.3.8) - 2016-09-07

- Add option to ignore network interfaces that match a regular expression
  pattern
- Fix composite disk graph double counting
- Handle dynamic disk major numbers for `dm` and `mdp` virtual devices and don't
  add their data to the composite disk
- Disk panel labels are now configurable. This is mostly useful for user
  labeling of virtual disks
- Use wrap bytes instead of discarding data when cumulative chart data overflows
- Changed keyboard shortcut for theme changes to `Shift+Page Up` and `Shift+Page Down`
  (patch by Pavel Reznicek)
- Indentation cleanup bugfix for Linux kernel version detection
  (patch by Ville Skytta)

## [2.3.7](https://git.srcbox.net/gkrellm/gkrellm/releases/tag/gkrellm-2.3.7) - 2016-06-03

- Use `gdk_pixbuf_new_from_data()` instead of deprecated
  `gdk_pixbuf_new_from_inline()`. Inline `alert_inline[]` needed to be --raw.
- Fix sending error message back to clients that were refused by gkrellmd and
  add dialog to gkrellm client to display the error message
- Fix possible chart rendering problem for single pixels
- Fix compilation without OpenSSL and GnuTLS (patch by Felix Janda)
- Always use `getaddrinfo()` on Linux to fix IPv6 support on C libraries other
  than glibc (for example musl libc)
- Fix handling of `mmcblkN` SD disk partition numbers

## [2.3.6-RC2](https://git.srcbox.net/gkrellm/gkrellm/releases/tag/gkrellm-2.3.6-rc2) - 2015-12-23

- Each real CPU chart may be individually enabled instead of as a group so CPU
  charts may be split into multiple instances. For systems with large numbers
  of CPUs.
- Make drawing CPU panel labels optional to allow saving vertical space.
- Patch from Ville Skytta: fix some `netbsd.c` and `winops-win32.c` issues flagged by cppcheck.
- Patch from Neil Booth: Add multiple CPU capability to CPU monitor for
  Dragonfly. Acquired `dragonfly.c` from web so could apply patch. I have no clue
  why I never had a `dragonfly.c`.
- Patch from Jindrich Makovicka: Update multiple GKrellM files to compile with
  `-DGTK_DISABLE_DEPRECATED -DGSEAL_ENABLE` for GTK3 compatibility. Replaces
  GtkItemFactory and GtkTooltips.
- Add nvidia-smi interface to linux.c for getting nvidia GPU temperatures.
- Translation updates
  - ru.po from Roman Savochenko
  - uk.po new translation from Roman Savochenko
  - pt.po new translation from Ze based on pt_BR.po
  - fr.po from Jerome UZEL
- Bugfixes
  - fix memory leaks: add `g_thread_unref()` for all GThread pointers returned
    from `g_thread_new()` calls.
  - Flag config as modified when changing a charts Resolution per Grid and bump
    max grid resolution to 500000000.
  - Store lockfiles under `/var/lock/gkrellm-UID` directories to make lockfiles
    work for multiple users.
- Only link against and initialize Libgcrypt when building with GnuTLS < 2.12.
  This allows using GKrellM with GnuTLS versions built against Nettle instead
  of Libgcrypt.
- Patch from Gerard Neil: Skip autofs mounts in free disk space polling
- Patch from Gerard Neil: Handle cifs as remote filesystem to use longer
  `nfs-timeout` polling interval
- Patch from Alexandre Rostovtsev: Explicitly link against gmodule-2.0
- Add support for GPU-Z sensor information on Windows
- Increase minimum required GLib version to 2.32, some parts of gkrellm use
  newer GLib API
- Drop remaining GLib 1.x compatibility from gkrellmd
- Patch from Ville Skyttä: Allow binding to a listen address that doesn't exist
  yet (gkrellmd)
- Patch from Pierre Neyron: Option to enable/disable new network interfaces
  by default

## Older Releases

See [ChangeLog.OLD](Changelog.OLD)
