/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public class GeneratedClassLoader
extends URLClassLoader {
    private static final URLStreamHandler FAKE_BASE64_URL_HANDLER = new URLStreamHandler(){

        @Override
        protected URLConnection openConnection(URL url) {
            return new URLConnection(url){

                @Override
                public void connect() {
                }

                @Override
                public InputStream getInputStream() {
                    return new ByteArrayInputStream(Base64.getDecoder().decode(this.url.getPath()));
                }
            };
        }
    };
    private ClassFileFactory factory;

    public GeneratedClassLoader(@NotNull ClassFileFactory factory2, ClassLoader parentClassLoader, URL ... urls) {
        super(urls, parentClassLoader);
        this.factory = factory2;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        OutputFile outputFile = this.factory.get(name);
        if (outputFile != null) {
            return new ByteArrayInputStream(outputFile.asByteArray());
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> fromParent = super.findResources(name);
        URL url = this.createFakeURLForResource(name);
        if (url == null) {
            return fromParent;
        }
        List fromMe = Collections.singletonList(url);
        List result2 = fromParent.hasMoreElements() ? CollectionsKt.plus(fromMe, Collections.list(fromParent)) : fromMe;
        return Collections.enumeration(result2);
    }

    @Override
    public URL findResource(String name) {
        URL url = this.createFakeURLForResource(name);
        return url != null ? url : super.findResource(name);
    }

    @Nullable
    private URL createFakeURLForResource(@NotNull String name) {
        try {
            OutputFile outputFile = this.factory.get(name);
            return outputFile == null ? null : new URL(null, "bytes:" + Base64.getEncoder().encodeToString(outputFile.asByteArray()), FAKE_BASE64_URL_HANDLER);
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        String classFilePath = name.replace('.', '/') + ".class";
        OutputFile outputFile = this.factory.get(classFilePath);
        if (outputFile != null) {
            String pkgName;
            byte[] bytes = outputFile.asByteArray();
            int lastDot = name.lastIndexOf(46);
            if (lastDot >= 0 && this.getPackage(pkgName = name.substring(0, lastDot)) == null) {
                this.definePackage(pkgName, new Manifest(), null);
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return super.findClass(name);
    }

    public void dispose() {
        this.factory = null;
    }

    @NotNull
    public List<OutputFile> getAllGeneratedFiles() {
        return this.factory.asList();
    }
}

