/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.testng.ISuiteListener;
import org.testng.ITestListener;

class TestNGListenerAdapterFactory {
    private final ClassLoader classLoader;

    TestNGListenerAdapterFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ITestListener createAdapter(ITestListener listener) {
        Class<?> testNG6Class = this.tryLoadClass("org.testng.IConfigurationListener2");
        if (testNG6Class != null) {
            return this.createProxy(testNG6Class, listener);
        }
        Class<?> testNG5Class = this.tryLoadClass("org.testng.internal.IConfigurationListener");
        if (testNG5Class != null) {
            return this.createProxy(testNG5Class, listener);
        }
        throw new UnsupportedOperationException("Neither found interface 'org.testng.IConfigurationListener2' nor interface 'org.testng.internal.IConfigurationListener'. Which version of TestNG are you using?");
    }

    private Class<?> tryLoadClass(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private ITestListener createProxy(Class<?> configListenerClass, ITestListener listener) {
        ArrayList interfaces = new ArrayList();
        interfaces.add(ITestListener.class);
        interfaces.add(ISuiteListener.class);
        interfaces.add(configListenerClass);
        Class<?> iClassListenerClass = this.tryLoadClass("org.testng.IClassListener");
        if (iClassListenerClass != null) {
            interfaces.add(iClassListenerClass);
        }
        return (ITestListener)Proxy.newProxyInstance(this.classLoader, interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new AdaptedListener(listener));
    }

    private static class AdaptedListener
    implements InvocationHandler {
        private final ITestListener delegate;

        private AdaptedListener(ITestListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class realReturnType;
            Class boxedReturnType = realReturnType = method.getReturnType();
            if (!realReturnType.equals(Void.TYPE) && realReturnType.isPrimitive()) {
                boxedReturnType = JavaReflectionUtil.getWrapperTypeForPrimitiveType(realReturnType);
            }
            if (method.getName().equals("equals") && args != null && args.length == 1) {
                return this.proxyEquals(proxy, args[0]);
            }
            if (method.getName().equals("hashCode") && args == null) {
                return this.proxyHashCode(proxy);
            }
            return this.invoke(this.delegate.getClass(), this.delegate, boxedReturnType, method, args);
        }

        private <T, R> R invoke(Class<T> listenerType, Object listener, Class<R> returnType, Method method, Object[] args) {
            T listenerCast = listenerType.cast(listener);
            JavaMethod javaMethod = JavaReflectionUtil.method(listenerType, returnType, (String)method.getName(), (Class[])method.getParameterTypes());
            return (R)javaMethod.invoke(listenerCast, args);
        }

        private boolean proxyEquals(Object proxy, Object other) {
            if (other == null) {
                return false;
            }
            if (proxy == other) {
                return true;
            }
            if (!Proxy.isProxyClass(other.getClass())) {
                return false;
            }
            InvocationHandler otherHandler = Proxy.getInvocationHandler(other);
            if (!(otherHandler instanceof AdaptedListener)) {
                return false;
            }
            AdaptedListener proxyAdapter = (AdaptedListener)Proxy.getInvocationHandler(proxy);
            AdaptedListener otherAdapter = (AdaptedListener)otherHandler;
            return proxyAdapter.getClass().equals(otherHandler.getClass()) && proxyAdapter.delegate.getClass().equals(otherAdapter.delegate.getClass());
        }

        private int proxyHashCode(Object proxy) {
            AdaptedListener invocationHandler = (AdaptedListener)Proxy.getInvocationHandler(proxy);
            return Arrays.hashCode(new Object[]{invocationHandler.getClass(), invocationHandler.delegate.getClass()});
        }
    }
}

