/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;

public class DefaultBuildCacheHasher
implements BuildCacheHasher {
    private final Hasher hasher = Hashing.md5().newHasher();
    private boolean valid = true;

    @Override
    public DefaultBuildCacheHasher putByte(byte value) {
        this.hasher.putInt(1);
        this.hasher.putByte(value);
        return this;
    }

    @Override
    public DefaultBuildCacheHasher putBytes(byte[] bytes) {
        this.hasher.putInt(bytes.length);
        this.hasher.putBytes(bytes);
        return this;
    }

    @Override
    public DefaultBuildCacheHasher putBytes(byte[] bytes, int off, int len) {
        this.hasher.putInt(len);
        this.hasher.putBytes(bytes, off, len);
        return this;
    }

    @Override
    public BuildCacheHasher putHash(HashCode hashCode) {
        this.hasher.putInt(hashCode.length());
        this.hasher.putHash(hashCode);
        return this;
    }

    @Override
    public DefaultBuildCacheHasher putInt(int value) {
        this.hasher.putInt(4);
        this.hasher.putInt(value);
        return this;
    }

    @Override
    public DefaultBuildCacheHasher putLong(long value) {
        this.hasher.putInt(8);
        this.hasher.putLong(value);
        return this;
    }

    @Override
    public DefaultBuildCacheHasher putDouble(double value) {
        this.hasher.putInt(8);
        this.hasher.putDouble(value);
        return this;
    }

    @Override
    public DefaultBuildCacheHasher putBoolean(boolean value) {
        this.hasher.putInt(1);
        this.hasher.putBoolean(value);
        return this;
    }

    @Override
    public DefaultBuildCacheHasher putString(CharSequence value) {
        this.hasher.putInt(value.length());
        this.hasher.putString(value);
        return this;
    }

    @Override
    public DefaultBuildCacheHasher putNull() {
        this.putInt(0);
        return this;
    }

    @Override
    public void markAsInvalid() {
        this.valid = false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public HashCode hash() {
        if (!this.valid) {
            throw new IllegalStateException("Build cache hash is not valid");
        }
        return this.hasher.hash();
    }
}

