/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution.statistics;

import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.statistics.TaskExecutionStatistics;
import org.gradle.api.internal.tasks.execution.statistics.TaskExecutionStatisticsListener;
import org.gradle.api.tasks.TaskState;
import org.gradle.internal.InternalBuildAdapter;

public class TaskExecutionStatisticsEventAdapter
extends InternalBuildAdapter
implements BuildListener,
TaskExecutionListener {
    private final TaskExecutionStatisticsListener listener;
    private int executedTasksCount;
    private int fromCacheTaskCount;
    private int upToDateTaskCount;

    public TaskExecutionStatisticsEventAdapter(TaskExecutionStatisticsListener listener) {
        this.listener = listener;
    }

    public void buildFinished(BuildResult result) {
        if (result.getGradle().getParent() == null) {
            this.listener.buildFinished(new TaskExecutionStatistics(this.executedTasksCount, this.fromCacheTaskCount, this.upToDateTaskCount));
        }
    }

    public void beforeExecute(Task task) {
    }

    public void afterExecute(Task task, TaskState state) {
        TaskStateInternal stateInternal;
        if (!this.taskIsForNestedBuild(task) && (stateInternal = (TaskStateInternal)state).isActionable()) {
            switch (stateInternal.getOutcome()) {
                case EXECUTED: {
                    ++this.executedTasksCount;
                    break;
                }
                case FROM_CACHE: {
                    ++this.fromCacheTaskCount;
                    break;
                }
                case UP_TO_DATE: {
                    ++this.upToDateTaskCount;
                    break;
                }
            }
        }
    }

    private boolean taskIsForNestedBuild(Task task) {
        return task.getProject().getGradle().getParent() != null;
    }
}

