/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.googleapis.auth.oauth2.SystemEnvironmentProvider;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.util.Beta;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class OAuth2Utils {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Logger LOGGER = Logger.getLogger(OAuth2Utils.class.getName());
    private static final String DEFAULT_METADATA_SERVER_URL = "http://169.254.169.254";
    private static final int MAX_COMPUTE_PING_TRIES = 3;
    private static final int COMPUTE_PING_CONNECTION_TIMEOUT_MS = 500;

    static <T extends Throwable> T exceptionWithCause(T exception, Throwable cause) {
        exception.initCause(cause);
        return exception;
    }

    static boolean headersContainValue(HttpHeaders headers, String headerName, String value) {
        Object values = headers.get((Object)headerName);
        if (values instanceof Collection) {
            Collection valuesList = (Collection)values;
            for (Object headerValue : valuesList) {
                if (!(headerValue instanceof String) || !((String)headerValue).equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean runningOnComputeEngine(HttpTransport transport, SystemEnvironmentProvider environment) {
        if (Boolean.parseBoolean(environment.getEnv("NO_GCE_CHECK"))) {
            return false;
        }
        GenericUrl tokenUrl = new GenericUrl(OAuth2Utils.getMetadataServerUrl(environment));
        for (int i = 1; i <= 3; ++i) {
            boolean bl;
            HttpRequest request2 = transport.createRequestFactory().buildGetRequest(tokenUrl);
            request2.setConnectTimeout(500);
            HttpResponse response = request2.execute();
            try {
                HttpHeaders headers = response.getHeaders();
                bl = OAuth2Utils.headersContainValue(headers, "Metadata-Flavor", "Google");
            }
            catch (Throwable throwable) {
                try {
                    response.disconnect();
                    throw throwable;
                }
                catch (SocketTimeoutException request2) {
                    continue;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to detect whether we are running on Google Compute Engine.", e);
                }
            }
            response.disconnect();
            return bl;
        }
        return false;
    }

    public static String getMetadataServerUrl() {
        return OAuth2Utils.getMetadataServerUrl(SystemEnvironmentProvider.INSTANCE);
    }

    static String getMetadataServerUrl(SystemEnvironmentProvider environment) {
        String metadataServerAddress = environment.getEnv("GCE_METADATA_HOST");
        if (metadataServerAddress != null) {
            String string = String.valueOf(metadataServerAddress);
            return string.length() != 0 ? "http://".concat(string) : new String("http://");
        }
        return DEFAULT_METADATA_SERVER_URL;
    }
}

