/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Equivalence;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class CandidateMethods {
    private final Map<String, Map<Equivalence.Wrapper<Method>, Collection<Method>>> candidates;

    public CandidateMethods(Map<String, Map<Equivalence.Wrapper<Method>, Collection<Method>>> candidates) {
        this.candidates = candidates;
    }

    boolean isEmpty() {
        return this.candidates.isEmpty();
    }

    public Iterable<String> methodNames() {
        return this.candidates.keySet();
    }

    public Map<Equivalence.Wrapper<Method>, Collection<Method>> allMethods() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map<Equivalence.Wrapper<Method>, Collection<Method>> candidatesForSomeName : this.candidates.values()) {
            builder.putAll(candidatesForSomeName);
        }
        return builder.build();
    }

    Map<Equivalence.Wrapper<Method>, Collection<Method>> methodsNamed(String methodName) {
        if (this.candidates.containsKey(methodName)) {
            return this.candidates.get(methodName);
        }
        return Collections.emptyMap();
    }

    public Map<Equivalence.Wrapper<Method>, Collection<Method>> overriddenMethodsNamed(String methodName) {
        if (this.candidates.containsKey(methodName)) {
            return Maps.filterValues(this.candidates.get(methodName), (Predicate)new Predicate<Collection<Method>>(){

                public boolean apply(Collection<Method> equivalentMethods) {
                    return equivalentMethods.size() > 1;
                }
            });
        }
        return Collections.emptyMap();
    }

    public Map<Equivalence.Wrapper<Method>, Collection<Method>> overloadedMethodsNamed(String methodName, Collection<Equivalence.Wrapper<Method>> excludes) {
        return Maps.filterKeys(this.overloadedMethodsNamed(methodName), (Predicate)Predicates.not((Predicate)Predicates.in(excludes)));
    }

    Map<Equivalence.Wrapper<Method>, Collection<Method>> overloadedMethodsNamed(String methodName) {
        Map<Equivalence.Wrapper<Method>, Collection<Method>> overloadeds;
        if (this.candidates.containsKey(methodName) && (overloadeds = this.candidates.get(methodName)).size() > 1) {
            return overloadeds;
        }
        return Collections.emptyMap();
    }
}

