/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Transformer;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.SystemClassLoaderSpec;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderCache;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.serialization.ClientOwnedClassLoaderSpec;
import org.gradle.tooling.internal.provider.serialization.DeserializeMap;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderFactory;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.SerializeMap;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultPayloadClassLoaderRegistry
implements PayloadClassLoaderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPayloadClassLoaderRegistry.class);
    private final PayloadClassLoaderFactory classLoaderFactory;
    private final ClassLoaderCache cache;
    private final ClassLoaderToDetailsTransformer detailsToClassLoader = new ClassLoaderToDetailsTransformer();
    private final DetailsToClassLoaderTransformer classLoaderToDetails = new DetailsToClassLoaderTransformer();

    public DefaultPayloadClassLoaderRegistry(ClassLoaderCache cache, PayloadClassLoaderFactory payloadClassLoaderFactory) {
        this.cache = cache;
        this.classLoaderFactory = payloadClassLoaderFactory;
    }

    @Override
    public SerializeMap newSerializeSession() {
        return new SerializeMap(){
            final Map<ClassLoader, Short> classLoaderIds = new HashMap<ClassLoader, Short>();
            final Map<Short, ClassLoaderDetails> classLoaderDetails = new HashMap<Short, ClassLoaderDetails>();

            @Override
            public short visitClass(Class<?> target) {
                ClassLoader classLoader = target.getClassLoader();
                Short id = this.classLoaderIds.get(classLoader);
                if (id != null) {
                    return id;
                }
                if (this.classLoaderIds.size() == Short.MAX_VALUE) {
                    throw new UnsupportedOperationException();
                }
                ClassLoaderDetails details = DefaultPayloadClassLoaderRegistry.this.getDetails(classLoader);
                id = (short)(this.classLoaderIds.size() + 1);
                this.classLoaderIds.put(classLoader, id);
                this.classLoaderDetails.put(id, details);
                return id;
            }

            @Override
            public void collectClassLoaderDefinitions(Map<Short, ClassLoaderDetails> details) {
                details.putAll(this.classLoaderDetails);
            }
        };
    }

    @Override
    public DeserializeMap newDeserializeSession() {
        return new DeserializeMap(){

            @Override
            public Class<?> resolveClass(ClassLoaderDetails classLoaderDetails, String className) throws ClassNotFoundException {
                ClassLoader classLoader = DefaultPayloadClassLoaderRegistry.this.getClassLoader(classLoaderDetails);
                return Class.forName(className, false, classLoader);
            }
        };
    }

    private ClassLoader getClassLoader(ClassLoaderDetails details) {
        ClassLoader classLoader = this.cache.getClassLoader(details, this.detailsToClassLoader);
        if (details.spec instanceof ClientOwnedClassLoaderSpec) {
            ClientOwnedClassLoaderSpec spec = (ClientOwnedClassLoaderSpec)details.spec;
            VisitableURLClassLoader urlClassLoader = (VisitableURLClassLoader)classLoader;
            ImmutableSet currentClassPath = ImmutableSet.copyOf((Object[])urlClassLoader.getURLs());
            for (URL url : spec.getClasspath()) {
                if (currentClassPath.contains(url)) continue;
                JavaReflectionUtil.method(URLClassLoader.class, Void.class, "addURL", new Class[]{URL.class}).invoke((Class<URLClassLoader>)((Object)urlClassLoader), url);
            }
        }
        return classLoader;
    }

    private ClassLoaderDetails getDetails(ClassLoader classLoader) {
        return this.cache.getDetails(classLoader, this.classLoaderToDetails);
    }

    private class DetailsToClassLoaderTransformer
    implements Transformer<ClassLoaderDetails, ClassLoader> {
        private DetailsToClassLoaderTransformer() {
        }

        @Override
        public ClassLoaderDetails transform(ClassLoader classLoader) {
            ClassLoaderSpecVisitor visitor = new ClassLoaderSpecVisitor(classLoader);
            visitor.visit(classLoader);
            if (visitor.spec == null) {
                visitor.spec = visitor.classPath == null ? SystemClassLoaderSpec.INSTANCE : new VisitableURLClassLoader.Spec(CollectionUtils.toList(visitor.classPath));
            }
            UUID uuid = UUID.randomUUID();
            ClassLoaderDetails details = new ClassLoaderDetails(uuid, visitor.spec);
            for (ClassLoader parent : visitor.parents) {
                details.parents.add(DefaultPayloadClassLoaderRegistry.this.getDetails(parent));
            }
            return details;
        }
    }

    private class ClassLoaderToDetailsTransformer
    implements Transformer<ClassLoader, ClassLoaderDetails> {
        private ClassLoaderToDetailsTransformer() {
        }

        @Override
        public ClassLoader transform(ClassLoaderDetails details) {
            ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>();
            for (ClassLoaderDetails parentDetails : details.parents) {
                parents.add(DefaultPayloadClassLoaderRegistry.this.getClassLoader(parentDetails));
            }
            if (parents.isEmpty()) {
                parents.add(DefaultPayloadClassLoaderRegistry.this.classLoaderFactory.getClassLoaderFor(SystemClassLoaderSpec.INSTANCE, (List<? extends ClassLoader>)ImmutableList.of()));
            }
            LOGGER.info("Creating ClassLoader {} from {} and {}.", new Object[]{details.uuid, details.spec, parents});
            return DefaultPayloadClassLoaderRegistry.this.classLoaderFactory.getClassLoaderFor(details.spec, parents);
        }
    }

    private static class ClassLoaderSpecVisitor
    extends ClassLoaderVisitor {
        final ClassLoader classLoader;
        final List<ClassLoader> parents = new ArrayList<ClassLoader>();
        ClassLoaderSpec spec;
        URL[] classPath;

        public ClassLoaderSpecVisitor(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public void visit(ClassLoader candidate) {
            if (candidate == this.classLoader) {
                super.visit(candidate);
            } else {
                this.parents.add(candidate);
            }
        }

        @Override
        public void visitClassPath(URL[] classPath) {
            this.classPath = classPath;
        }

        @Override
        public void visitSpec(ClassLoaderSpec spec) {
            this.spec = spec;
        }
    }
}

