#!/usr/bin/python2
## xConfigDialog.py - UI code for configuring resolution and color depth
## Copyright (C) 2001-2003 Red Hat, Inc.

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import os
import xf86config
import gtk
import gtk.glade
import monitorDialog
import screenSizePreview
import videocardDialog
import dbus
import rhpxl.videocard
from rhpl.translate import _, N_,textdomain
from rhpxl.xhwstate import *

TRUE = 1
FALSE = 0
    
##
## I18N
## 
import gettext
gettext.bindtextdomain ("system-config-display", "/usr/share/locale")
gettext.textdomain ("system-config-display")
_=gettext.gettext

class XConfigDialog:
    def setup_sizegroups(self):
        xml = self.xml

    def depth_changed(self, *args):
        depth = self.depth_option_menu.get_menu().get_active().get_data("DEPTH")
        if depth == self.state.get_colordepth ():
            return

        self.state.set_colordepth (depth)
        res = self.res_option_menu.get_menu().get_active().get_data("RESOLUTION")
        self.setup_ui_resolution (res)

    def update_ui(self, *args):
        res = self.res_option_menu.get_menu().get_active().get_data("RESOLUTION")
        (w,h) = resolution_from_string(res)
        self.size_preview.set_resolution(w,h)

        label = self.xml.get_widget("display_label")
        label.set_text(_("%s with %s")%(self.state.get_monitor_name(), self.state.get_videocard_name()))

        self.xml.get_widget("monitor_type_label").set_text(self.state.get_monitor_name())
        self.xml.get_widget("videocard_type_label").set_text(self.state.get_videocard_name())

    def setup_ui_resolution(self, current_res):
        box = self.xml.get_widget("resolution_radiobutton_box")
        last = None
        available_resolutions = self.state.available_resolutions()

        res_menu = gtk.Menu()
        count = 0
        current = 0
        for res in available_resolutions:
            item = gtk.MenuItem(res)
            item.set_data("RESOLUTION", res)
            res_menu.append(item)
            if res == current_res:
                #Let's remember which position is the current resolution
                current = count
            count = count + 1

        self.res_option_menu.set_menu(res_menu)
        #Select the correct menu item
        self.res_option_menu.set_history(current)
        self.res_option_menu.show_all()
        
    def run(self):
        dialog = self.xml.get_widget("display_dialog")
        dialog.set_position(gtk.WIN_POS_CENTER)
        dialog.show()
        self.dialog_result = 0
        gtk.main()
        dialog.hide()
        return self.dialog_result

    def firstboot_apply(self):
        #This function applies the changes made in the Display screen from firstboot
        res = self.res_option_menu.get_menu().get_active().get_data("RESOLUTION")
        depth = self.depth_option_menu.get_menu().get_active().get_data("DEPTH")

        self.state.set_colordepth(depth)
        self.state.set_resolution(res)

        # Reread config before merge
        (xconfig, xconfigpath) = xf86config.readConfigFile()
        self.state.merge_into(xconfig)

        xconfig.write("/etc/X11/xorg.conf")

    def ok(self, widget):
        res = self.res_option_menu.get_menu().get_active().get_data("RESOLUTION")
        depth = self.depth_option_menu.get_menu().get_active().get_data("DEPTH")

        self.state.set_colordepth(depth)
        self.state.set_resolution(res)

        if self.enableCheckButton.get_active() == True:
            #Dual head system

            if len(self.xconfig.monitor) < 2 and not self.autoconfig_monitor:
                #This was originally a single monitor file

                if self.second_monitor_dialog != None:
                    #Don't dehydrate the dialog if it hasn't been run
                    self.second_monitor_model, self.second_monitor_vrefresh, self.second_monitor_hsync = self.second_monitor_dialog.dehydrate_second_monitor(self.state)
                else:
                    #They haven't selected a second monitor, so complain
                    self.configure_second_monitor(None)
                    return None
                    

                second_monitor = xf86config.XF86ConfMonitor()
                second_monitor.identifier = "Monitor1"
                second_monitor.modelname = self.second_monitor_model

                vr = str(self.second_monitor_vrefresh)
                if '-' in vr:
                    lower_vrefresh, upper_vrefresh = string.split(vr, "-")
                else:
                    lower_vrefresh = vr
                    upper_vrefresh = vr

                vs = str(self.second_monitor_hsync)
                if '-' in vs:
                    lower_hsync, upper_hsync = string.split(vs, "-")
                else:
                    lower_hsync = vs
                    upper_hsync = vs
                
                second_monitor.vendor = "Monitor Vendor"
                second_monitor.n_vrefresh = 1
                second_monitor.vrefresh[0] = (float(lower_vrefresh), float(upper_vrefresh))
                second_monitor.n_hsync = 1
                second_monitor.hsync[0] = (float(lower_hsync), float(upper_hsync))
                self.xconfig.monitor.insert(second_monitor)

                option = xf86config.XF86Option("dpms")
                second_monitor.options.insert(option)
                
            else:
                #There are already two monitors in the file.  Let's apply changes to the second one
                second_monitor = self.xconfig.monitor[1]
                second_monitor.identifier = "Monitor1"
                second_monitor.modelname = self.second_monitor_model

                lower_vrefresh, upper_vrefresh = self.second_monitor_vrefresh
                lower_hsync, upper_hsync = self.second_monitor_hsync
                
                second_monitor.vendor = "Monitor Vendor"
                second_monitor.n_vrefresh = 1
                second_monitor.vrefresh[0] = (float(lower_vrefresh), float(upper_vrefresh))
                second_monitor.n_hsync = 1
                second_monitor.hsync[0] = (float(lower_hsync), float(upper_hsync))

            if len(self.xconfig.screen) == 1:
                #There is only one screen listed.  Create a new screen
                second_screen = xf86config.XF86ConfScreen()
                second_screen.identifier = "Screen1"
                second_screen.device = "Videocard1"
                second_screen.monitor = "Monitor1"

                display_option = xf86config.XF86ConfDisplay()
                depth = self.secondDepthOptionMenu.get_menu().get_active().get_data("DEPTH")
                display_option.depth = depth
                second_screen.defaultdepth = depth

                res = self.secondResolutionOptionMenu.get_menu().get_active().get_data("RESOLUTION")
                mode = xf86config.XF86Mode(res)
                display_option.modes.insert(mode)
                
                second_screen.display.insert(display_option)
                self.xconfig.screen.insert(second_screen)

            elif len(self.xconfig.screen) == 2:
                #There are already two screens.  Let's apply changes to the second screen
                second_screen = self.xconfig.screen[1]
                display_option = second_screen.display[0]
                depth = self.secondDepthOptionMenu.get_menu().get_active().get_data("DEPTH")
                display_option.depth = depth
                second_screen.defaultdepth = depth

                res = self.secondResolutionOptionMenu.get_menu().get_active().get_data("RESOLUTION")
                display_option.modes[0].name = res

            if len(self.xconfig.device) == 1:
                #There is only one videocard device.  Create a new one
                second_videocard = xf86config.XF86ConfDevice()

                #lookup the videocard driver
                for card in self.vc.videocards:
                    if card.getDescription() == self.secondVideocardOptionMenu.get_menu().get_active().get_data("NAME"):
                        second_videocard.driver = card.getDriver()
                        second_videocard.board = card.getDescription()
                        second_videocard.vendor = "Videocard Vendor"
                        second_videocard.identifier = "Videocard1"
                        secondPCIBus = "PCI:%d:%d:%d" % (card.getPCIBus(), card.getPCIDev(), card.getPCIFn())
                        second_videocard.busid = secondPCIBus
                        if self.state.get_videocard_PCIBus() is None:
                            primaryPCIBus = secondPCIBus
                        else:
                            primaryPCIBus = "PCI:%d:%d:%d" % (self.state.get_videocard_PCIBus(),
                                                              self.state.get_videocard_PCIDev(),
                                                              self.state.get_videocard_PCIFn())

                        if primaryPCIBus == secondPCIBus:
                            second_videocard.screen = 1

                self.xconfig.device.insert(second_videocard)

            elif len(self.xconfig.device) == 2:
                #There are already two videocards.  Let's apply changes to the second one
                second_videocard = self.xconfig.device[1]

                #lookup the videocard driver
                for card in self.vc.videocards:
                    if card.getDescription() == self.secondVideocardOptionMenu.get_menu().get_active().get_data("NAME"):
                        second_videocard.driver = card.getDriver()
                        second_videocard.board = card.getDescription()
                        second_videocard.vendor = "Videocard Vendor"
                        second_videocard.identifier = "Videocard1"
                        second_videocard.busid = "PCI:%d:%d:%d" % (card.getPCIBus(), card.getPCIDev(), card.getPCIFn())

            if len(self.xconfig.layout[0].adjacencies) == 1:
                #We need to modify the existing Screen and add a second one
                self.xconfig.layout[0].identifier = "Multihead layout"
                self.xconfig.layout[0].adjacencies[0].scrnum = 0
                self.xconfig.layout[0].adjacencies[0].where = 2
                self.xconfig.layout[0].adjacencies[0].refscreen = "Screen1"

                second_adjacency = xf86config.XF86ConfAdjacency()
                second_adjacency.scrnum = 1
                second_adjacency.screen = "Screen1"
                self.xconfig.layout[0].adjacencies.insert(second_adjacency)
            
            xinerama_option_exists = 0
            clone_option_exists = 0

            for option in self.xconfig.layout[0].options:
                #Let's find out if the options already exist or not
                if option.name == "Xinerama":
                    xinerama_option_exists = 1
                if option.name == "Clone":
                    clone_option_exists = 1

            if xinerama_option_exists == 0:
                #Xinerama option didn't exist, so create it
                xinerama_option = xf86config.XF86Option("Xinerama")
                self.xconfig.layout[0].options.insert(xinerama_option)

            if clone_option_exists == 0:
                #Clone option didn't exist, so create it
                clone_option = xf86config.XF86Option("Clone")
                self.xconfig.layout[0].options.insert(clone_option)

            if self.xml.get_widget("layoutOptionMenu").get_history() == 0:
                #They selected Individual Desktops (Clone mode)
                for option in self.xconfig.layout[0].options:
                    if option.name == "Xinerama":
                        option.val = "off"
                    if option.name == "Clone":
                        option.val = "on"

            elif self.xml.get_widget("layoutOptionMenu").get_history() == 1:
                #They selected Spanning Desktops (Xinerama mode)
                for option in self.xconfig.layout[0].options:
                    if option.name == "Xinerama":
                        option.val = "on"
                    if option.name == "Clone":
                        option.val = "off"

        else:
            #Single head system
            self.xconfig.layout[0].identifier = "single head configuration"

            #Remove secondary screen
            count = 0
            for adj in self.xconfig.layout[0].adjacencies:
                if adj.screen == "Screen0":
                    adj.scrnum = 0
                    adj.where = 0
                    adj.refscreen = "" 
                    
                if adj.screen == "Screen1":
                    self.xconfig.layout[0].adjacencies.remove(count)
                count = count + 1

            #Scan for Xinerama options and remove it
            count = 0
            for option in self.xconfig.layout[0].options:
                if option.name == "Xinerama":
                    self.xconfig.layout[0].options.remove(count)

            #Scan for Clone options and remove it
            count = 0
            for option in self.xconfig.layout[0].options:
                if option.name == "Clone":
                    self.xconfig.layout[0].options.remove(count)
                count = count + 1

            if len(self.xconfig.monitor) > 1:
                self.xconfig.monitor.remove(1)
            if len(self.xconfig.device) > 1:
                self.xconfig.device.remove(1)
            if len(self.xconfig.screen) > 1:
                self.xconfig.screen.remove(1)
            if len(self.xconfig.monitor) == 0 and not self.autoconfig_monitor:

                monitor = xf86config.XF86ConfMonitor()
                monitor.identifier = "Monitor0"
                monitor.modelname = self.state.get_monitor_name()

                if self.state.get_vsync().count("-") > 0:
                    lower_vrefresh, upper_vrefresh = string.split(self.state.get_vsync(), "-")
                else:
                    lower_vrefresh = float(self.state.get_vsync()) - 0.1
                    upper_vrefresh = float(self.state.get_vsync()) + 0.1

                if self.state.get_hsync().count("-") > 0:
                    lower_hsync, upper_hsync = string.split(self.state.get_hsync(), "-")
                else:
                    lower_hsync = float(self.state.get_hsync()) - 0.1
                    upper_hsync = float(self.state.get_hsync()) + 0.1
                
                monitor.n_vrefresh = 1
                monitor.vrefresh[0] = (float(lower_vrefresh), float(upper_vrefresh))
                monitor.n_hsync = 1
                monitor.hsync[0] = (float(lower_hsync), float(upper_hsync))
                self.xconfig.monitor.insert(monitor)

                option = xf86config.XF86Option("dpms")
                monitor.options.insert(option)
                
                self.xconfig.screen[0].monitor = "Monitor0"
                

        self.dialog_result = 1
        gtk.main_quit()

    def cancel(self, widget):
        gtk.main_quit()
        
    def delete(self, widget, event):
        gtk.main_quit()
        return 1

    def configure_monitor(self, widget, name=None):
        
        if not self.monitor_dialog:
            self.monitor_dialog = monitorDialog.MonitorDialog(self.xml, self.state.monitor,
                                                                 self.state.monitor.getMonitorID(),
                                                                 self.state, name)
            self.monitor_dialog.hydrate_primary_monitor()

        self.monitor_dialog.goto_path()

        if self.monitor_dialog.run():
            self.monitor_dialog.dehydrate_primary_monitor(self.state)
            self.state.recalc_mode()
            self.setup_ui_resolution(self.state.get_resolution())            
            self.update_ui()
            self.autoconfig_monitor = 0

    def configure_videocard(self, *args):
        if not self.videocard_dialog:
            self.videocard_dialog = videocardDialog.VideocardDialog(self.xml, self.state.videocard,
                                                                    self.state)

        if self.videocard_dialog.run():
            self.videocard_dialog.dehydrate(self.state)
            self.state.recalc_mode()
            self.setup_ui_resolution(self.state.get_resolution())            
            self.update_ui()

    def configure_second_monitor(self, widget, name=None):
        if not self.second_monitor_dialog:

            self.second_monitor_dialog = monitorDialog.MonitorDialog(self.xml, self.state.monitor,
                                                                     self.state.monitor.getMonitorID(),
                                                                     self.state, name)
            self.second_monitor_dialog.hydrate_second_monitor()            

        self.second_monitor_dialog.goto_path()

        if self.second_monitor_dialog.run():
            model, vrefresh, hsync = self.second_monitor_dialog.dehydrate_second_monitor(self.state)

            self.xml.get_widget("secondMonitorLabel").set_text(model)
            self.autoconfig_monitor = 0
            
    def enable_toggled(self, *args):
        if self.enableCheckButton.get_active() == True:
            self.mon2.set_from_file("/usr/share/system-config-display/pixmaps/monitor-on.png")
            self.settingTable.set_sensitive(True)
        else:
            self.mon2.set_from_file("/usr/share/system-config-display/pixmaps/monitor-off.png")            
            self.settingTable.set_sensitive(False)

    def get_display_page(self):

        #unpack the first page and return it.  This is for the firstboot display screen
        notebook =  self.xml.get_widget("notebook")

        vbox = notebook.get_children()[0]
        notebook.remove(vbox)

        vbox.set_spacing(15)
        vbox.set_border_width(0)

        monitorLabel = vbox.get_children()[2]
        table = vbox.get_children()[3]
        vbox.remove(monitorLabel)

        monitorButton = gtk.Button(_("Configure..."))
        monitorButton.connect("clicked", self.configure_monitor, self.state.get_monitor_name())

        #rearrange table
        resolutionLabel = table.get_children()[0]
        depthLabel  = table.get_children()[1]
        resolutionButton = table.get_children()[2]
        depthButton  = table.get_children()[3]

        table.remove(resolutionLabel)
        table.remove(resolutionButton)
        table.remove(depthLabel)
        table.remove(depthButton)

        table.resize( table.get_property("n-rows") +1, table.get_property("n-columns"))

        monitorLabel.set_justify(gtk.JUSTIFY_LEFT)
        monitorLabel.set_line_wrap(True)
        monitorLabel.set_property("xalign", 1)
        monitorLabel.set_property("yalign", 0.5)
 
        table.attach(monitorLabel, 0, 1, 0, 1, yoptions=gtk.FILL)
        table.attach(monitorButton, 1, 2, 0, 1, yoptions=gtk.FILL)
        table.attach(resolutionLabel, 0, 1, 1, 2, yoptions=gtk.FILL)
        table.attach(resolutionButton, 1, 2, 1, 2, yoptions=gtk.FILL)
        table.attach(depthLabel, 0, 1, 2, 3, yoptions=gtk.FILL)
        table.attach(depthButton, 1, 2, 2, 3, yoptions=gtk.FILL)
        monitorButton.show()

        self.setup_ui_resolution(self.state.get_resolution())
        availableDepths = self.state.available_color_depths()

        if availableDepths:
            self.depth_option_menu.set_history(availableDepths.index(availableDepths[-1]))

        return vbox
    
    # There are good languages for writing EDID parsers. Python is NOT ONE OF THEM.
    def get_monitor_from_display(self,state):
        try: 
            import gtk
            import gtk.gdk
        except:
            return

        root = gtk.gdk.get_default_root_window()
        edid = root.property_get("XFree86_DDC_EDID1_RAWDATA")
        if not edid:
            return None
        edid = edid[2]

        name = None
        for x in [ 57, 75, 93, 111 ]:
            if ord(edid[x]) == 0xfc:
                n = edid[x+2:].split('\0')[0]
                n = n.strip()
                if name:
                    name = '%s %s' % (name, n)
                else:
                    name = n
                state.set_monitor_name(_("%s (autoconfigured)") % name)
            elif ord(edid[x]) == 0xfd:
                state.set_vsync("%d-%d" % (ord(edid[x+2]), ord(edid[x+3])))
                state.set_hsync("%d-%d" % (ord(edid[x+4]), ord(edid[x+5])))
    
    def hal_pci_video_card_list(self):
	bus = dbus.SystemBus()
	hal = dbus.Interface(bus.get_object("org.freedesktop.Hal", "/org/freedesktop/Hal/Manager"), "org.freedesktop.Hal.Manager")
	devstrings = hal.FindDeviceStringMatch("info.bus", "pci")
	devs = map(lambda x: dbus.Interface(bus.get_object("org.freedesktop.Hal", x), "org.freedesktop.Hal.Device"), devstrings)
	return filter(lambda x: x.GetProperty("pci.device_class") == 3, devs)

    def __init__(self, hardware_state, xconfig, vc):
        self.vc = vc

        # setup UI
        gtk.glade.bindtextdomain("system-config-display")
        if os.access("display.glade", os.F_OK):
            xml = gtk.glade.XML("display.glade", domain="system-config-display")
        else:
            xml = gtk.glade.XML("/usr/share/system-config-display/display.glade", domain="system-config-display")

        iconPixbuf = None
        try:
            iconPixbuf = gtk.gdk.pixbuf_new_from_file("/usr/share/system-config-display/pixmaps/system-config-display.png")
            xml.get_widget("display_dialog").set_icon(iconPixbuf)
        except:
            pass

        self.autoconfig_monitor = 0
        self.state = hardware_state
        self.xconfig = xconfig
        self.xml = xml
        self.depth_option_menu = self.xml.get_widget("depth_option_menu")
        self.depth_option_menu.connect("changed", self.depth_changed)
        self.res_option_menu = self.xml.get_widget("res_option_menu")
        self.res_option_menu.connect("changed", self.update_ui)
        self.thousands_menu_item = self.xml.get_widget("thousands_menu_item")
        self.thousands_menu_item.set_data("DEPTH", 16)
        self.millions_menu_item = self.xml.get_widget("millions_menu_item")
        self.millions_menu_item.set_data("DEPTH", 24)
        
        self.secondDepthOptionMenu = self.xml.get_widget("secondDepthOptionMenu")
        self.thousands_menu_item = self.xml.get_widget("thousands_menu_item_2")
        self.thousands_menu_item.set_data("DEPTH", 16)
        self.millions_menu_item = self.xml.get_widget("millions_menu_item_2")
        self.millions_menu_item.set_data("DEPTH", 24)
        
        self.size_preview = screenSizePreview.ScreenSizePreview(xml.get_widget("screenshot_darea"),114,86)

        self.resolution_radio = {}
        self.monitor_dialog = None
        self.videocard_dialog = None
        self.second_monitor_dialog = None
        self.second_videocard_dialog = None

        self.setup_sizegroups()
        self.state.recalc_mode()
        self.setup_ui_resolution(self.state.get_resolution())

        depth = self.state.get_colordepth()
        available = self.state.available_color_depths()

        if depth in available:
            self.depth_option_menu.set_history(available.index(depth))
            self.secondDepthOptionMenu.set_history(available.index(depth))
            
        xml.get_widget("monitor_top_image").set_from_file("/usr/share/system-config-display/pixmaps/monitor-top.png")
        xml.get_widget("monitor_base_image").set_from_file("/usr/share/system-config-display/pixmaps/monitor-base.png")

        # Stops the monitor image from looking weird in RTL locales
        if (self.xml.get_widget("display_dialog").get_direction() == gtk.TEXT_DIR_RTL):
            xml.get_widget("monitor_left_image").set_from_file("/usr/share/system-config-display/pixmaps/monitor-right.png")
            xml.get_widget("monitor_right_image").set_from_file("/usr/share/system-config-display/pixmaps/monitor-left.png")
        else:
            xml.get_widget("monitor_left_image").set_from_file("/usr/share/system-config-display/pixmaps/monitor-left.png")
            xml.get_widget("monitor_right_image").set_from_file("/usr/share/system-config-display/pixmaps/monitor-right.png")
        
        #Set the monitor and videocard labels on the hardware page
        if self.state.get_monitor_name().lower() == "unknown monitor" and self.state.monitor:
            self.state.set_monitor_name(self.state.monitor.getMonitorName())

        xml.get_widget("monitor_type_label").set_text(self.state.get_monitor_name())
        xml.get_widget("videocard_type_label").set_text(self.state.get_videocard_name())
        xml.get_widget("hardware_monitor_icon").set_from_file(
            "/usr/share/system-config-display/pixmaps/monitor.png")
        xml.get_widget("hardware_videocard_icon").set_from_file(
            "/usr/share/system-config-display/pixmaps/videocard.png")        
        

        #Set up the dualhead page
        self.enableCheckButton = xml.get_widget("enableCheckButton")
        self.enableCheckButton.connect("toggled", self.enable_toggled)

        self.mon1 = xml.get_widget("mon_image_1")
        self.mon1.set_from_file("/usr/share/system-config-display/pixmaps/monitor-on.png")

        self.mon2 = xml.get_widget("mon_image_2")
        self.mon2.set_from_file("/usr/share/system-config-display/pixmaps/monitor-off.png")       

        self.settingTable = xml.get_widget("settingTable")

        available_resolutions = self.state.available_resolutions()

        res_menu = gtk.Menu()
        count = 0
        current = 0
        for res in available_resolutions:
            item = gtk.MenuItem(res)
            item.set_data("RESOLUTION", res)
            res_menu.append(item)
            if res == self.state.get_resolution():
                #Let's remember which position is the current resolution
                current = count
            count = count + 1

        self.secondResolutionOptionMenu = self.xml.get_widget("secondResolutionOptionMenu")
        self.secondResolutionOptionMenu.set_menu(res_menu)
        #Select the correct menu item
        self.secondResolutionOptionMenu.set_history(current)
        self.secondResolutionOptionMenu.show_all()

        self.hal_videocard_list = self.hal_pci_video_card_list()

        if self.state.get_xconfig():
            #If the XF86Config file already exists
            monitor_list = self.state.xconfig.monitor
            videocard_list = self.state.xconfig.device
            screen_list = self.state.xconfig.screen
        else:
            monitor_list = []
            videocard_list = []
            screen_list = []

        videocard_menu = gtk.Menu()

        for card in self.hal_videocard_list:
	    desc = card.GetProperty("info.vendor") + " " + card.GetProperty("info.product")
            item = gtk.MenuItem(desc)
            item.set_data("NAME", desc)
            videocard_menu.append(item)

        self.secondVideocardOptionMenu = xml.get_widget("secondVideocardOptionMenu")
        self.secondVideocardOptionMenu.set_menu(videocard_menu)
        self.secondVideocardOptionMenu.set_history(1)
        self.secondVideocardOptionMenu.show_all()

        if len(self.xconfig.layout[0].adjacencies) > 1:
            #There are more than one screens currently configured, so enbable button
            self.enableCheckButton.set_active(True)


        if len(monitor_list) == 0:
            self.get_monitor_from_display(self.state)
            if self.state.get_monitor_name().lower() == 'unknown monitor':
                self.state.set_monitor_name(_("(autoconfigured)"))
            self.autoconfig_monitor = 1
            self.state.recalc_mode()
            try:
                import rhpxl._pyrandr
                res = rhpxl._pyrandr.getRes(0)
                self.state.set_resolution("%sx%s" % (res[0], res[1]))
            except:
                pass
            self.setup_ui_resolution(self.state.get_resolution())            
            self.update_ui()
            
        if len(monitor_list) > 1:
            self.second_monitor_model = monitor_list[1].modelname
            self.second_monitor_vrefresh = monitor_list[1].vrefresh[0]
            self.second_monitor_hsync = monitor_list[1].hsync[0]
            self.xml.get_widget("secondMonitorLabel").set_text(monitor_list[1].modelname)
            xml.get_widget("secondMonitorButton").connect("clicked", self.configure_second_monitor, monitor_list[1].modelname)

        if len(self.xconfig.screen) > 1:
            depth = self.xconfig.screen[1].defaultdepth
            if depth == 8:
                self.secondDepthOptionMenu.set_history(0)
            elif depth == 16:
                self.secondDepthOptionMenu.set_history(1)
            elif depth == 24:
                self.secondDepthOptionMenu.set_history(2)
            self.secondDepthOptionMenu.show_all()

        if self.xconfig:
            try:
                #See if there are any layout options
                layout_options = self.xconfig.layout[0].options
                for opt in layout_options:
                    if opt.name == "Xinerama":
                        if string.lower(opt.val) == "on":
                            self.xml.get_widget("layoutOptionMenu").set_history(1)
                        else:
                            self.xml.get_widget("layoutOptionMenu").set_history(0)
            except:
                #There are no layout options, so pass
                pass
                
        xml.get_widget("secondMonitorButton").connect("clicked", self.configure_second_monitor, monitor_list)

        xml.get_widget("ok_button").connect("clicked", self.ok)
        xml.get_widget("cancel_button").connect("clicked", self.cancel)
        xml.get_widget("display_dialog").connect("delete_event", self.delete)
        xml.get_widget("monitorConfigButton").connect("clicked", self.configure_monitor,
                                                      self.state.get_monitor_name())
        xml.get_widget("videocardConfigButton").connect("clicked", self.configure_videocard)        

