#!/usr/bin/python2
## screenSizePreview.py - code to do the screenshot preview
## Copyright (C) 2001-2003 Red Hat, Inc.

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import gtk

TRUE = 1
FALSE = 0

class ScreenSizePreview:
    max_width = 1600
    max_height = 1200
        
    def screen_expose(self, widget, event):
        gc = widget.window.new_gc()
	gc.set_rgb_fg_color(widget.style.black)
        widget.window.draw_rectangle(gc, TRUE, 0,0, self.widget_width, self.widget_height)

        widget.window.draw_pixbuf (None, self.screenshot,
                                   0, 0,
                                   (self.widget_width - self.screenshot.get_width())/2,
                                   (self.widget_height - self.screenshot.get_height())/2,
                                   self.screenshot.get_width(), self.screenshot.get_height(),
                                   gtk.gdk.RGB_DITHER_MAX, 0, 0)
        w = self.res_x * self.widget_width / self.max_width - 1
        h = self.res_y * self.widget_height / self.max_height - 1
        widget.window.draw_rectangle(self.gc, FALSE,
                                     (self.widget_width - w)/2,
                                     (self.widget_height - h)/2,
                                     w,h)

    def realize(self, widget):
        self.gc = widget.window.new_gc()
        self.gc.set_background(widget.get_style().white)
        self.gc.set_foreground(widget.get_style().black)
        self.gc.set_line_attributes(0, gtk.gdk.LINE_DOUBLE_DASH,
                                    gtk.gdk.CAP_BUTT, gtk.gdk.JOIN_MITER)

    def __init__(self, widget, widget_width, widget_height):
        self.widget_width = widget_width
        self.widget_height = widget_height
        self.widget = None
        
        screenshot = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, FALSE, 8,
                                    gtk.gdk.screen_width(), gtk.gdk.screen_height())
        screenshot.get_from_drawable(gtk.gdk.get_default_root_window(),
                                     gtk.gdk.colormap_get_system(),
                                     0, 0, 0, 0,
                                     gtk.gdk.screen_width(), gtk.gdk.screen_height())
        self.screenshot = screenshot.scale_simple(gtk.gdk.screen_width() * widget_width / self.max_width,
                                                  gtk.gdk.screen_height() * widget_height / self.max_height,
                                                  gtk.gdk.INTERP_BILINEAR)

        self.connect_to(widget)


    def set_resolution(self, res_x, res_y):
        self.res_x = res_x
        self.res_y = res_y
        if self.widget != None:
            self.widget.queue_draw()

    def connect_to(self, widget):
        self.widget = widget
        widget.connect("expose_event", self.screen_expose)
        widget.connect_after("realize", self.realize)

