/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.converters.StringToInteger;
import org.eclipse.xwt.tools.ui.designer.commands.SetStyleCommand;
import org.eclipse.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.xwt.tools.ui.designer.core.style.SWTStyles;
import org.eclipse.xwt.tools.ui.designer.core.style.StyleGroup;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.xwt.tools.ui.designer.utils.StyleHelper;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class StyleAction
extends Action
implements IMenuCreator {
    public static final String ID = StyleAction.class.getName();
    private WidgetEditPart editPart;
    private MenuManager menuManager;

    public StyleAction(WidgetEditPart editPart) {
        this.editPart = editPart;
        this.setId(ID);
        this.setText("Style");
        this.setMenuCreator(this);
    }

    public boolean isEnabled() {
        EObject object;
        Object model = this.editPart.getModel();
        if (model instanceof EObject && (object = (EObject)model).eContainer() == null) {
            return false;
        }
        return super.isEnabled();
    }

    protected MenuManager createMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            Widget widget = this.editPart.getWidget();
            if (widget != null && !widget.isDisposed()) {
                int masterStyle = widget.getStyle();
                StyleGroup[] styles = SWTStyles.getStyles(widget.getClass());
                Separator last = null;
                StyleGroup[] styleGroupArray = styles;
                int n = styles.length;
                int n2 = 0;
                while (n2 < n) {
                    StyleGroup styleGroup = styleGroupArray[n2];
                    if (styleGroup.match(masterStyle)) {
                        String[] items = styleGroup.getStyles();
                        String groupName = styleGroup.getGroupName();
                        String[] stringArray = items;
                        int n3 = items.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String style = stringArray[n4];
                            XamlNode node = this.editPart.getCastModel();
                            SetStyleAction action = new SetStyleAction(node, styleGroup, style, "default".equals(groupName) ? 2 : 8);
                            boolean checked = StyleHelper.checkStyle(masterStyle, style);
                            boolean specified = false;
                            XamlAttribute attribute = node.getAttribute("style", "http://www.eclipse.org/xwt");
                            if (attribute != null) {
                                int xmlValue = (Integer)StringToInteger.instance.convert((Object)attribute.getValue());
                                int value = (Integer)StringToInteger.instance.convert((Object)style);
                                specified = StyleHelper.checkStyle(xmlValue, value);
                            }
                            if (checked) {
                                action.setEnabled(specified);
                            } else {
                                action.setEnabled(true);
                            }
                            action.setChecked(checked);
                            this.menuManager.add((IAction)action);
                            ++n4;
                        }
                        last = new Separator(groupName);
                        this.menuManager.add((IContributionItem)last);
                    }
                    ++n2;
                }
                if (last != null) {
                    this.menuManager.remove(last);
                }
            }
        }
        return this.menuManager;
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
    }

    public Menu getMenu(Control parent) {
        MenuManager mm = this.createMenuManager();
        if (mm != null) {
            return mm.createContextMenu(parent);
        }
        return null;
    }

    public Menu getMenu(Menu parent) {
        MenuManager mm = this.createMenuManager();
        if (mm != null) {
            Menu menu = new Menu(parent);
            IContributionItem[] items = mm.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item;
                IContributionItem newItem = item = items[i];
                if (item instanceof ActionContributionItem) {
                    newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
                }
                newItem.fill(menu, -1);
                ++i;
            }
            return menu;
        }
        return null;
    }

    private class SetStyleAction
    extends Action {
        private String newStyle;
        private XamlNode node;
        private StyleGroup group;

        public SetStyleAction(XamlNode node, StyleGroup group, String newStyle, int actionStyle) {
            super(newStyle, actionStyle);
            this.node = node;
            this.group = group;
            this.newStyle = newStyle;
        }

        public void run() {
            if (this.getStyle() == 8 && !this.isChecked()) {
                return;
            }
            SetStyleCommand command = new SetStyleCommand(this.node, this.newStyle, this.group);
            if (this.getStyle() == 2) {
                command.setRemove(!this.isChecked());
            }
            EditDomain.getEditDomain((EditPart)StyleAction.this.editPart).getCommandStack().execute((Command)command);
        }
    }
}

