/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor.checkers;

import java.util.List;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.xwt.ui.editor.checkers.AbstractProblemChecker;
import org.eclipse.xwt.vex.problems.Problem;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IntegerPropertyChecker
extends AbstractProblemChecker {
    @Override
    protected void checkProblems(StructuredTextEditor textEditor, String javaName, Node node, List<Problem> problems, boolean includeChildren) {
        if (!this.isValid(node)) {
            return;
        }
        NodeList childNodes = node.getChildNodes();
        if (includeChildren && childNodes != null) {
            int length = childNodes.getLength();
            int i = 0;
            while (i < length) {
                Node child = childNodes.item(i);
                this.checkProblems(textEditor, javaName, child, problems, includeChildren);
                ++i;
            }
        }
        String nodeName = this.getTagName(node);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            boolean isDb;
            Node attr = attributes.item(i);
            String attrName = this.getTagName(attr);
            if (attrName != null && (isDb = this.isInteger(node, attrName))) {
                String nodeValue = attr.getNodeValue();
                double value = -1.0;
                try {
                    value = Integer.parseInt(nodeValue);
                }
                catch (NumberFormatException e) {
                    Problem problem = this.createProblem(textEditor, node, "Error Integer Format for Property \"" + attrName + "\" of \"" + nodeName + "\".", 3);
                    problems.add(problem);
                }
                if (value <= 0.0) {
                    Problem problem;
                    if (attrName.equals("ColumnSpan")) {
                        problem = this.createProblem(textEditor, node, "\"ColumnSpan\" must more than 0.", 3);
                        problems.add(problem);
                    } else if (attrName.equals("RowSpan")) {
                        problem = this.createProblem(textEditor, node, "\"RowSpan\" must more than 0.", 3);
                        problems.add(problem);
                    }
                }
            }
            ++i;
        }
    }

    private boolean isInteger(Node node, String attrName) {
        String nodeName = this.getTagName(node);
        if (nodeName == null) {
            return false;
        }
        return false;
    }
}

