/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.utils;

import java.util.List;
import org.eclipse.wb.core.model.IRootProcessor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.DisplayEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class AsyncMessagesSupport
implements IRootProcessor {
    public static final IRootProcessor INSTANCE = new AsyncMessagesSupport();

    private AsyncMessagesSupport() {
    }

    public void process(JavaInfo root, List<JavaInfo> components) throws Exception {
        this.processRoot(root);
    }

    private void processRoot(final JavaInfo rootJavaInfo) {
        rootJavaInfo.addBroadcastListener((Object)new ObjectEventListener(){

            public void refreshAfterCreate() throws Exception {
                AsyncMessagesSupport.this.runAsyncMessagesIfNeeded(rootJavaInfo);
            }
        });
    }

    private void runAsyncMessagesIfNeeded(JavaInfo rootJavaInfo) throws Exception {
        if (AsyncMessagesSupport.requiresAsyncMessages(rootJavaInfo)) {
            EditorState editorState = JavaInfoUtils.getState((JavaInfo)rootJavaInfo);
            ((DisplayEventListener)editorState.getBroadcast().getListener(DisplayEventListener.class)).beforeMessagesLoop();
            try {
                this.runAllAsyncMessages(editorState);
            }
            finally {
                ((DisplayEventListener)editorState.getBroadcast().getListener(DisplayEventListener.class)).afterMessagesLoop();
            }
        }
    }

    private void runAllAsyncMessages(EditorState editorState) throws ClassNotFoundException, Exception {
        ClassLoader classLoader = editorState.getEditorLoader();
        Class<?> displayClass = classLoader.loadClass("org.eclipse.swt.widgets.Display");
        Object display = ReflectionUtils.invokeMethod(displayClass, (String)"getDefault()", (Object[])new Object[0]);
        Object synchronizer = ReflectionUtils.getFieldObject((Object)display, (String)"synchronizer");
        ReflectionUtils.invokeMethod((Object)synchronizer, (String)"runAsyncMessages(boolean)", (Object[])new Object[]{true});
    }

    private static boolean requiresAsyncMessages(JavaInfo javaInfo) {
        for (JavaInfo child : javaInfo.getChildrenJava()) {
            if (!AsyncMessagesSupport.requiresAsyncMessages(child)) continue;
            return true;
        }
        return JavaInfoUtils.hasTrueParameter((JavaInfo)javaInfo, (String)"SWT.runAsyncMessages");
    }
}

