/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.binding;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.IDataProvider;
import org.eclipse.wb.internal.core.utils.binding.ValidationStatus;

public final class Binding {
    private final IDataEditor m_editor;
    private final IDataProvider m_provider;

    public Binding(IDataEditor editor, IDataProvider provider) {
        this.m_editor = editor;
        this.m_provider = provider;
    }

    void updateEditor(boolean def) {
        Object value = this.m_provider.getValue(def);
        this.m_editor.setValue(value);
    }

    IStatus updateProvider() {
        try {
            Object value = this.m_editor.getValue();
            this.m_provider.setValue(value);
            return ValidationStatus.STATUS_OK;
        }
        catch (Throwable e) {
            return ValidationStatus.error(e.getMessage(), e);
        }
    }
}

