/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.gef.part;

import org.eclipse.wb.core.gef.policy.layout.LayoutPolicyUtils;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.policies.IRefreshableEditPolicy;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.xwt.gef.part.ControlEditPart;
import org.eclipse.wb.internal.xwt.gef.policy.DropLayoutEditPolicy;
import org.eclipse.wb.internal.xwt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;

public class CompositeEditPart
extends ControlEditPart {
    private final CompositeInfo m_composite;
    private LayoutInfo m_currentLayout;

    public CompositeEditPart(CompositeInfo composite) {
        super(composite);
        this.m_composite = composite;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        if (this.m_composite.hasLayout()) {
            this.installEditPolicy((EditPolicy)new DropLayoutEditPolicy(this.m_composite));
        }
    }

    protected void refreshEditPolicies() {
        super.refreshEditPolicies();
        if (this.m_composite.hasLayout()) {
            LayoutInfo layout = this.m_composite.getLayout();
            if (this.m_currentLayout != layout) {
                this.m_currentLayout = layout;
                LayoutEditPolicy policy = LayoutPolicyUtils.createLayoutEditPolicy((EditPart)this, (Object)((Object)layout));
                this.installEditPolicy("LayoutEditPolicy", (EditPolicy)policy);
            } else {
                EditPolicy policy = this.getEditPolicy("LayoutEditPolicy");
                if (policy instanceof IRefreshableEditPolicy) {
                    ((IRefreshableEditPolicy)policy).refreshEditPolicy();
                }
            }
        }
    }
}

