/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.JavadocCoverage;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.api.TestCoverage;
import org.eclipse.wtp.releng.tools.component.internal.ComponentObject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentAPI
extends ComponentObject {
    public static final String CONST_COMPONENT_API = "component-api.xml";
    private static final String ELEMENT_COMPONENT_API = "component-api";
    private static final String ELEMENT_PACKAGE_API = "package-api";
    private static final String ELEMENT_CLASS_API = "class-api";
    private static final String ELEMENT_METHOD_API = "method-api";
    private static final String ELEMENT_FIELD_API = "field-api";
    private static final String ELEMENT_TEST_COVERAGE = "test-coverage";
    private static final String ELEMENT_TEST = "test";
    private static final String ELEMENT_JAVADOC_COVERAGE = "javadoc-coverage";
    private static final String ELEMENT_PARAM = "param";
    private static final String ELEMENT_THROW = "throw";
    private static final String ATTR_ACCESS = "access";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SUPER = "super";
    private static final String ATTR_INTERFACES = "interfaces";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_DESCRIPTOR = "descriptor";
    private static final String ATTR_REFERENCE = "reference";
    private static final String ATTR_IMPLEMENT = "implement";
    private static final String ATTR_SUBCLASS = "subclass";
    private static final String ATTR_INSTANTIATE = "instantiate";
    private static final String ATTR_THROWS = "throws";
    private static final String ATTR_SINCE = "since";
    private static final String ATTR_RETURN = "return";
    protected ILocation location;
    protected String name;
    protected String timestamp;
    private Map packageAPIs;
    private boolean reload = false;

    public ILocation getLocation() {
        return this.location;
    }

    public void setLocation(ILocation location) {
        this.location = location;
        this.reload = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public Collection getPackageAPIs() {
        if (this.packageAPIs == null) {
            this.packageAPIs = new HashMap(1);
        }
        return this.packageAPIs.values();
    }

    public PackageAPI getPackageAPI(String name) {
        if (this.packageAPIs == null) {
            return null;
        }
        return (PackageAPI)this.packageAPIs.get(name);
    }

    public void addPackageAPI(PackageAPI pkgAPI) {
        if (this.packageAPIs == null) {
            this.packageAPIs = new HashMap(1);
        }
        this.packageAPIs.put(pkgAPI.getName(), pkgAPI);
    }

    public void load() throws IOException, FileNotFoundException {
        if (this.reload) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(false);
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                parser.parse(new InputSource(new BufferedInputStream(this.location.getInputStream())), (DefaultHandler)new ComponentAPIHandler(this));
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
            catch (SAXException saxe) {
                saxe.printStackTrace();
            }
            this.reload = false;
        }
    }

    public void saveAsHTML(ILocation html, String xsl) throws TransformerConfigurationException, TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(ClassLoader.getSystemResourceAsStream(xsl)));
        transformer.transform(new StreamSource(new ByteArrayInputStream(this.toString().getBytes())), new StreamResult(new FileOutputStream(new File(html.getAbsolutePath()))));
    }

    public void save() throws IOException {
        if (this.location != null) {
            File file = new File(this.location.getAbsolutePath());
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(this.toString().getBytes());
            fos.close();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<component-api ");
        sb.append(this.toAttribute(ATTR_NAME, this.getName()));
        sb.append(this.toAttribute(ATTR_TIMESTAMP, this.getTimestamp()));
        sb.append(">");
        Iterator it = this.getPackageAPIs().iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
        }
        sb.append("</component-api>");
        return sb.toString();
    }

    protected static class ComponentAPIHandler
    extends DefaultHandler {
        private ComponentAPI compAPI;
        private PackageAPI packageAPI;
        private ClassAPI classAPI;
        private MethodAPI methodAPI;
        private FieldAPI fieldAPI;
        private TestCoverage testCoverage;
        private JavadocCoverage javadocCoverage;
        private boolean classJavadoc;
        private boolean methodJavadoc;
        private boolean fieldJavadoc;

        public ComponentAPIHandler(ComponentAPI compAPI) {
            this.compAPI = compAPI;
            this.classJavadoc = true;
            this.methodJavadoc = false;
            this.fieldJavadoc = false;
        }

        public void startElement(String uri, String elementName, String qName, Attributes attributes) throws SAXException {
            if (elementName.equals(ComponentAPI.ELEMENT_TEST_COVERAGE) || qName.equals(ComponentAPI.ELEMENT_TEST_COVERAGE)) {
                if (this.methodAPI != null) {
                    this.testCoverage = new TestCoverage();
                    this.methodAPI.setTestCoverage(this.testCoverage);
                }
            } else if (elementName.equals(ComponentAPI.ELEMENT_TEST) || qName.equals(ComponentAPI.ELEMENT_TEST)) {
                String name;
                if (this.testCoverage != null && (name = attributes.getValue(ComponentAPI.ATTR_NAME)) != null) {
                    this.testCoverage.addTest(name);
                }
            } else if (elementName.equals(ComponentAPI.ELEMENT_JAVADOC_COVERAGE) || qName.equals(ComponentAPI.ELEMENT_JAVADOC_COVERAGE)) {
                String hasReturn;
                this.javadocCoverage = new JavadocCoverage();
                String hasSince = attributes.getValue(ComponentAPI.ATTR_SINCE);
                if (hasSince != null) {
                    this.javadocCoverage.setHasSince(Boolean.valueOf(hasSince));
                }
                if ((hasReturn = attributes.getValue(ComponentAPI.ATTR_RETURN)) != null) {
                    this.javadocCoverage.setHasReturn(Boolean.valueOf(hasReturn));
                }
                if (this.classJavadoc && this.classAPI != null) {
                    this.classAPI.setJavadocCoverage(this.javadocCoverage);
                } else if (this.methodJavadoc && this.methodAPI != null) {
                    this.methodAPI.setJavadocCoverage(this.javadocCoverage);
                } else if (this.fieldJavadoc && this.fieldAPI != null) {
                    this.fieldAPI.setJavadocCoverage(this.javadocCoverage);
                }
            } else if (elementName.equals(ComponentAPI.ELEMENT_PARAM) || qName.equals(ComponentAPI.ELEMENT_PARAM)) {
                String name;
                if (this.javadocCoverage != null && (name = attributes.getValue(ComponentAPI.ATTR_NAME)) != null) {
                    this.javadocCoverage.addMissingParam(name);
                }
            } else if (elementName.equals(ComponentAPI.ELEMENT_THROW) || qName.equals(ComponentAPI.ELEMENT_THROW)) {
                String name;
                if (this.javadocCoverage != null && (name = attributes.getValue(ComponentAPI.ATTR_NAME)) != null) {
                    this.javadocCoverage.addMissingThrow(name);
                }
            } else if (elementName.equals(ComponentAPI.ELEMENT_METHOD_API) || qName.equals(ComponentAPI.ELEMENT_METHOD_API)) {
                this.classJavadoc = false;
                this.methodJavadoc = true;
                this.fieldJavadoc = false;
                this.methodAPI = new MethodAPI();
                this.startMethod(this.classAPI, this.methodAPI, attributes);
            } else if (elementName.equals(ComponentAPI.ELEMENT_FIELD_API) || qName.equals(ComponentAPI.ELEMENT_FIELD_API)) {
                this.classJavadoc = false;
                this.methodJavadoc = false;
                this.fieldJavadoc = true;
                this.fieldAPI = new FieldAPI();
                this.startField(this.classAPI, this.fieldAPI, attributes);
            } else if (elementName.equals(ComponentAPI.ELEMENT_CLASS_API) || qName.equals(ComponentAPI.ELEMENT_CLASS_API)) {
                this.classJavadoc = true;
                this.methodJavadoc = false;
                this.fieldJavadoc = false;
                if (this.packageAPI != null) {
                    String attrInstantiate;
                    String attrSubclass;
                    String attrImpl;
                    String attrRef;
                    String attrAccess;
                    String attrInterfaces;
                    this.classAPI = new ClassAPI();
                    this.classAPI.setName(attributes.getValue(ComponentAPI.ATTR_NAME));
                    String attrSuper = attributes.getValue(ComponentAPI.ATTR_SUPER);
                    if (attrSuper != null) {
                        this.classAPI.setSuperClass(attrSuper);
                    }
                    if ((attrInterfaces = attributes.getValue(ComponentAPI.ATTR_INTERFACES)) != null) {
                        StringTokenizer st = new StringTokenizer(attrInterfaces, " ");
                        while (st.hasMoreTokens()) {
                            this.classAPI.addInterface(st.nextToken());
                        }
                    }
                    if ((attrAccess = attributes.getValue(ComponentAPI.ATTR_ACCESS)) != null) {
                        this.classAPI.setAccess(Integer.parseInt(attrAccess));
                    }
                    if ((attrRef = attributes.getValue(ComponentAPI.ATTR_REFERENCE)) != null) {
                        this.classAPI.setReference(Boolean.valueOf(attrRef));
                    }
                    if ((attrImpl = attributes.getValue(ComponentAPI.ATTR_IMPLEMENT)) != null) {
                        this.classAPI.setImplement(Boolean.valueOf(attrImpl));
                    }
                    if ((attrSubclass = attributes.getValue(ComponentAPI.ATTR_SUBCLASS)) != null) {
                        this.classAPI.setSubclass(Boolean.valueOf(attrSubclass));
                    }
                    if ((attrInstantiate = attributes.getValue(ComponentAPI.ATTR_INSTANTIATE)) != null) {
                        this.classAPI.setInstantiate(Boolean.valueOf(attrInstantiate));
                    }
                    this.packageAPI.addClassAPI(this.classAPI);
                }
            } else if (elementName.equals(ComponentAPI.ELEMENT_PACKAGE_API) || qName.equals(ComponentAPI.ELEMENT_PACKAGE_API)) {
                this.packageAPI = new PackageAPI();
                this.packageAPI.setName(attributes.getValue(ComponentAPI.ATTR_NAME));
                this.compAPI.addPackageAPI(this.packageAPI);
            } else if (this.equalsLocalpart(elementName, ComponentAPI.ELEMENT_COMPONENT_API) || this.equalsLocalpart(qName, ComponentAPI.ELEMENT_COMPONENT_API)) {
                this.compAPI.setName(attributes.getValue(ComponentAPI.ATTR_NAME));
                this.compAPI.setTimestamp(attributes.getValue(ComponentAPI.ATTR_TIMESTAMP));
            }
        }

        private boolean equalsLocalpart(String fullname, String localpart) {
            int index = fullname.indexOf(58);
            if (index != -1) {
                return fullname.substring(index + 1).equals(localpart);
            }
            return fullname.equals(localpart);
        }

        protected void startMethod(ClassAPI cAPI, MethodAPI methodAPI, Attributes attributes) throws SAXException {
            if (cAPI != null) {
                String attrThrows;
                methodAPI.setName(attributes.getValue(ComponentAPI.ATTR_NAME));
                methodAPI.setDescriptor(attributes.getValue(ComponentAPI.ATTR_DESCRIPTOR));
                String attrAccess = attributes.getValue(ComponentAPI.ATTR_ACCESS);
                if (attrAccess != null) {
                    methodAPI.setAccess(Integer.parseInt(attrAccess));
                }
                if ((attrThrows = attributes.getValue(ComponentAPI.ATTR_THROWS)) != null) {
                    methodAPI.addThrows(this.toCollection(attrThrows, " "));
                }
                cAPI.addMethodAPI(methodAPI);
            }
        }

        protected Collection toCollection(String value, String delimiter) {
            StringTokenizer st = new StringTokenizer(value, delimiter);
            ArrayList<String> list = new ArrayList<String>(st.countTokens());
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            return list;
        }

        protected void startField(ClassAPI cAPI, FieldAPI fAPI, Attributes attributes) throws SAXException {
            if (cAPI != null) {
                fAPI.setName(attributes.getValue(ComponentAPI.ATTR_NAME));
                fAPI.setDescriptor(attributes.getValue(ComponentAPI.ATTR_DESCRIPTOR));
                String attrAccess = attributes.getValue(ComponentAPI.ATTR_ACCESS);
                if (attrAccess != null) {
                    fAPI.setAccess(Integer.parseInt(attrAccess));
                }
                cAPI.addFieldAPI(fAPI);
            }
        }
    }
}

